/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.castor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:castor-maven-plugin:1.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Castor Maven Plugin", 0);
        this.append(sb, "The Castor plugin is a Maven plugin that provides the functionality of Castor's SourceGenerator for generating Java beans and associated Marshallers and Unmarshallers from XML Schema files.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "castor:generate", 0);
            this.append(sb, "A mojo that uses Castor to generate a collection of javabeans from an XSD. Detailed explanations of many of these can be found in the details for the Castor SourceGenerator.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bindingfile", 2);
                this.append(sb, "The binding file to use for mapping xml to java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "createJdoDescriptors (Default: false)", 2);
                this.append(sb, "Whether to generate JDO-specific descriptor classes or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptors (Default: true)", 2);
                this.append(sb, "If true, generate descriptors", 3);
                this.append(sb, "", 0);
                this.append(sb, "dest", 2);
                this.append(sb, "The directory to output the generated sources to", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateImportedSchemas (Default: false)", 2);
                this.append(sb, "Whether to generate Java classes from imported XML schemas or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateMappings (Default: false)", 2);
                this.append(sb, "Set to true to generate Castor XML class mappings for the Java classes generated by the XML code generator from imported XML schemas.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineSeparator", 2);
                this.append(sb, "The line separator to use in generated source. Can be either win, unix, or mac", 3);
                this.append(sb, "", 0);
                this.append(sb, "marshal (Default: true)", 2);
                this.append(sb, "if false, don't generate the marshaller", 3);
                this.append(sb, "", 0);
                this.append(sb, "packaging", 2);
                this.append(sb, "The package for the generated source", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project to act upon.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "The castorbuilder.properties file to use", 3);
                this.append(sb, "", 0);
                this.append(sb, "schema", 2);
                this.append(sb, "A schema file to process. If this is not set then all .xsd files in schemaDirectory will be processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaDirectory", 2);
                this.append(sb, "The source directory containing *.xsd files", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation", 3);
                this.append(sb, "", 0);
                this.append(sb, "tstamp", 2);
                this.append(sb, "The directory to store the processed xsds. The timestamps of these xsds are used to determine if the source for that xsd need to be regenerated", 3);
                this.append(sb, "", 0);
                this.append(sb, "types (Default: arraylist)", 2);
                this.append(sb, "Castor collection types. Allowable values are 'vector', 'arraylist', 'j2' or 'odmg' 'j2' and 'arraylist' are the same.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Verbose output during generation", 3);
                this.append(sb, "", 0);
                this.append(sb, "warnings (Default: false)", 2);
                this.append(sb, "Enable warning messages", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "castor:help", 0);
            this.append(sb, "Display help information on castor-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0castor:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "mapping".equals(this.goal)) {
            this.append(sb, "castor:mapping", 0);
            this.append(sb, "A mojo that uses Castor MappingTool to generate mapping files from a single Class. MappingTool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "className", 2);
                this.append(sb, "The name of the Java class from which a mapping file should be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Whether to force generation of mapping file where one already exists.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappingName", 2);
                this.append(sb, "Name of the mapping file to be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory}/)", 2);
                this.append(sb, "The output directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project to act upon.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "mappings".equals(this.goal)) {
            this.append(sb, "castor:mappings", 0);
            this.append(sb, "A mojo that uses Castor MappingTool to generate mapping files from a set of Classes. MappingTool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classes", 2);
                this.append(sb, "A set of Java classes for which a mapping file should be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Whether to force generation of mapping file where one already exists.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory}/)", 2);
                this.append(sb, "The output directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project to act upon.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

