/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.mojo.appassembler.AbstractAppAssemblerMojo;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractScriptGeneratorMojo
extends AbstractAppAssemblerMojo {
    @Parameter
    protected String environmentSetupFileName;
    @Parameter
    protected File licenseHeaderFile;
    @Parameter(property="unixScriptTemplate")
    protected String unixScriptTemplate;
    @Parameter(defaultValue="false")
    protected boolean useWildcardClassPath;
    @Parameter(property="windowsScriptTemplate")
    protected String windowsScriptTemplate;
    @Parameter(defaultValue="${project.runtimeArtifacts}", readonly=true)
    protected List<Artifact> artifacts;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="true")
    protected boolean generateRepository;
    @Parameter(defaultValue="etc")
    protected String configurationDirectory;
    @Parameter(defaultValue="src/main/config")
    protected File configurationSourceDirectory;
    @Parameter(defaultValue="false")
    protected boolean copyConfigurationDirectory;
    @Parameter
    protected String endorsedDir;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    protected boolean filterConfigurationDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="logsDirectory")
    protected String logsDirectory;
    @Parameter(property="tempDirectory")
    protected String tempDirectory;
    @Component
    protected DaemonGeneratorService daemonGeneratorService;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;

    protected void doCopyConfigurationDirectory(String targetDirectory) throws MojoFailureException {
        if (!this.configurationSourceDirectory.exists()) {
            throw new MojoFailureException("The source directory for configuration files does not exist: " + this.configurationSourceDirectory.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)"copying configuration directory.");
        Resource resource = new Resource();
        resource.setDirectory(this.configurationSourceDirectory.getAbsolutePath());
        resource.setFiltering(this.filterConfigurationDirectory);
        resource.setTargetPath(this.configurationDirectory);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), this.mavenProject, this.encoding, this.buildFilters, Collections.emptyList(), this.session);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setIncludeEmptyDirs(true);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        try {
            this.getLog().debug((CharSequence)("Will try to copy configuration files from " + this.configurationSourceDirectory.getAbsolutePath() + " to " + targetDirectory + FileUtils.FS + this.configurationDirectory));
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException mfe) {
            throw new MojoFailureException("Failed to copy/filter the configuration files.");
        }
    }

    protected void doCreateExtraDirectories(File targetDirectory) throws MojoFailureException {
        File tempDirectory;
        File logsDirectory;
        boolean success;
        if (this.logsDirectory != null && !(success = (logsDirectory = new File(targetDirectory, this.logsDirectory)).mkdirs())) {
            throw new MojoFailureException("Failed to create directory for log files.");
        }
        if (this.tempDirectory != null && !(success = (tempDirectory = new File(targetDirectory, this.tempDirectory)).mkdirs())) {
            throw new MojoFailureException("Failed to create directory for temp files.");
        }
    }

    protected void installDependencies(String outputDirectory, String repositoryName) throws MojoExecutionException, MojoFailureException {
        if (this.generateRepository) {
            ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + outputDirectory + "/" + repositoryName, this.getArtifactRepositoryLayout(), false);
            for (Artifact artifact : this.artifacts) {
                this.installArtifact(artifact, artifactRepository, this.useTimestampInSnapshotFileName);
            }
            this.installArtifact(this.projectArtifact, artifactRepository);
        }
    }
}

