/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.util.regex.Pattern;

public final class RegexUtils {
    public static final String REGEX_QUOTE_END = "\\E";
    public static final String REGEX_QUOTE_START = "\\Q";
    public static final String REGEX_QUOTE_END_ESCAPED = "\\E\\\\E\\Q";

    private RegexUtils() {
        throw new IllegalAccessError("Utility classes should never be instantiated");
    }

    public static String quote(String s) {
        int i = s.indexOf(REGEX_QUOTE_END);
        if (i == -1) {
            return REGEX_QUOTE_START + s + REGEX_QUOTE_END;
        }
        StringBuilder sb = new StringBuilder(s.length() + 32);
        sb.append(REGEX_QUOTE_START);
        int pos = 0;
        do {
            sb.append(s.substring(pos, i));
            sb.append(REGEX_QUOTE_END_ESCAPED);
        } while ((i = s.indexOf(REGEX_QUOTE_END, pos = i + REGEX_QUOTE_END.length())) != -1);
        sb.append(s.substring(pos, s.length()));
        sb.append(REGEX_QUOTE_END);
        return sb.toString();
    }

    public static String convertWildcardsToRegex(String wildcardRule, boolean exactMatch) {
        StringBuilder regex = new StringBuilder();
        int index = 0;
        int len = wildcardRule.length();
        while (index < len) {
            char c;
            int nextQ = wildcardRule.indexOf(63, index);
            int nextS = wildcardRule.indexOf(42, index);
            if (nextQ == -1 && nextS == -1) {
                regex.append(RegexUtils.quote(wildcardRule.substring(index)));
                break;
            }
            int nextIndex = nextQ == -1 ? nextS : (nextS == -1 ? nextQ : Math.min(nextQ, nextS));
            if (index < nextIndex) {
                regex.append(RegexUtils.quote(wildcardRule.substring(index, nextIndex)));
            }
            if ((c = wildcardRule.charAt(nextIndex)) == '?') {
                regex.append('.');
            } else {
                regex.append(".*");
            }
            index = nextIndex + 1;
        }
        if (!exactMatch) {
            regex.append(".*");
        }
        return regex.toString();
    }

    public static Pattern compileWildcard(String wildcard) {
        return Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcard, true));
    }
}

