/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.compress;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public class SevenZArchiveInputStream
extends ArchiveInputStream {
    private final SevenZFile zFile;
    private SevenZArchiveEntry currentEntry;
    private long currentBytesRead;

    public SevenZArchiveInputStream(File file) throws IOException {
        this.zFile = new SevenZFile(file);
    }

    public SevenZArchiveInputStream(File file, byte[] password) throws IOException {
        this.zFile = new SevenZFile(file, password);
    }

    public ArchiveEntry getNextEntry() throws IOException {
        SevenZArchiveEntry sevenZArchiveEntry;
        this.currentEntry = sevenZArchiveEntry = this.zFile.getNextEntry();
        this.currentBytesRead = 0L;
        if (sevenZArchiveEntry != null) {
            return new ArchiveEntry(){

                public String getName() {
                    return sevenZArchiveEntry.getName();
                }

                public long getSize() {
                    return sevenZArchiveEntry.getSize();
                }

                public boolean isDirectory() {
                    return sevenZArchiveEntry.isDirectory();
                }

                public Date getLastModifiedDate() {
                    return sevenZArchiveEntry.getLastModifiedDate();
                }
            };
        }
        return null;
    }

    public int read() throws IOException {
        if (this.currentEntry != null && this.currentEntry.hasStream() && !this.currentEntry.isAntiItem()) {
            int totalRead = this.zFile.read();
            if (totalRead >= 0) {
                this.count(1);
                ++this.currentBytesRead;
            }
            return totalRead;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        if (this.currentEntry != null && this.currentEntry.hasStream() && !this.currentEntry.isAntiItem()) {
            int totalRead = this.zFile.read(b);
            if (totalRead >= 0) {
                this.count(totalRead);
                this.currentBytesRead += (long)totalRead;
            }
            return totalRead;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentEntry != null && this.currentEntry.hasStream() && !this.currentEntry.isAntiItem()) {
            int totalRead = this.zFile.read(b, off, len);
            if (totalRead >= 0) {
                this.count(totalRead);
                this.currentBytesRead += (long)totalRead;
            }
            return totalRead;
        }
        return -1;
    }

    public void close() throws IOException {
        this.zFile.close();
    }

    public int available() throws IOException {
        if (this.currentEntry.isDirectory() || !this.currentEntry.hasStream() || this.currentEntry.isAntiItem()) {
            return 0;
        }
        long currentSize = this.currentEntry.getSize();
        long currentSizeDiff = currentSize - this.currentBytesRead;
        if (currentSizeDiff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)currentSizeDiff;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L || this.currentEntry.isDirectory() || !this.currentEntry.hasStream() || this.currentEntry.isAntiItem()) {
            return 0L;
        }
        long available = this.currentEntry.getSize() - this.currentBytesRead;
        long skipped = this.skip(Math.min(n, available));
        this.count(skipped);
        this.currentBytesRead += skipped;
        return skipped;
    }

    public String toString() {
        return this.zFile.toString();
    }

    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof SevenZArchiveEntry) {
            SevenZArchiveEntry entry = (SevenZArchiveEntry)archiveEntry;
            return entry.hasStream() && !entry.isAntiItem();
        }
        return false;
    }
}

