/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.RunnableReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;

public class ProcessHelper {
    private static final Logger logger = Logger.getLogger(ProcessHelper.class.getName());
    private static final String JAVA_HOME = System.getProperty("java.home");

    public static String getJavaCommand() {
        String dir;
        File exe;
        String executable = "java";
        if (OsVersion.PLATFORM.isA(Platform.Name.WINDOWS) || OsVersion.PLATFORM.isA(Platform.Name.OS_2)) {
            executable = executable + ".exe";
        }
        if (!(exe = new File(dir = new File(JAVA_HOME + "/bin").getAbsolutePath(), executable)).exists()) {
            return executable;
        }
        return exe.getAbsolutePath();
    }

    public static Process exec(String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        process.getOutputStream().close();
        LoggingReader reader = new LoggingReader(new InputStreamReader(process.getInputStream()));
        Thread thread = new Thread(reader);
        thread.setDaemon(true);
        thread.start();
        return process;
    }

    public static Process exec(List<String> command) throws IOException {
        return ProcessHelper.exec(command.toArray(new String[command.size()]));
    }

    public static void tryExecJava() throws IOException {
        Process process = ProcessHelper.exec(ProcessHelper.getJavaCommand(), "-version");
        try {
            process.waitFor();
        }
        catch (InterruptedException exception) {
            throw new IOException("Unable to create a java subprocess", exception);
        }
    }

    private static class LoggingReader
    extends RunnableReader {
        public LoggingReader(Reader reader) {
            super(reader);
        }

        @Override
        protected void read(String line) {
            logger.fine(line);
        }
    }
}

