/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.event.ActionBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String BSFACTIONS = "bsfactions";
    public static final String BSFACTION = "bsfaction";
    public static final String BEFOREFILE = "beforefile";
    public static final String AFTERFILE = "afterfile";
    public static final String BEFOREDIR = "beforedir";
    public static final String AFTERDIR = "afterdir";
    public static final String BEFOREDELETE = "beforedelete";
    public static final String AFTERDELETE = "afterdelete";
    public static final String BEFOREDELETION = "beforedeletion";
    public static final String AFTERDELETION = "afterdeletion";
    private String script = null;
    private String language = null;
    private String scriptName = null;
    private transient BSFManager manager = null;
    private transient BSFEngine engine = null;
    private static Map<String, MethodDescriptor> orderMethodMap = null;
    private Properties variables = new Properties();
    private static final Logger logger = Logger.getLogger(BSFAction.class.getName());
    private static Map<String, MethodExistenceChecker> langToMethodCheckerMap = new HashMap<String, MethodExistenceChecker>();

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void init() {
        if (this.manager == null) {
            this.manager = new BSFManager();
        }
        if (this.engine == null) {
            try {
                this.engine = this.manager.loadScriptingEngine(this.language);
                this.scriptName = "script." + this.language;
                this.engine.exec(this.scriptName, 1, 1, (Object)this.script);
            }
            catch (BSFException exception) {
                throw new IzPackException("Failed to initialise BSF", (Throwable)exception);
            }
        }
    }

    public void destroy() {
        if (this.engine != null) {
            this.engine.terminate();
            this.engine = null;
        }
        if (this.manager != null) {
            this.manager.terminate();
            this.manager = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executeUninstall(String order, Object ... params) {
        block8: {
            block7: {
                desc = BSFAction.orderMethodMap.get(order);
                if (desc == null) break block8;
                for (i = 0; i < MethodDescriptor.access$000(desc).length; ++i) {
                    if (params[i] == null) continue;
                    this.manager.declareBean(MethodDescriptor.access$000(desc)[i], params[i], params[i].getClass());
                }
                this.manager.declareBean("variables", (Object)this.variables, Properties.class);
                checker = BSFAction.langToMethodCheckerMap.get(this.language);
                if (checker == null) break block7;
                ** if (checker.isMethodDefined((String)MethodDescriptor.access$100((MethodDescriptor)desc), (String)this.scriptName, (BSFEngine)this.engine, (BSFManager)this.manager)) goto lbl14
lbl-1000:
                // 1 sources

                {
                    this.undeclareBeans(desc, new String[]{"variables"});
                    return;
                }
lbl14:
                // 1 sources

                ** GOTO lbl19
            }
            try {
                this.engine.eval(this.scriptName, 1, 1, (Object)MethodDescriptor.access$100(desc));
lbl19:
                // 2 sources

                this.engine.exec(this.scriptName, 1, 1, (Object)(MethodDescriptor.access$100(desc) + "()"));
            }
            catch (BSFException exception) {
                try {
                    throw new IzPackException("Failed to execute BSF action: " + MethodDescriptor.access$100(desc), (Throwable)exception);
                }
                catch (Throwable var5_7) {
                    this.undeclareBeans(desc, new String[]{"variables"});
                    throw var5_7;
                }
            }
            this.undeclareBeans(desc, new String[]{"variables"});
        }
    }

    /*
     * Unable to fully structure code
     */
    public void execute(String order, Object[] params, InstallData installData) {
        block8: {
            block7: {
                desc = BSFAction.orderMethodMap.get(order);
                if (desc == null) break block8;
                for (i = 0; i < MethodDescriptor.access$000(desc).length; ++i) {
                    if (params[i] == null) continue;
                    this.manager.declareBean(MethodDescriptor.access$000(desc)[i], params[i], params[i].getClass());
                }
                this.manager.declareBean("installData", (Object)installData, InstallData.class);
                this.manager.declareBean("idata", (Object)installData, InstallData.class);
                checker = BSFAction.langToMethodCheckerMap.get(this.language);
                if (checker == null) break block7;
                ** if (checker.isMethodDefined((String)MethodDescriptor.access$100((MethodDescriptor)desc), (String)this.scriptName, (BSFEngine)this.engine, (BSFManager)this.manager)) goto lbl15
lbl-1000:
                // 1 sources

                {
                    this.undeclareBeans(desc, new String[]{"installData", "idata"});
                    return;
                }
lbl15:
                // 1 sources

                ** GOTO lbl20
            }
            try {
                this.engine.eval(this.scriptName, 1, 1, (Object)MethodDescriptor.access$100(desc));
lbl20:
                // 2 sources

                this.engine.exec(this.scriptName, 1, 1, (Object)(MethodDescriptor.access$100(desc) + "()"));
            }
            catch (BSFException exception) {
                try {
                    throw new IzPackException("Failed to execute BSF action: " + MethodDescriptor.access$100(desc), (Throwable)exception);
                }
                catch (Throwable var6_8) {
                    this.undeclareBeans(desc, new String[]{"installData", "idata"});
                    throw var6_8;
                }
            }
            this.undeclareBeans(desc, new String[]{"installData", "idata"});
        }
    }

    private void undeclareBeans(MethodDescriptor desc, String ... names) {
        try {
            for (int i = 0; i < desc.argNames.length; ++i) {
                this.manager.undeclareBean(desc.argNames[i]);
            }
            for (String name : names) {
                this.manager.undeclareBean(name);
            }
        }
        catch (BSFException exception) {
            logger.log(Level.INFO, "Failed to undeclare beans: " + exception.getMessage(), exception);
        }
    }

    static {
        orderMethodMap = new HashMap<String, MethodDescriptor>();
        orderMethodMap.put(BEFOREDELETION, new MethodDescriptor("beforeDeletion", "files"));
        orderMethodMap.put(AFTERDELETION, new MethodDescriptor("afterDeletion", "files"));
        orderMethodMap.put(BEFOREDELETE, new MethodDescriptor("beforeDelete", "file"));
        orderMethodMap.put(AFTERDELETE, new MethodDescriptor("afterDelete", "file"));
        orderMethodMap.put(BEFOREDIR, new MethodDescriptor("beforeDir", "file", "pack"));
        orderMethodMap.put(AFTERDIR, new MethodDescriptor("afterDir", "file", "pack"));
        orderMethodMap.put(BEFOREFILE, new MethodDescriptor("beforeFile", "file", "pack"));
        orderMethodMap.put(AFTERFILE, new MethodDescriptor("afterFile", "file", "pack"));
        orderMethodMap.put("beforepacks", new MethodDescriptor("beforePacks", "packs", "npacks"));
        orderMethodMap.put("afterpacks", new MethodDescriptor("afterPacks", "packs"));
        orderMethodMap.put("beforepack", new MethodDescriptor("beforePack", "pack", "i"));
        orderMethodMap.put("afterpack", new MethodDescriptor("afterPack", "pack", "i"));
        langToMethodCheckerMap.put("beanshell", new MethodExistenceChecker(){

            @Override
            public boolean isMethodDefined(String method, String scriptName, BSFEngine engine, BSFManager manager) throws BSFException {
                String script = "this.namespace.getMethod(\"" + method + "\", new Class[0])";
                Object res = engine.eval(scriptName, 1, 1, (Object)script);
                return res != null;
            }
        });
    }

    private static interface MethodExistenceChecker {
        public boolean isMethodDefined(String var1, String var2, BSFEngine var3, BSFManager var4) throws BSFException;
    }

    private static class MethodDescriptor {
        private String name;
        private String[] argNames;

        public MethodDescriptor(String name, String ... argNames) {
            this.name = name;
            this.argNames = argNames;
        }

        static /* synthetic */ String access$100(MethodDescriptor x0) {
            return x0.name;
        }
    }
}

