/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.exolab.javasource.JCodeStatement;
import org.exolab.javasource.JSourceWriter;

public final class JSourceCode {
    public static final int DEFAULT_INDENT_SIZE = 4;
    private Vector _source = null;
    private short _indentSize;
    private short _currentIndent = this._indentSize = (short)4;

    public JSourceCode() {
        this._source = new Vector();
    }

    public JSourceCode(String sourceCode) {
        this();
        this._source.addElement(new JCodeStatement(sourceCode, this._currentIndent));
    }

    public void add(String pattern, Object argument) {
        this.add(pattern, new Object[]{argument});
    }

    public void add(String pattern, Object argument1, Object argument2) {
        this.add(pattern, new Object[]{argument1, argument2});
    }

    public void add(String pattern, Object[] arguments) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, "\n");
        while (tokenizer.hasMoreTokens()) {
            this.addWithIndent(tokenizer.nextToken(), arguments);
        }
    }

    private void addWithIndent(String pattern, Object[] arguments) {
        if (pattern.startsWith(" ")) {
            this.indent();
            this.addWithIndent(pattern.substring(1), arguments);
            this.unindent();
        } else if (pattern.indexOf(123) + 2 == pattern.indexOf(125)) {
            this.add(MessageFormat.format(pattern, arguments));
        } else {
            this.add(pattern);
        }
    }

    public void add(String statement) {
        this._source.addElement(new JCodeStatement(statement, this._currentIndent));
    }

    public void addIndented(String statement) {
        this.indent();
        this._source.addElement(new JCodeStatement(statement, this._currentIndent));
        this.unindent();
    }

    public void append(String segment) {
        if (this._source.isEmpty()) {
            this.add(segment);
        } else {
            JCodeStatement jcs = (JCodeStatement)this._source.lastElement();
            jcs.append(segment);
        }
    }

    public void clear() {
        this._source.removeAllElements();
    }

    public void copyInto(JSourceCode jsc) {
        for (int i = 0; i < this._source.size(); ++i) {
            jsc.addCodeStatement((JCodeStatement)this._source.elementAt(i));
        }
    }

    public void indent() {
        this._currentIndent = (short)(this._currentIndent + this._indentSize);
    }

    public boolean isEmpty() {
        return this._source.isEmpty();
    }

    public void print(JSourceWriter jsw) {
        for (int i = 0; i < this._source.size(); ++i) {
            jsw.writeln(this._source.elementAt(i).toString());
        }
    }

    public void unindent() {
        this._currentIndent = (short)(this._currentIndent - this._indentSize);
    }

    public int size() {
        return this._source.size();
    }

    private void addCodeStatement(JCodeStatement jcs) {
        short indent = (short)(jcs.getIndent() + this._currentIndent - 4);
        this._source.addElement(new JCodeStatement(jcs.getStatement(), indent));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        for (int i = 0; i < this._source.size(); ++i) {
            sb.append(this._source.elementAt(i).toString());
            sb.append(lineSeparator);
        }
        return sb.toString();
    }
}

