/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSListType;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;

public final class XMLFieldHandlerFactory {
    private BuilderConfiguration _config;

    public XMLFieldHandlerFactory(BuilderConfiguration config) {
        this._config = config;
    }

    public void createXMLFieldHandler(FieldInfo member, XSType xsType, String localClassName, JSourceCode jsc, boolean forGeneralizedHandler) {
        boolean any = false;
        boolean isEnumerated = false;
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.getType() == 0) {
            isEnumerated = ((XSClass)xsType).isEnumerated();
        }
        jsc.add("handler = new org.exolab.castor.xml.XMLFieldHandler() {");
        jsc.indent();
        this.createGetValueMethod(member, xsType, localClassName, jsc);
        boolean isAttribute = member.getNodeType() == 0;
        boolean isContent = member.getNodeType() == 2;
        this.createSetValueMethod(member, xsType, localClassName, jsc, any, isAttribute, isContent);
        this.createResetMethod(member, localClassName, jsc);
        this.createNewInstanceMethod(member, xsType, jsc, forGeneralizedHandler, any, isEnumerated);
        jsc.unindent();
        jsc.add("};");
    }

    private void createGetValueMethod(FieldInfo member, XSType xsType, String localClassName, JSourceCode jsc) {
        if (this._config.useJava50()) {
            jsc.add("@Override");
        }
        jsc.add("public java.lang.Object getValue( java.lang.Object object ) ");
        jsc.indent();
        jsc.add("throws IllegalStateException");
        jsc.unindent();
        jsc.add("{");
        jsc.indent();
        jsc.add(localClassName);
        jsc.append(" target = (");
        jsc.append(localClassName);
        jsc.append(") object;");
        if (!xsType.isEnumerated() && xsType.getJType().isPrimitive() && !member.isMultivalued()) {
            jsc.add("if (!target." + member.getHasMethodName() + "()) { return null; }");
        }
        jsc.add("return ");
        String value = "target." + member.getReadMethodName() + "()";
        if (member.isMultivalued()) {
            jsc.append(value);
        } else {
            jsc.append(xsType.createToJavaObjectCode(value));
        }
        jsc.append(";");
        jsc.unindent();
        jsc.add("}");
    }

    private void createSetValueMethod(FieldInfo member, XSType xsType, String localClassName, JSourceCode jsc, boolean any, boolean isAttribute, boolean isContent) {
        if (this._config.useJava50()) {
            jsc.add("@Override");
        }
        jsc.add("public void setValue( java.lang.Object object, java.lang.Object value) ");
        jsc.indent();
        jsc.add("throws IllegalStateException, IllegalArgumentException");
        jsc.unindent();
        jsc.add("{");
        jsc.indent();
        jsc.add("try {");
        jsc.indent();
        jsc.add(localClassName);
        jsc.append(" target = (");
        jsc.append(localClassName);
        jsc.append(") object;");
        if (xsType.isPrimitive() && !this._config.usePrimitiveWrapper()) {
            if (!(member.isRequired() || xsType.isEnumerated() || member.isMultivalued())) {
                jsc.add("// if null, use delete method for optional primitives ");
                jsc.add("if (value == null) {");
                jsc.indent();
                jsc.add("target.");
                jsc.append(member.getDeleteMethodName());
                jsc.append("();");
                jsc.add("return;");
                jsc.unindent();
                jsc.add("}");
            } else {
                jsc.add("// ignore null values for non optional primitives");
                jsc.add("if (value == null) { return; }");
                jsc.add("");
            }
        }
        jsc.add("target.");
        jsc.append(member.getWriteMethodName());
        jsc.append("( ");
        if (xsType.isPrimitive() && !this._config.usePrimitiveWrapper()) {
            jsc.append(xsType.createFromJavaObjectCode("value"));
        } else if (any) {
            jsc.append(" value ");
        } else {
            jsc.append("(");
            jsc.append(xsType.getJType().toString());
            if (isAttribute | isContent && xsType.isDateTime() && xsType.getType() != 3) {
                jsc.append(".parse");
                jsc.append(JavaNaming.toJavaClassName((String)xsType.getName()));
                jsc.append("((java.lang.String) value))");
            } else {
                jsc.append(") value");
            }
        }
        jsc.append(");");
        jsc.unindent();
        jsc.add("} catch (java.lang.Exception ex) {");
        jsc.indent();
        jsc.add("throw new IllegalStateException(ex.toString());");
        jsc.unindent();
        jsc.add("}");
        jsc.unindent();
        jsc.add("}");
    }

    private void createResetMethod(FieldInfo member, String localClassName, JSourceCode jsc) {
        if (member.isMultivalued()) {
            CollectionInfo cInfo = (CollectionInfo)member;
            jsc.add("public void resetValue(Object object) throws IllegalStateException, IllegalArgumentException {");
            jsc.indent();
            jsc.add("try {");
            jsc.indent();
            jsc.add(localClassName);
            jsc.append(" target = (");
            jsc.append(localClassName);
            jsc.append(") object;");
            String cName = JavaNaming.toJavaClassName((String)cInfo.getElementName());
            jsc.add("target.removeAll" + cName + "();");
            jsc.unindent();
            jsc.add("} catch (java.lang.Exception ex) {");
            jsc.indent();
            jsc.add("throw new IllegalStateException(ex.toString());");
            jsc.unindent();
            jsc.add("}");
            jsc.unindent();
            jsc.add("}");
        }
    }

    private void createNewInstanceMethod(FieldInfo member, XSType xsType, JSourceCode jsc, boolean forGeneralizedHandler, boolean any, boolean isEnumerated) {
        JClass componentType;
        XSListType xsList;
        JClass jClass;
        boolean isAbstract = false;
        if (member.getSchemaType() != null && member.getSchemaType().getJType() instanceof JClass) {
            jClass = (JClass)member.getSchemaType().getJType();
            isAbstract = jClass.getModifiers().isAbstract();
        }
        if (!isAbstract && xsType.getJType() instanceof JClass) {
            jClass = (JClass)xsType.getJType();
            isAbstract = jClass.getModifiers().isAbstract();
        }
        if (!isAbstract && member.getSchemaType() instanceof XSListType && (xsList = (XSListType)member.getSchemaType()).getContentType().getJType() instanceof JClass && (componentType = (JClass)xsList.getContentType().getJType()).getModifiers().isAbstract()) {
            isAbstract = componentType.getModifiers().isAbstract();
        }
        if (this._config.useJava50()) {
            jsc.add("@Override");
            jsc.add("@SuppressWarnings(\"unused\")");
        }
        jsc.add("public java.lang.Object newInstance(java.lang.Object parent) {");
        jsc.indent();
        jsc.add("return ");
        if (any || forGeneralizedHandler || isEnumerated || xsType.isPrimitive() || xsType.getJType().isArray() || xsType.getType() == 1 || isAbstract) {
            jsc.append("null;");
        } else {
            jsc.append(xsType.newInstanceCode());
        }
        jsc.unindent();
        jsc.add("}");
    }
}

