/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Hashtable;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Structure;

public final class GroupNaming {
    private Hashtable _packageGroupNames = new Hashtable();

    private String getGroupName(Group group, String packageName) {
        Hashtable groupNames = (Hashtable)this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            return null;
        }
        return (String)groupNames.get(group);
    }

    private void putGroupName(Group group, String packageName, String name) {
        Hashtable<Group, String> groupNames = (Hashtable<Group, String>)this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            groupNames = new Hashtable<Group, String>();
            this._packageGroupNames.put(packageName, groupNames);
        }
        groupNames.put(group, name);
    }

    private boolean containsGroupName(String packageName, String name) {
        Hashtable groupNames = (Hashtable)this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            return false;
        }
        return groupNames.contains(name);
    }

    public String createClassName(Group group, String packageName) {
        String name = group.getName();
        if (name != null) {
            return JavaNaming.toJavaClassName((String)name);
        }
        name = this.getGroupName(group, packageName);
        if (name != null) {
            return name;
        }
        Structure parent = group.getParent();
        if (parent == null) {
            return null;
        }
        boolean addOrder = true;
        switch (parent.getStructureType()) {
            case 10: {
                name = this.createClassName((Group)parent, packageName);
                break;
            }
            case 16: {
                name = ((ModelGroup)parent).getName();
                name = JavaNaming.toJavaClassName((String)name);
                addOrder = false;
                break;
            }
            case 6: {
                name = GroupNaming.getClassName((ComplexType)parent);
                addOrder = false;
                break;
            }
        }
        if (name != null) {
            if (addOrder) {
                String order = group.getOrder().toString();
                name = name + JavaNaming.toJavaClassName((String)order);
            }
            int count = 2;
            String tmpName = name;
            while (this.containsGroupName(packageName, name)) {
                name = tmpName + count;
                ++count;
            }
            this.putGroupName(group, packageName, name);
        }
        return name;
    }

    private static String getClassName(ComplexType complexType) {
        String name = complexType.getName();
        if (name != null) {
            return JavaNaming.toJavaClassName((String)name);
        }
        Structure parent = complexType.getParent();
        if (parent != null && parent.getStructureType() == 8) {
            name = ((ElementDecl)parent).getName();
        }
        if (name != null) {
            name = JavaNaming.toJavaClassName((String)name);
        }
        return name;
    }
}

