/* 
 * ========================================================================
 * 
 * Copyright 2004 Vincent Massol.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ========================================================================
 */
package org.codehaus.cargo.ant;

/**
 * Represent a container property.  
 *
 * @version $Id: Property.java 1702 2008-09-02 12:37:46Z adriana $
 */
public class Property
{
    /**
     * Property name.
     */
    private String name;

    /**
     * Property value.
     */
    private String value;

    /**
     * @param name the property name
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @param value the property value
     */
    public void setValue(String value)
    {
        this.value = value;
    }

    /**
     * {@inheritDoc}
     * @see #setName(String)
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * {@inheritDoc}
     * @see #setValue(String)
     */
    public String getValue()
    {
        return this.value;
    }
}
