/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.org.plumelib.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.errorprone.checker.formatter.qual.FormatBottom;
import org.checkerframework.errorprone.checker.formatter.qual.UnknownFormat;
import org.checkerframework.errorprone.checker.index.qual.IndexOrHigh;
import org.checkerframework.errorprone.checker.index.qual.LTEqLengthOf;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.NonNegative;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.interning.qual.InternedDistinct;
import org.checkerframework.errorprone.checker.interning.qual.UnknownInterned;
import org.checkerframework.errorprone.checker.lock.qual.GuardedBy;
import org.checkerframework.errorprone.checker.lock.qual.GuardedByBottom;
import org.checkerframework.errorprone.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCall;
import org.checkerframework.errorprone.checker.nullness.qual.KeyForBottom;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.PolyNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.regex.qual.Regex;
import org.checkerframework.errorprone.checker.regex.qual.RegexBottom;
import org.checkerframework.errorprone.checker.regex.qual.UnknownRegex;
import org.checkerframework.errorprone.checker.signature.qual.SignatureBottom;
import org.checkerframework.errorprone.checker.signature.qual.SignatureUnknown;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.checker.signedness.qual.Unsigned;
import org.checkerframework.errorprone.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.StaticallyExecutable;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;
import org.checkerframework.errorprone.org.plumelib.util.CollectionsPlume;

public final class StringsPlume {
    private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String lineSep = System.lineSeparator();
    private static @Regex(value=6) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Pattern formatSpecifier = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    private StringsPlume() {
        throw new Error("do not instantiate");
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String replacePrefix(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String target, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String oldStr, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String newStr) {
        if (target.startsWith(oldStr)) {
            if (newStr.isEmpty()) {
                return target.substring(oldStr.length());
            }
            return newStr + target.substring(oldStr.length());
        }
        return target;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String replaceSuffix(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String target, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String oldStr, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String newStr) {
        if (target.endsWith(oldStr)) {
            if (newStr.isEmpty()) {
                return target.substring(0, target.length() - oldStr.length());
            }
            return target.substring(0, target.length() - oldStr.length()) + newStr;
        }
        return target;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String replaceAll(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Pattern regex, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String replacement) {
        Matcher m4 = regex.matcher(s2);
        return m4.replaceAll(replacement);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String prefixLines(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String prefix, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o) {
        return prefix + StringsPlume.prefixLinesExceptFirst(prefix, o);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String prefixLinesExceptFirst(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String prefix, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace(lineSep, lineSep + prefix);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String indentLines(@NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int indent, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o) {
        if (indent == 0) {
            return o == null ? "null" : o.toString();
        }
        String prefix = new String(new char[indent]).replace('\u0000', ' ');
        return StringsPlume.prefixLines(prefix, o);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String indentLinesExceptFirst(@NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int indent, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o) {
        if (indent == 0) {
            return o == null ? "null" : o.toString();
        }
        String prefix = new String(new char[indent]).replace('\u0000', ' ');
        return StringsPlume.prefixLinesExceptFirst(prefix, o);
    }

    @SideEffectFree
    @StaticallyExecutable
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed [] splitLines(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2) {
        return s2.split("\r\n?|\n\r?", -1);
    }

    @SafeVarargs
    @SideEffectFree
    public static <T> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String join(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed CharSequence delim, T ... a) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < a.length; ++i) {
            sb.append(delim).append(a[i]);
        }
        return sb.toString();
    }

    @SafeVarargs
    @SideEffectFree
    public static <T> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String joinLines(T ... a) {
        return StringsPlume.join((CharSequence)lineSep, a);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String join(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed CharSequence delim, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Iterable<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> v) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator<? extends @Signed @PolyNull Object> itor = v.iterator();
        while (itor.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(itor.next());
        }
        return sb.toString();
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String joinLines(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Iterable<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> v) {
        return StringsPlume.join((CharSequence)lineSep, v);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String escapeJava(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String orig) {
        StringBuilder sb = new StringBuilder();
        @IndexOrHigh(value={"orig"}) int postEsc = 0;
        int origLen = orig.length();
        block9: for (int i = 0; i < origLen; ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\"': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\\"");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\\': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\\\");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\b': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\b");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\f': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\f");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\n': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\n");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\r': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\r");
                    postEsc = i + 1;
                    continue block9;
                }
                case '\t': {
                    if (postEsc < i) {
                        sb.append(orig.substring(postEsc, i));
                    }
                    sb.append("\\t");
                    postEsc = i + 1;
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c <= '~') continue block9;
                    if (c <= '\u00ff') {
                        if (postEsc < i) {
                            sb.append(orig.substring(postEsc, i));
                        }
                        sb.append("\\");
                        char cAsInt = c;
                        sb.append(String.format("%03o", cAsInt));
                        postEsc = i + 1;
                        continue block9;
                    }
                    sb.append("\\u");
                    sb.append(String.format("%04x", c));
                    postEsc = i + 1;
                }
            }
        }
        if (sb.length() == 0) {
            return orig;
        }
        sb.append(orig.substring(postEsc));
        return sb.toString();
    }

    @Deprecated
    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String escapeJava(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Unsigned Character ch) {
        return StringsPlume.escapeJava(ch.charValue());
    }

    @Deprecated
    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String escapeJava(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Unsigned char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return new String(new char[]{c});
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String charLiteral(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Unsigned Character ch) {
        return StringsPlume.charLiteral(ch.charValue());
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String charLiteral(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Unsigned char c) {
        switch (c) {
            case '\'': {
                return "'\\''";
            }
            case '\\': {
                return "'\\\\'";
            }
            case '\b': {
                return "'\\b'";
            }
            case '\f': {
                return "'\\f'";
            }
            case '\n': {
                return "'\\n'";
            }
            case '\r': {
                return "'\\r'";
            }
            case '\t': {
                return "'\\t'";
            }
        }
        return "'" + c + "'";
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String escapeNonASCII(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String orig) {
        StringBuilder sb = new StringBuilder();
        int origLen = orig.length();
        for (int i = 0; i < origLen; ++i) {
            char c = orig.charAt(i);
            sb.append(StringsPlume.escapeNonASCII(c));
        }
        return sb.toString();
    }

    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String escapeNonASCII(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Unsigned char c) {
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c >= ' ' && c <= '~') {
            return new String(new char[]{c});
        }
        if (c < '\u0100') {
            String octal = Integer.toOctalString(c);
            while (octal.length() < 3) {
                octal = '0' + octal;
            }
            return "\\" + octal;
        }
        String hex = Integer.toHexString(c);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "\\u" + hex;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String unescapeJava(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String orig) {
        StringBuilder sb = new StringBuilder();
        @LTEqLengthOf(value={"orig"}) int postEsc = 0;
        int thisEsc = orig.indexOf(92);
        while (thisEsc != -1) {
            if (thisEsc == orig.length() - 1) {
                sb.append(orig.substring(postEsc, thisEsc + 1));
                postEsc = thisEsc + 1;
                break;
            }
            switch (orig.charAt(thisEsc + 1)) {
                case 'b': {
                    sb.append(orig.substring(postEsc, thisEsc));
                    sb.append('\b');
                    postEsc = thisEsc + 2;
                    break;
                }
                case 'f': {
                    sb.append(orig.substring(postEsc, thisEsc));
                    sb.append('\f');
                    postEsc = thisEsc + 2;
                    break;
                }
                case 'n': {
                    sb.append(orig.substring(postEsc, thisEsc));
                    sb.append('\n');
                    postEsc = thisEsc + 2;
                    break;
                }
                case 'r': {
                    sb.append(orig.substring(postEsc, thisEsc));
                    sb.append('\r');
                    postEsc = thisEsc + 2;
                    break;
                }
                case 't': {
                    sb.append(orig.substring(postEsc, thisEsc));
                    sb.append('\t');
                    postEsc = thisEsc + 2;
                    break;
                }
                case '\\': {
                    sb.append(orig.substring(postEsc, thisEsc + 1));
                    postEsc = thisEsc + 2;
                    break;
                }
                case 'u': {
                    int thisDigit;
                    int ii;
                    sb.append(orig.substring(postEsc, thisEsc));
                    char unicodeChar = '\u0000';
                    for (ii = thisEsc + 2; ii < orig.length() && orig.charAt(ii) == 'u'; ++ii) {
                    }
                    int limit = Math.min(ii + 4, orig.length());
                    while (ii < limit && (thisDigit = Character.digit(orig.charAt(ii), 16)) != -1) {
                        unicodeChar = (char)(unicodeChar * 16 + thisDigit);
                        ++ii;
                    }
                    sb.append(unicodeChar);
                    postEsc = ii;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int newValue;
                    int thisDigit;
                    int iii;
                    sb.append(orig.substring(postEsc, thisEsc));
                    char octalChar = '\u0000';
                    for (iii = thisEsc + 1; iii < Math.min(thisEsc + 4, orig.length()) && (thisDigit = Character.digit(orig.charAt(iii), 8)) != -1 && (newValue = octalChar * 8 + thisDigit) <= 255; ++iii) {
                        octalChar = (char)newValue;
                    }
                    sb.append(octalChar);
                    postEsc = iii;
                    break;
                }
                default: {
                    sb.append(orig.substring(postEsc, thisEsc));
                    postEsc = thisEsc + 1;
                }
            }
            thisEsc = orig.indexOf(92, postEsc);
        }
        if (postEsc == 0) {
            return orig;
        }
        sb.append(orig.substring(postEsc));
        return sb.toString();
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String removeWhitespaceAround(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String arg, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String delimiter) {
        arg = StringsPlume.removeWhitespaceBefore(arg, delimiter);
        arg = StringsPlume.removeWhitespaceAfter(arg, delimiter);
        return arg;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String removeWhitespaceAfter(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String arg, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String delimiter) {
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Bad delimiter: \"" + delimiter + "\"");
        }
        int delimLen = delimiter.length();
        int delimIndex = arg.indexOf(delimiter);
        while (delimIndex > -1) {
            int nonWsIndex;
            for (nonWsIndex = delimIndex + delimLen; nonWsIndex < arg.length() && Character.isWhitespace(arg.charAt(nonWsIndex)); ++nonWsIndex) {
            }
            if (nonWsIndex != delimIndex + delimLen) {
                arg = arg.substring(0, delimIndex + delimLen) + arg.substring(nonWsIndex);
            }
            delimIndex = arg.indexOf(delimiter, delimIndex + 1);
        }
        return arg;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String removeWhitespaceBefore(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String arg, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String delimiter) {
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Bad delimiter: \"" + delimiter + "\"");
        }
        int delimIndex = arg.indexOf(delimiter);
        while (delimIndex > -1) {
            int nonWsIndex;
            for (nonWsIndex = delimIndex - 1; nonWsIndex >= 0 && Character.isWhitespace(arg.charAt(nonWsIndex)); --nonWsIndex) {
            }
            if (nonWsIndex != delimIndex - 1) {
                arg = arg.substring(0, nonWsIndex + 1) + arg.substring(delimIndex);
            }
            delimIndex = arg.indexOf(delimiter, nonWsIndex + 2);
        }
        return arg;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String lpad(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2, @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int length) {
        if (s2.length() < length) {
            StringBuilder buf = new StringBuilder();
            for (int i = s2.length(); i < length; ++i) {
                buf.append(' ');
            }
            return buf.toString() + s2;
        }
        return s2.substring(0, length);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String rpad(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2, @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int length) {
        if (s2.length() < length) {
            StringBuilder buf = new StringBuilder(s2);
            for (int i = s2.length(); i < length; ++i) {
                buf.append(' ');
            }
            return buf.toString();
        }
        return s2.substring(0, length);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String rpad(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int num, @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int length) {
        return StringsPlume.rpad(String.valueOf(num), length);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String rpad(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed double num, @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int length) {
        return StringsPlume.rpad(String.valueOf(num), length);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed ArrayList<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object> tokens(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String str, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String delim, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean returnDelims) {
        return CollectionsPlume.makeArrayList(new StringTokenizer(str, delim, returnDelims));
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed ArrayList<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object> tokens(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String str, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String delim) {
        return CollectionsPlume.makeArrayList(new StringTokenizer(str, delim));
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed ArrayList<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object> tokens(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String str) {
        return CollectionsPlume.makeArrayList(new StringTokenizer(str));
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String toStringAndClass(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object v) {
        return StringsPlume.toStringAndClass(v, false);
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String toStringAndClass(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object v, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean shallow) {
        if (v == null) {
            return "null";
        }
        if (v.getClass() == Object.class) {
            return "a value of class " + v.getClass();
        }
        if (!shallow) {
            if (v.getClass().isArray()) {
                return StringsPlume.arrayToStringAndClass(v);
            }
            if (v instanceof List) {
                return StringsPlume.listToStringAndClass((List)v);
            }
            if (v instanceof Map) {
                return StringsPlume.mapToStringAndClass((Map)v);
            }
        }
        try {
            String formatted = StringsPlume.escapeJava(v.toString());
            return String.format("%s [%s]", formatted, v.getClass());
        }
        catch (Exception e) {
            return String.format("exception_when_calling_toString [%s]", v.getClass());
        }
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String listToStringAndClass(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed List<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> lst) {
        if (lst == null) {
            return "null";
        }
        return StringsPlume.listToString(lst) + " [" + lst.getClass() + "]";
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String listToString(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed List<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> lst) {
        if (lst == null) {
            return "null";
        }
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object object : lst) {
            sj.add(StringsPlume.toStringAndClass(object, true));
        }
        return sj.toString();
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String arrayToStringAndClass(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object a) {
        if (a == null) {
            return "null";
        }
        String theClass = " [" + a.getClass() + "]";
        if (a instanceof boolean[]) {
            return Arrays.toString((boolean[])a) + theClass;
        }
        if (a instanceof byte[]) {
            return Arrays.toString((byte[])a) + theClass;
        }
        if (a instanceof char[]) {
            return Arrays.toString((char[])a) + theClass;
        }
        if (a instanceof double[]) {
            return Arrays.toString((double[])a) + theClass;
        }
        if (a instanceof float[]) {
            return Arrays.toString((float[])a) + theClass;
        }
        if (a instanceof int[]) {
            return Arrays.toString((int[])a) + theClass;
        }
        if (a instanceof long[]) {
            return Arrays.toString((long[])a) + theClass;
        }
        if (a instanceof short[]) {
            return Arrays.toString((short[])a) + theClass;
        }
        if (a instanceof Object[]) {
            try {
                return StringsPlume.listToString(Arrays.asList((Object[])a)) + theClass;
            }
            catch (Exception e) {
                return "exception_when_printing_array" + theClass;
            }
        }
        throw new IllegalArgumentException("Argument is not an array; its class is " + a.getClass().getName());
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String mapToStringAndClass(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Map<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> m4) {
        StringJoiner result = new StringJoiner(System.lineSeparator());
        for (Map.Entry<? extends Object, ? extends Object> e : m4.entrySet()) {
            result.add("    " + StringsPlume.toStringAndClass(e.getKey()) + " => " + StringsPlume.toStringAndClass(e.getValue()));
        }
        return result.toString();
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String nplural(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int n, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String noun) {
        int penultimateLetter;
        if (noun.isEmpty()) {
            throw new IllegalArgumentException("The second argument to nplural must not be an empty string");
        }
        if (n == 1) {
            return n + " " + noun;
        }
        char lastLetter = noun.charAt(noun.length() - 1);
        int n2 = penultimateLetter = noun.length() == 1 ? 0 : (int)noun.charAt(noun.length() - 2);
        if (penultimateLetter == 99 && lastLetter == 'h' || lastLetter == 's' || penultimateLetter == 115 && lastLetter == 'h' || lastLetter == 'x') {
            return n + " " + noun + "es";
        }
        if (lastLetter == 'y' && penultimateLetter != 97 && penultimateLetter != 101 && penultimateLetter != 105 && penultimateLetter != 111 && penultimateLetter != 117) {
            return n + " " + noun.substring(0, noun.length() - 1) + "ies";
        }
        return n + " " + noun + "s";
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String conjunction(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String conjunction, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed List<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends @Signed @PolyNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object> elements) {
        int size = elements.size();
        if (size == 0) {
            throw new IllegalArgumentException("no elements passed to conjunction()");
        }
        if (size == 1) {
            return Objects.toString(elements.get(0));
        }
        if (size == 2) {
            return elements.get(0) + " " + conjunction + " " + elements.get(1);
        }
        StringJoiner sj = new StringJoiner(", ");
        for (int i = 0; i < size - 1; ++i) {
            sj.add(Objects.toString(elements.get(i)));
        }
        sj.add(conjunction + " " + elements.get(size - 1));
        return sj.toString();
    }

    @Pure
    @StaticallyExecutable
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int count(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int ch) {
        int result = 0;
        int pos = s2.indexOf(ch);
        while (pos > -1) {
            ++result;
            pos = s2.indexOf(ch, pos + 1);
        }
        return result;
    }

    @Pure
    @StaticallyExecutable
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int count(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String sub) {
        if (sub.equals("")) {
            throw new IllegalArgumentException("second argument must not be empty");
        }
        int result = 0;
        int pos = s2.indexOf(sub);
        while (pos > -1) {
            ++result;
            pos = s2.indexOf(sub, pos + 1);
        }
        return result;
    }

    @SideEffectFree
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String abbreviateNumber(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed long val) {
        double dval = val;
        String mag = "";
        if (val >= 1000L) {
            if (val < 1000000L) {
                dval = (double)val / 1000.0;
                mag = "K";
            } else if (val < 1000000000L) {
                dval = (double)val / 1000000.0;
                mag = "M";
            } else {
                dval = (double)val / 1.0E9;
                mag = "G";
            }
        }
        String precision = "0";
        if (dval < 10.0) {
            precision = "2";
        } else if (dval < 100.0) {
            precision = "1";
        }
        String result = String.format("%,1." + precision + "f" + mag, dval);
        return result;
    }

    @Pure
    @StaticallyExecutable
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int countFormatArguments(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2) {
        int result = 0;
        int maxIndex = 0;
        Matcher matcher = formatSpecifier.matcher(s2);
        while (matcher.find()) {
            String argumentIndex = matcher.group(1);
            if (argumentIndex != null) {
                int thisIndex = Integer.parseInt(argumentIndex.substring(0, argumentIndex.length() - 1));
                maxIndex = Math.max(maxIndex, thisIndex);
                continue;
            }
            String conversion = matcher.group(6);
            assert (conversion != null) : "@AssumeAssertion(nullness): nonempty capturing group";
            if (conversion.equals("%") || conversion.equals("n")) continue;
            ++result;
        }
        return Math.max(maxIndex, result);
    }

    public static class ObjectComparator
    implements Comparator<Object>,
    Serializable {
        static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed long serialVersionUID = 20170420L;

        @Override
        @Pure
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int compare(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o1, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }

    @Deprecated
    public static class NullableStringComparator
    implements Comparator<String>,
    Serializable {
        static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed long serialVersionUID = 20150812L;

        @Override
        @Pure
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int compare(@Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s1, @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String s2) {
            if (s1 == s2) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

