/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.antlr.tool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cassandraunit.shaded.org.antlr.grammar.v3.AssignTokenTypesWalker;
import org.cassandraunit.shaded.org.antlr.misc.Utils;
import org.cassandraunit.shaded.org.antlr.runtime.tree.TreeNodeStream;
import org.cassandraunit.shaded.org.antlr.tool.ErrorManager;
import org.cassandraunit.shaded.org.antlr.tool.Grammar;
import org.cassandraunit.shaded.org.antlr.tool.GrammarAST;

public class AssignTokenTypesBehavior
extends AssignTokenTypesWalker {
    protected static final Integer UNASSIGNED = Utils.integer(-1);
    protected static final Integer UNASSIGNED_IN_PARSER_RULE = Utils.integer(-2);
    protected Map<String, Integer> stringLiterals = new TreeMap<String, Integer>();
    protected Map<String, Integer> tokens = new TreeMap<String, Integer>();
    protected Map<String, String> aliases = new TreeMap<String, String>();
    protected Map<String, String> aliasesReverseIndex = new HashMap<String, String>();
    protected Set<String> tokenRuleDefs = new HashSet<String>();

    public AssignTokenTypesBehavior() {
        super((TreeNodeStream)null);
    }

    protected void init(Grammar g) {
        this.grammar = g;
        this.currentRuleName = null;
        if (stringAlias == null) {
            this.initASTPatterns();
        }
    }

    protected void trackString(GrammarAST t) {
        if (this.currentRuleName == null && this.grammar.type == 1) {
            ErrorManager.grammarError(108, this.grammar, t.token, t.getText());
            return;
        }
        if (this.grammar.getGrammarIsRoot() && this.grammar.type == 2 && this.grammar.getTokenType(t.getText()) == -7) {
            ErrorManager.grammarError(107, this.grammar, t.token, t.getText());
        }
        if (this.grammar.type == 1) {
            return;
        }
        if ((this.currentRuleName == null || Character.isLowerCase(this.currentRuleName.charAt(0))) && this.grammar.getTokenType(t.getText()) == -7) {
            this.stringLiterals.put(t.getText(), UNASSIGNED_IN_PARSER_RULE);
        }
    }

    protected void trackToken(GrammarAST t) {
        if (this.grammar.getTokenType(t.getText()) == -7 && this.tokens.get(t.getText()) == null) {
            this.tokens.put(t.getText(), UNASSIGNED);
        }
    }

    protected void trackTokenRule(GrammarAST t, GrammarAST modifier, GrammarAST block) {
        if (this.grammar.type == 1 || this.grammar.type == 4) {
            if (!Character.isUpperCase(t.getText().charAt(0))) {
                return;
            }
            if (t.getText().equals("Tokens")) {
                return;
            }
            this.grammar.composite.lexerRules.add(t.getText());
            int existing = this.grammar.getTokenType(t.getText());
            if (existing == -7) {
                this.tokens.put(t.getText(), UNASSIGNED);
            }
            if (block.hasSameTreeStructure(charAlias) || block.hasSameTreeStructure(stringAlias) || block.hasSameTreeStructure(charAlias2) || block.hasSameTreeStructure(stringAlias2)) {
                this.tokenRuleDefs.add(t.getText());
                if (this.grammar.type == 4 || this.grammar.type == 1) {
                    this.alias(t, (GrammarAST)block.getChild(0).getChild(0));
                }
            }
        }
    }

    protected void alias(GrammarAST t, GrammarAST s) {
        String prevAliasTokenID;
        String tokenID = t.getText();
        String literal = s.getText();
        String prevAliasLiteralID = this.aliasesReverseIndex.get(literal);
        if (prevAliasLiteralID != null) {
            if (tokenID.equals(prevAliasLiteralID)) {
                return;
            }
            if (!this.tokenRuleDefs.contains(tokenID) || !this.tokenRuleDefs.contains(prevAliasLiteralID)) {
                ErrorManager.grammarError(158, this.grammar, t.token, tokenID + "=" + literal, prevAliasLiteralID);
            }
            return;
        }
        int existingLiteralType = this.grammar.getTokenType(literal);
        if (existingLiteralType != -7) {
            this.tokens.put(tokenID, existingLiteralType);
        }
        if ((prevAliasTokenID = this.aliases.get(tokenID)) != null) {
            ErrorManager.grammarError(159, this.grammar, t.token, tokenID + "=" + literal, prevAliasTokenID);
            return;
        }
        this.aliases.put(tokenID, literal);
        this.aliasesReverseIndex.put(literal, tokenID);
    }

    public void defineTokens(Grammar root) {
        this.assignTokenIDTypes(root);
        this.aliasTokenIDsAndLiterals(root);
        this.assignStringTypes(root);
        this.defineTokenNamesAndLiteralsInGrammar(root);
    }

    protected void assignStringTypes(Grammar root) {
        for (Map.Entry<String, Integer> entry : this.stringLiterals.entrySet()) {
            String lit = entry.getKey();
            Integer oldTypeI = entry.getValue();
            int oldType = oldTypeI;
            if (oldType >= 4) continue;
            Integer typeI = Utils.integer(root.getNewTokenType());
            this.stringLiterals.put(lit, typeI);
            root.defineLexerRuleForStringLiteral(lit, typeI);
        }
    }

    protected void aliasTokenIDsAndLiterals(Grammar root) {
        if (root.type == 1) {
            return;
        }
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            String tokenID = entry.getKey();
            String literal = entry.getValue();
            if (literal.charAt(0) != '\'' || this.stringLiterals.get(literal) == null) continue;
            this.stringLiterals.put(literal, this.tokens.get(tokenID));
            Integer typeI = this.tokens.get(tokenID);
            if (this.tokenRuleDefs.contains(tokenID)) continue;
            root.defineLexerRuleForAliasedStringLiteral(tokenID, literal, typeI);
        }
    }

    protected void assignTokenIDTypes(Grammar root) {
        for (Map.Entry<String, Integer> entry : this.tokens.entrySet()) {
            String tokenID = entry.getKey();
            if (entry.getValue() != UNASSIGNED) continue;
            this.tokens.put(tokenID, Utils.integer(root.getNewTokenType()));
        }
    }

    protected void defineTokenNamesAndLiteralsInGrammar(Grammar root) {
        for (Map.Entry<String, Integer> entry : this.tokens.entrySet()) {
            int ttype = entry.getValue();
            root.defineToken(entry.getKey(), ttype);
        }
        for (Map.Entry<String, Integer> entry : this.stringLiterals.entrySet()) {
            String lit = entry.getKey();
            int ttype = entry.getValue();
            root.defineToken(lit, ttype);
        }
    }
}

