/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public class StreamingHistogram {
    public static final StreamingHistogramSerializer serializer = new StreamingHistogramSerializer();
    private final TreeMap<Number, long[]> bin;
    private final int maxBinSize;

    public StreamingHistogram(int maxBinSize) {
        this.maxBinSize = maxBinSize;
        this.bin = new TreeMap((o1, o2) -> {
            if (o1.getClass().equals(o2.getClass())) {
                return ((Comparable)((Object)o1)).compareTo(o2);
            }
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        });
    }

    private StreamingHistogram(int maxBinSize, Map<Double, Long> bin) {
        this(maxBinSize);
        for (Map.Entry<Double, Long> entry : bin.entrySet()) {
            this.bin.put(entry.getKey(), new long[]{entry.getValue()});
        }
    }

    public void update(Number p) {
        this.update(p, 1L);
    }

    public void update(Number p, long m) {
        long[] mi = this.bin.get(p);
        if (mi != null) {
            mi[0] = mi[0] + m;
        } else {
            mi = new long[]{m};
            this.bin.put(p, mi);
            while (this.bin.size() > this.maxBinSize) {
                Iterator<Number> keys = this.bin.keySet().iterator();
                double p1 = keys.next().doubleValue();
                double p2 = keys.next().doubleValue();
                double smallestDiff = p2 - p1;
                double q1 = p1;
                double q2 = p2;
                while (keys.hasNext()) {
                    p1 = p2;
                    p2 = keys.next().doubleValue();
                    double diff = p2 - p1;
                    if (!(diff < smallestDiff)) continue;
                    smallestDiff = diff;
                    q1 = p1;
                    q2 = p2;
                }
                long[] a1 = this.bin.remove(q1);
                long[] a2 = this.bin.remove(q2);
                long k1 = a1[0];
                long k2 = a2[0];
                a1[0] = a1[0] + k2;
                this.bin.put((q1 * (double)k1 + q2 * (double)k2) / (double)(k1 + k2), a1);
            }
        }
    }

    public void merge(StreamingHistogram other) {
        if (other == null) {
            return;
        }
        for (Map.Entry<Number, long[]> entry : other.getAsMap().entrySet()) {
            this.update(entry.getKey(), entry.getValue()[0]);
        }
    }

    public double sum(double b) {
        double sum = 0.0;
        Map.Entry<Number, long[]> pnext = this.bin.higherEntry(b);
        if (pnext == null) {
            for (long[] value : this.bin.values()) {
                sum += (double)value[0];
            }
        } else {
            Map.Entry<Number, long[]> pi = this.bin.floorEntry(b);
            if (pi == null) {
                return 0.0;
            }
            double weight = (b - pi.getKey().doubleValue()) / (pnext.getKey().doubleValue() - pi.getKey().doubleValue());
            double mb = (double)pi.getValue()[0] + (double)(pnext.getValue()[0] - pi.getValue()[0]) * weight;
            sum += ((double)pi.getValue()[0] + mb) * weight / 2.0;
            sum += (double)pi.getValue()[0] / 2.0;
            for (long[] value : this.bin.headMap(pi.getKey(), false).values()) {
                sum += (double)value[0];
            }
        }
        return sum;
    }

    public Map<Number, long[]> getAsMap() {
        return Collections.unmodifiableMap(this.bin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamingHistogram)) {
            return false;
        }
        StreamingHistogram that = (StreamingHistogram)o;
        return this.maxBinSize == that.maxBinSize && this.bin.equals(that.bin);
    }

    public int hashCode() {
        return Objects.hashCode(this.bin.hashCode(), this.maxBinSize);
    }

    public static class StreamingHistogramSerializer
    implements ISerializer<StreamingHistogram> {
        @Override
        public void serialize(StreamingHistogram histogram, DataOutputPlus out) throws IOException {
            out.writeInt(histogram.maxBinSize);
            Map<Number, long[]> entries = histogram.getAsMap();
            out.writeInt(entries.size());
            for (Map.Entry<Number, long[]> entry : entries.entrySet()) {
                out.writeDouble(entry.getKey().doubleValue());
                out.writeLong(entry.getValue()[0]);
            }
        }

        @Override
        public StreamingHistogram deserialize(DataInputPlus in) throws IOException {
            int maxBinSize = in.readInt();
            int size = in.readInt();
            HashMap<Double, Long> tmp = new HashMap<Double, Long>(size);
            for (int i = 0; i < size; ++i) {
                tmp.put(in.readDouble(), in.readLong());
            }
            return new StreamingHistogram(maxBinSize, tmp);
        }

        @Override
        public long serializedSize(StreamingHistogram histogram) {
            long size = TypeSizes.sizeof(histogram.maxBinSize);
            Map<Number, long[]> entries = histogram.getAsMap();
            size += (long)TypeSizes.sizeof(entries.size());
            return size += (long)entries.size() * 16L;
        }
    }
}

