/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.UUID;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ByteBuf body, int version) {
            byte[] id = CBUtil.readBytes(body);
            return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(ExecuteMessage msg, ByteBuf dest, int version) {
            CBUtil.writeBytes(msg.statementId.bytes, dest);
            if (version == 1) {
                CBUtil.writeValueList(msg.options.getValues(), dest);
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(ExecuteMessage msg, int version) {
            int size = 0;
            size += CBUtil.sizeOfBytes(msg.statementId.bytes);
            if (version == 1) {
                size += CBUtil.sizeOfValueList(msg.options.getValues());
                size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency());
            } else {
                size += QueryOptions.codec.encodedSize(msg.options, version);
            }
            return size;
        }
    };
    public final MD5Digest statementId;
    public final QueryOptions options;

    public ExecuteMessage(MD5Digest statementId, QueryOptions options) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ParsedStatement.Prepared prepared = handler.getPrepared(this.statementId);
            if (prepared == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            this.options.prepare(prepared.boundNames);
            CQLStatement statement = prepared.statement;
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession(this.getCustomPayload());
                ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
                if (this.options.getPageSize() > 0) {
                    builder.put("page_size", Integer.toString(this.options.getPageSize()));
                }
                if (this.options.getConsistency() != null) {
                    builder.put("consistency_level", this.options.getConsistency().name());
                }
                if (this.options.getSerialConsistency() != null) {
                    builder.put("serial_consistency_level", this.options.getSerialConsistency().name());
                }
                builder.put("query", prepared.rawCQLStatement);
                for (int i = 0; i < prepared.boundNames.size(); ++i) {
                    ColumnSpecification cs = prepared.boundNames.get(i);
                    String boundName = cs.name.toString();
                    String boundValue = cs.type.asCQL3Type().toCQLLiteral(this.options.getValues().get(i), this.options.getProtocolVersion());
                    if (boundValue.length() > 1000) {
                        boundValue = boundValue.substring(0, 1000) + "...'";
                    }
                    builder.put("bound_var_" + Integer.toString(i) + "_" + boundName, boundValue);
                }
                Tracing.instance.begin("Execute CQL3 prepared query", state.getClientAddress(), builder.build());
            }
            QueryOptions queryOptions = QueryOptions.addColumnSpecifications(this.options, prepared.boundNames);
            ResultMessage response = handler.processPrepared(statement, state, queryOptions, this.getCustomPayload());
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.options.getValues().size() + " values at consistency " + (Object)((Object)this.options.getConsistency());
    }
}

