/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.cassandraunit.shaded.io.netty.channel.Channel;

public class ServerConnection
extends Connection {
    private volatile IAuthenticator.SaslNegotiator saslNegotiator;
    private final ClientState clientState;
    private volatile State state;
    private final ConcurrentMap<Integer, QueryState> queryStates = new ConcurrentHashMap<Integer, QueryState>();

    public ServerConnection(Channel channel, int version, Connection.Tracker tracker) {
        super(channel, version, tracker);
        this.clientState = ClientState.forExternalCalls(channel.remoteAddress());
        this.state = State.UNINITIALIZED;
    }

    private QueryState getQueryState(int streamId) {
        QueryState qState = (QueryState)this.queryStates.get(streamId);
        if (qState == null) {
            QueryState newState = new QueryState(this.clientState);
            qState = this.queryStates.putIfAbsent(streamId, newState);
            if (qState == null) {
                qState = newState;
            }
        }
        return qState;
    }

    public QueryState validateNewMessage(Message.Type type, int version, int streamId) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (type == Message.Type.STARTUP || type == Message.Type.OPTIONS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{type}));
            }
            case AUTHENTICATION: {
                if (type == Message.Type.AUTH_RESPONSE || type == Message.Type.CREDENTIALS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting %s", new Object[]{type, version == 1 ? "CREDENTIALS" : "SASL_RESPONSE"}));
            }
            case READY: {
                if (type != Message.Type.STARTUP) break;
                throw new ProtocolException("Unexpected message STARTUP, the connection is already initialized");
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.getQueryState(streamId);
    }

    public void applyStateTransition(Message.Type requestType, Message.Type responseType) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (requestType != Message.Type.STARTUP) break;
                if (responseType == Message.Type.AUTHENTICATE) {
                    this.state = State.AUTHENTICATION;
                    break;
                }
                if (responseType != Message.Type.READY) break;
                this.state = State.READY;
                break;
            }
            case AUTHENTICATION: {
                assert (requestType == Message.Type.AUTH_RESPONSE || requestType == Message.Type.CREDENTIALS);
                if (responseType != Message.Type.READY && responseType != Message.Type.AUTH_SUCCESS) break;
                this.state = State.READY;
                this.saslNegotiator = null;
                break;
            }
            case READY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public IAuthenticator.SaslNegotiator getSaslNegotiator(QueryState queryState) {
        if (this.saslNegotiator == null) {
            this.saslNegotiator = DatabaseDescriptor.getAuthenticator().newSaslNegotiator(queryState.getClientAddress());
        }
        return this.saslNegotiator;
    }

    private static enum State {
        UNINITIALIZED,
        AUTHENTICATION,
        READY;

    }
}

