/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.concurrent.ExecutorLocal;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.TracingImpl;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.UUIDGen;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tracing
implements ExecutorLocal<TraceState> {
    public static final String TRACE_HEADER = "TraceSession";
    public static final String TRACE_TYPE = "TraceType";
    protected static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    protected final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance;

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public TraceType getTraceType() {
        assert (Tracing.isTracing());
        return this.state.get().traceType;
    }

    public int getTTL() {
        assert (Tracing.isTracing());
        return this.state.get().ttl;
    }

    public static boolean isTracing() {
        return instance.get() != null;
    }

    public UUID newSession(Map<String, ByteBuffer> customPayload) {
        return this.newSession(TraceType.QUERY);
    }

    public UUID newSession(TraceType traceType) {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())), traceType, Collections.EMPTY_MAP);
    }

    public UUID newSession(UUID sessionId, Map<String, ByteBuffer> customPayload) {
        return this.newSession(sessionId, TraceType.QUERY, Collections.EMPTY_MAP);
    }

    protected UUID newSession(UUID sessionId, TraceType traceType, Map<String, ByteBuffer> customPayload) {
        assert (this.get() == null);
        TraceState ts = this.newTraceState(this.localAddress, sessionId, traceType);
        this.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void doneWithNonLocalSession(TraceState state) {
        if (state.releaseReference() == 0) {
            this.sessions.remove(state.sessionId);
        }
    }

    public void stopSession() {
        TraceState state = this.get();
        if (state == null) {
            logger.trace("request complete");
        } else {
            this.stopSessionImpl();
            state.stop();
            this.sessions.remove(state.sessionId);
            this.set(null);
        }
    }

    protected abstract void stopSessionImpl();

    @Override
    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    @Override
    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public TraceState begin(String request, Map<String, String> parameters) {
        return this.begin(request, null, parameters);
    }

    public abstract TraceState begin(String var1, InetAddress var2, Map<String, String> var3);

    public TraceState initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            return null;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = this.get(sessionId);
        if (ts != null && ts.acquireReference()) {
            return ts;
        }
        TraceType traceType = TraceType.QUERY;
        byte[] tmpBytes = message.parameters.get(TRACE_TYPE);
        if (tmpBytes != null) {
            traceType = TraceType.deserialize(tmpBytes[0]);
        }
        if (message.verb == MessagingService.Verb.REQUEST_RESPONSE) {
            return new ExpiredTraceState(this.newTraceState(message.from, sessionId, traceType));
        }
        ts = this.newTraceState(message.from, sessionId, traceType);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public Map<String, byte[]> getTraceHeaders() {
        assert (Tracing.isTracing());
        return ImmutableMap.of(TRACE_HEADER, UUIDGen.decompose(instance.getSessionId()), TRACE_TYPE, new byte[]{TraceType.serialize(instance.getTraceType())});
    }

    protected abstract TraceState newTraceState(InetAddress var1, UUID var2, TraceType var3);

    public static void traceRepair(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public abstract void trace(ByteBuffer var1, String var2, int var3);

    static {
        Tracing tracing = null;
        String customTracingClass = System.getProperty("cassandra.custom_tracing_class");
        if (null != customTracingClass) {
            try {
                tracing = (Tracing)FBUtilities.construct(customTracingClass, "Tracing");
                logger.info("Using {} as tracing queries (as requested with -Dcassandra.custom_tracing_class)", (Object)customTracingClass);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.error("Cannot use class {} for tracing ({}), ignoring by defaulting on normal tracing", (Object)customTracingClass, (Object)e.getMessage());
            }
        }
        instance = null != tracing ? tracing : new TracingImpl();
    }

    public static enum TraceType {
        NONE,
        QUERY,
        REPAIR;

        private static final TraceType[] ALL_VALUES;
        private static final int[] TTLS;

        public static TraceType deserialize(byte b) {
            if (b < 0 || ALL_VALUES.length <= b) {
                return NONE;
            }
            return ALL_VALUES[b];
        }

        public static byte serialize(TraceType value) {
            return (byte)value.ordinal();
        }

        public int getTTL() {
            return TTLS[this.ordinal()];
        }

        static {
            ALL_VALUES = TraceType.values();
            TTLS = new int[]{DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeRepairTTL()};
        }
    }
}

