/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;

public class MessageOut<T> {
    public final InetAddress from;
    public final MessagingService.Verb verb;
    public final T payload;
    public final IVersionedSerializer<T> serializer;
    public final Map<String, byte[]> parameters;
    private long payloadSize = -1L;
    private int payloadSizeVersion = -1;

    public MessageOut(MessagingService.Verb verb) {
        this(verb, null, null);
    }

    public MessageOut(MessagingService.Verb verb, T payload, IVersionedSerializer<T> serializer) {
        this(verb, payload, serializer, Tracing.isTracing() ? Tracing.instance.getTraceHeaders() : Collections.emptyMap());
    }

    private MessageOut(MessagingService.Verb verb, T payload, IVersionedSerializer<T> serializer, Map<String, byte[]> parameters) {
        this(FBUtilities.getBroadcastAddress(), verb, payload, serializer, parameters);
    }

    @VisibleForTesting
    public MessageOut(InetAddress from, MessagingService.Verb verb, T payload, IVersionedSerializer<T> serializer, Map<String, byte[]> parameters) {
        this.from = from;
        this.verb = verb;
        this.payload = payload;
        this.serializer = serializer;
        this.parameters = parameters;
    }

    public MessageOut<T> withParameter(String key, byte[] value) {
        ImmutableMap.Builder<String, byte[]> builder = ImmutableMap.builder();
        builder.putAll(this.parameters).put(key, value);
        return new MessageOut<T>(this.verb, this.payload, this.serializer, builder.build());
    }

    public Stage getStage() {
        return MessagingService.verbStages.get((Object)this.verb);
    }

    public long getTimeout() {
        return DatabaseDescriptor.getTimeout(this.verb);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("TYPE:").append((Object)this.getStage()).append(" VERB:").append((Object)this.verb);
        return sbuf.toString();
    }

    public void serialize(DataOutputPlus out, int version) throws IOException {
        CompactEndpointSerializationHelper.serialize(this.from, out);
        out.writeInt(MessagingService.Verb.convertForMessagingServiceVersion(this.verb, version).ordinal());
        out.writeInt(this.parameters.size());
        for (Map.Entry<String, byte[]> entry : this.parameters.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(entry.getValue().length);
            out.write(entry.getValue());
        }
        long longSize = this.payloadSize(version);
        assert (longSize <= Integer.MAX_VALUE);
        out.writeInt((int)longSize);
        if (this.payload != null) {
            this.serializer.serialize(this.payload, out, version);
        }
    }

    public int serializedSize(int version) {
        int size = CompactEndpointSerializationHelper.serializedSize(this.from);
        size += TypeSizes.sizeof(this.verb.ordinal());
        size += TypeSizes.sizeof(this.parameters.size());
        for (Map.Entry<String, byte[]> entry : this.parameters.entrySet()) {
            size += TypeSizes.sizeof(entry.getKey());
            size += TypeSizes.sizeof(entry.getValue().length);
            size += entry.getValue().length;
        }
        long longSize = this.payloadSize(version);
        assert (longSize <= Integer.MAX_VALUE);
        size += TypeSizes.sizeof((int)longSize);
        size = (int)((long)size + longSize);
        return size;
    }

    public long payloadSize(int version) {
        if (this.payloadSize == -1L) {
            this.payloadSize = this.payload == null ? 0L : this.serializer.serializedSize(this.payload, version);
            this.payloadSizeVersion = version;
        } else if (this.payloadSizeVersion != version) {
            return this.payload == null ? 0L : this.serializer.serializedSize(this.payload, version);
        }
        return this.payloadSize;
    }
}

