/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import java.io.Closeable;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.cassandra.index.sasi.utils.AbstractIterator;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;

public abstract class RangeIterator<K extends Comparable<K>, T extends CombinedValue<K>>
extends AbstractIterator<T>
implements Closeable {
    private final K min;
    private final K max;
    private final long count;
    private K current;

    protected RangeIterator(Builder.Statistics<K, T> statistics) {
        this(statistics.min, statistics.max, statistics.tokenCount);
    }

    public RangeIterator(RangeIterator<K, T> range) {
        this((range == null ? null : (K)range.min), (range == null ? null : (K)range.max), range == null ? -1L : range.count);
    }

    public RangeIterator(K min, K max, long count) {
        this.min = min;
        this.current = min;
        this.max = max;
        this.count = count;
    }

    public final K getMinimum() {
        return this.min;
    }

    public final K getCurrent() {
        return this.current;
    }

    public final K getMaximum() {
        return this.max;
    }

    public final long getCount() {
        return this.count;
    }

    public final T skipTo(K nextToken) {
        if (this.min == null || this.max == null) {
            return (T)((CombinedValue)this.endOfData());
        }
        if (this.current.compareTo(nextToken) >= 0) {
            return (T)(this.next == null ? this.recomputeNext() : (CombinedValue)this.next);
        }
        if (this.max.compareTo(nextToken) < 0) {
            return (T)((CombinedValue)this.endOfData());
        }
        this.performSkipTo(nextToken);
        return this.recomputeNext();
    }

    protected abstract void performSkipTo(K var1);

    protected T recomputeNext() {
        return (T)(this.tryToComputeNext() ? (CombinedValue)this.peek() : (CombinedValue)this.endOfData());
    }

    @Override
    protected boolean tryToComputeNext() {
        boolean hasNext = super.tryToComputeNext();
        this.current = hasNext ? (Comparable)((CombinedValue)this.next).get() : this.getMaximum();
        return hasNext;
    }

    @VisibleForTesting
    protected static <K extends Comparable<K>, D extends CombinedValue<K>> boolean isOverlapping(RangeIterator<K, D> a, RangeIterator<K, D> b) {
        return RangeIterator.isOverlapping(a.getCurrent(), a.getMaximum(), b);
    }

    @VisibleForTesting
    protected static <K extends Comparable<K>, D extends CombinedValue<K>> boolean isOverlapping(K min, K max, RangeIterator<K, D> b) {
        return min.compareTo(b.getMaximum()) <= 0 && b.getCurrent().compareTo(max) <= 0;
    }

    public static abstract class Builder<K extends Comparable<K>, D extends CombinedValue<K>> {
        @VisibleForTesting
        protected final Statistics<K, D> statistics;
        @VisibleForTesting
        protected final PriorityQueue<RangeIterator<K, D>> ranges;

        public Builder(IteratorType type) {
            this.statistics = new Statistics(type);
            this.ranges = new PriorityQueue(16, (a, b) -> a.getCurrent().compareTo(b.getCurrent()));
        }

        public K getMinimum() {
            return this.statistics.min;
        }

        public K getMaximum() {
            return this.statistics.max;
        }

        public long getTokenCount() {
            return this.statistics.tokenCount;
        }

        public int rangeCount() {
            return this.ranges.size();
        }

        public Builder<K, D> add(RangeIterator<K, D> range) {
            if (range == null || range.getMinimum() == null || range.getMaximum() == null) {
                return this;
            }
            this.ranges.add(range);
            this.statistics.update(range);
            return this;
        }

        public Builder<K, D> add(List<RangeIterator<K, D>> ranges) {
            if (ranges == null || ranges.isEmpty()) {
                return this;
            }
            ranges.forEach(this::add);
            return this;
        }

        public final RangeIterator<K, D> build() {
            switch (this.rangeCount()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.ranges.poll();
                }
            }
            return this.buildIterator();
        }

        protected abstract RangeIterator<K, D> buildIterator();

        public static class Statistics<K extends Comparable<K>, D extends CombinedValue<K>> {
            protected final IteratorType iteratorType;
            protected K min;
            protected K max;
            protected long tokenCount;
            protected RangeIterator<K, D> minRange;
            protected RangeIterator<K, D> maxRange;
            protected boolean isOverlapping = true;

            public Statistics(IteratorType iteratorType) {
                this.iteratorType = iteratorType;
            }

            public void update(RangeIterator<K, D> range) {
                switch (this.iteratorType) {
                    case UNION: {
                        this.min = this.min == null || this.min.compareTo(range.getMinimum()) > 0 ? range.getMinimum() : this.min;
                        this.max = this.max == null || this.max.compareTo(range.getMaximum()) < 0 ? range.getMaximum() : this.max;
                        break;
                    }
                    case INTERSECTION: {
                        this.min = this.min == null || this.min.compareTo(range.getMinimum()) < 0 ? range.getMinimum() : this.min;
                        this.max = this.max == null || this.max.compareTo(range.getMaximum()) > 0 ? range.getMaximum() : this.max;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown iterator type: " + (Object)((Object)this.iteratorType));
                    }
                }
                this.isOverlapping &= RangeIterator.isOverlapping(this.min, this.max, range);
                this.minRange = this.minRange == null ? range : this.min(this.minRange, range);
                this.maxRange = this.maxRange == null ? range : this.max(this.maxRange, range);
                this.tokenCount += range.getCount();
            }

            private RangeIterator<K, D> min(RangeIterator<K, D> a, RangeIterator<K, D> b) {
                return a.getCount() > b.getCount() ? b : a;
            }

            private RangeIterator<K, D> max(RangeIterator<K, D> a, RangeIterator<K, D> b) {
                return a.getCount() > b.getCount() ? a : b;
            }

            public boolean isDisjoint() {
                return !this.isOverlapping;
            }

            public double sizeRatio() {
                return (double)this.minRange.getCount() * 1.0 / (double)this.maxRange.getCount();
            }
        }

        public static enum IteratorType {
            UNION,
            INTERSECTION;

        }
    }
}

