/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogReplica;
import org.apache.cassandra.utils.Throwables;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReplicaSet {
    private static final Logger logger = LoggerFactory.getLogger(LogReplicaSet.class);
    private final Map<File, LogReplica> replicasByFile = new LinkedHashMap<File, LogReplica>();

    private Collection<LogReplica> replicas() {
        return this.replicasByFile.values();
    }

    void addReplicas(List<File> replicas) {
        replicas.forEach(this::addReplica);
    }

    void addReplica(File file) {
        File directory = file.getParentFile();
        assert (!this.replicasByFile.containsKey(directory));
        this.replicasByFile.put(directory, LogReplica.open(file));
        if (logger.isTraceEnabled()) {
            logger.trace("Added log file replica {} ", (Object)file);
        }
    }

    void maybeCreateReplica(File directory, String fileName, Set<LogRecord> records) {
        if (this.replicasByFile.containsKey(directory)) {
            return;
        }
        LogReplica replica = LogReplica.create(directory, fileName);
        records.forEach(replica::append);
        this.replicasByFile.put(directory, replica);
        if (logger.isTraceEnabled()) {
            logger.trace("Created new file replica {}", (Object)replica);
        }
    }

    Throwable syncDirectory(Throwable accumulate) {
        return Throwables.perform(accumulate, this.replicas().stream().map(s -> s::syncDirectory));
    }

    Throwable delete(Throwable accumulate) {
        return Throwables.perform(accumulate, this.replicas().stream().map(s -> s::delete));
    }

    private static boolean isPrefixMatch(String first, String second) {
        return first.length() >= second.length() ? first.startsWith(second) : second.startsWith(first);
    }

    boolean readRecords(Set<LogRecord> records) {
        Map linesByReplica = this.replicas().stream().collect(Collectors.toMap(Function.identity(), LogReplica::readLines, (k, v) -> {
            throw new IllegalStateException("Duplicated key: " + k);
        }, LinkedHashMap::new));
        int maxNumLines = linesByReplica.values().stream().map(List::size).reduce(0, Integer::max);
        for (int i = 0; i < maxNumLines; ++i) {
            String firstLine = null;
            boolean partial = false;
            for (Map.Entry entry : linesByReplica.entrySet()) {
                List currentLines = (List)entry.getValue();
                if (i >= currentLines.size()) continue;
                String currentLine = (String)currentLines.get(i);
                if (firstLine == null) {
                    firstLine = currentLine;
                    continue;
                }
                if (!LogReplicaSet.isPrefixMatch(firstLine, currentLine)) {
                    logger.error("Mismatched line in file {}: got '{}' expected '{}', giving up", new Object[]{((LogReplica)entry.getKey()).getFileName(), currentLine, firstLine});
                    ((LogReplica)entry.getKey()).setError(currentLine, String.format("Does not match <%s> in first replica file", firstLine));
                    return false;
                }
                if (firstLine.equals(currentLine)) continue;
                if (i == currentLines.size() - 1) {
                    logger.warn("Mismatched last line in file {}: '{}' not the same as '{}'", new Object[]{((LogReplica)entry.getKey()).getFileName(), currentLine, firstLine});
                    if (currentLine.length() > firstLine.length()) {
                        firstLine = currentLine;
                    }
                    partial = true;
                    continue;
                }
                logger.error("Mismatched line in file {}: got '{}' expected '{}', giving up", new Object[]{((LogReplica)entry.getKey()).getFileName(), currentLine, firstLine});
                ((LogReplica)entry.getKey()).setError(currentLine, String.format("Does not match <%s> in first replica file", firstLine));
                return false;
            }
            LogRecord record = LogRecord.make(firstLine);
            if (records.contains(record)) {
                logger.error("Found duplicate record {} for {}, giving up", (Object)record, (Object)record.fileName());
                this.setError(record, "Duplicated record");
                return false;
            }
            if (partial) {
                record.setPartial();
            }
            records.add(record);
            if (!record.isFinal() || i == maxNumLines - 1) continue;
            logger.error("Found too many lines for {}, giving up", (Object)record.fileName());
            this.setError(record, "This record should have been the last one in all replicas");
            return false;
        }
        return true;
    }

    void setError(LogRecord record, String error) {
        record.setError(error);
        this.setErrorInReplicas(record);
    }

    void setErrorInReplicas(LogRecord record) {
        this.replicas().forEach(r -> r.setError(record.raw, record.error()));
    }

    void printContentsWithAnyErrors(StringBuilder str) {
        this.replicas().forEach(r -> r.printContentsWithAnyErrors(str));
    }

    void append(LogRecord record) {
        Throwable err = Throwables.perform(null, this.replicas().stream().map(r -> () -> r.append(record)));
        if (err != null) {
            if (!record.isFinal() || err.getSuppressed().length == this.replicas().size() - 1) {
                Throwables.maybeFail(err);
            }
            logger.error("Failed to add record '{}' to some replicas '{}'", (Object)record, (Object)this);
        }
    }

    boolean exists() {
        Optional<Boolean> ret = this.replicas().stream().map(LogReplica::exists).reduce(Boolean::logicalAnd);
        return ret.isPresent() ? ret.get() : false;
    }

    void close() {
        Throwables.maybeFail(Throwables.perform(null, this.replicas().stream().map(r -> r::close)));
    }

    public String toString() {
        Optional<String> ret = this.replicas().stream().map(LogReplica::toString).reduce(String::concat);
        return ret.isPresent() ? ret.get() : "[-]";
    }

    String getDirectories() {
        return String.join((CharSequence)", ", this.replicas().stream().map(LogReplica::getDirectory).collect(Collectors.toList()));
    }

    @VisibleForTesting
    List<File> getFiles() {
        return this.replicas().stream().map(LogReplica::file).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<String> getFilePaths() {
        return this.replicas().stream().map(LogReplica::file).map(File::getPath).collect(Collectors.toList());
    }
}

