/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.statements.CFProperties;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftValidation;

public class CreateViewStatement
extends SchemaAlteringStatement {
    private final CFName baseName;
    private final List<RawSelector> selectClause;
    private final WhereClause whereClause;
    private final List<ColumnDefinition.Raw> partitionKeys;
    private final List<ColumnDefinition.Raw> clusteringKeys;
    public final CFProperties properties = new CFProperties();
    private final boolean ifNotExists;

    public CreateViewStatement(CFName viewName, CFName baseName, List<RawSelector> selectClause, WhereClause whereClause, List<ColumnDefinition.Raw> partitionKeys, List<ColumnDefinition.Raw> clusteringKeys, boolean ifNotExists) {
        super(viewName);
        this.baseName = baseName;
        this.selectClause = selectClause;
        this.whereClause = whereClause;
        this.partitionKeys = partitionKeys;
        this.clusteringKeys = clusteringKeys;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (!this.baseName.hasKeyspace()) {
            this.baseName.setKeyspace(this.keyspace(), true);
        }
        state.hasColumnFamilyAccess(this.keyspace(), this.baseName.getColumnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
    }

    private void add(CFMetaData baseCfm, Iterable<ColumnIdentifier> columns, AddColumn adder) {
        for (ColumnIdentifier column : columns) {
            AbstractType type = baseCfm.getColumnDefinition((ColumnIdentifier)column).type;
            if (this.properties.definedOrdering.containsKey(column)) {
                boolean desc = this.properties.definedOrdering.get(column);
                if (!desc && type.isReversed()) {
                    type = ((ReversedType)type).baseType;
                } else if (desc && !type.isReversed()) {
                    type = ReversedType.getInstance(type);
                }
            }
            adder.add(column, type);
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        this.properties.validate();
        if (this.properties.useCompactStorage) {
            throw new InvalidRequestException("Cannot use 'COMPACT STORAGE' when defining a materialized view");
        }
        if (!this.baseName.getKeyspace().equals(this.keyspace())) {
            throw new InvalidRequestException("Cannot create a materialized view on a table in a separate keyspace");
        }
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.baseName.getKeyspace(), this.baseName.getColumnFamily());
        if (cfm.isCounter()) {
            throw new InvalidRequestException("Materialized views are not supported on counter tables");
        }
        if (cfm.isView()) {
            throw new InvalidRequestException("Materialized views cannot be created against other materialized views");
        }
        if (cfm.params.gcGraceSeconds == 0) {
            throw new InvalidRequestException(String.format("Cannot create materialized view '%s' for base table '%s' with gc_grace_seconds of 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", this.cfName.getColumnFamily(), this.baseName.getColumnFamily()));
        }
        HashSet<ColumnIdentifier> included = new HashSet<ColumnIdentifier>();
        for (RawSelector rawSelector : this.selectClause) {
            Selectable.Raw selectable = rawSelector.selectable;
            if (selectable instanceof Selectable.WithFieldSelection.Raw) {
                throw new InvalidRequestException("Cannot select out a part of type when defining a materialized view");
            }
            if (selectable instanceof Selectable.WithFunction.Raw) {
                throw new InvalidRequestException("Cannot use function when defining a materialized view");
            }
            if (selectable instanceof Selectable.WritetimeOrTTL.Raw) {
                throw new InvalidRequestException("Cannot use function when defining a materialized view");
            }
            if (rawSelector.alias != null) {
                throw new InvalidRequestException("Cannot use alias when defining a materialized view");
            }
            Selectable s = selectable.prepare(cfm);
            if (s instanceof Term.Raw) {
                throw new InvalidRequestException("Cannot use terms in selection when defining a materialized view");
            }
            ColumnDefinition cdef = (ColumnDefinition)s;
            included.add(cdef.name);
        }
        HashSet<ColumnDefinition.Raw> targetPrimaryKeys = new HashSet<ColumnDefinition.Raw>();
        for (ColumnDefinition.Raw identifier : Iterables.concat(this.partitionKeys, this.clusteringKeys)) {
            if (!targetPrimaryKeys.add(identifier)) {
                throw new InvalidRequestException("Duplicate entry found in PRIMARY KEY: " + identifier);
            }
            ColumnDefinition cdef = identifier.prepare(cfm);
            if (cdef.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Cannot use MultiCell column '%s' in PRIMARY KEY of materialized view", identifier));
            }
            if (!cdef.isStatic()) continue;
            throw new InvalidRequestException(String.format("Cannot use Static column '%s' in PRIMARY KEY of materialized view", identifier));
        }
        Map<ColumnDefinition.Raw, Boolean> map = Collections.emptyMap();
        SelectStatement.Parameters parameters = new SelectStatement.Parameters(map, false, true, false);
        SelectStatement.RawStatement rawSelect = new SelectStatement.RawStatement(this.baseName, parameters, this.selectClause, this.whereClause, null, null);
        ClientState state = ClientState.forInternalCalls();
        state.setKeyspace(this.keyspace());
        rawSelect.prepareKeyspace(state);
        rawSelect.setBoundVariables(this.getBoundVariables());
        ParsedStatement.Prepared prepared = rawSelect.prepare(true);
        SelectStatement select = (SelectStatement)prepared.statement;
        StatementRestrictions restrictions = select.getRestrictions();
        if (!prepared.boundNames.isEmpty()) {
            throw new InvalidRequestException("Cannot use query parameters in CREATE MATERIALIZED VIEW statements");
        }
        if (!restrictions.nonPKRestrictedColumns(false).isEmpty()) {
            throw new InvalidRequestException(String.format("Non-primary key columns cannot be restricted in the SELECT statement used for materialized view creation (got restrictions on: %s)", restrictions.nonPKRestrictedColumns(false).stream().map(def -> def.name.toString()).collect(Collectors.joining(", "))));
        }
        String whereClauseText = View.relationsToWhereClause(this.whereClause.relations);
        HashSet<ColumnIdentifier> basePrimaryKeyCols = new HashSet<ColumnIdentifier>();
        for (ColumnDefinition definition : Iterables.concat(cfm.partitionKeyColumns(), cfm.clusteringColumns())) {
            basePrimaryKeyCols.add(definition.name);
        }
        ArrayList<ColumnIdentifier> targetClusteringColumns = new ArrayList<ColumnIdentifier>();
        ArrayList<ColumnIdentifier> targetPartitionKeys = new ArrayList<ColumnIdentifier>();
        boolean hasNonPKColumn = false;
        for (ColumnDefinition.Raw raw : this.partitionKeys) {
            hasNonPKColumn |= CreateViewStatement.getColumnIdentifier(cfm, basePrimaryKeyCols, hasNonPKColumn, raw, targetPartitionKeys, restrictions);
        }
        for (ColumnDefinition.Raw raw : this.clusteringKeys) {
            hasNonPKColumn |= CreateViewStatement.getColumnIdentifier(cfm, basePrimaryKeyCols, hasNonPKColumn, raw, targetClusteringColumns, restrictions);
        }
        boolean missingClusteringColumns = false;
        StringBuilder columnNames = new StringBuilder();
        ArrayList<ColumnIdentifier> includedColumns = new ArrayList<ColumnIdentifier>();
        for (ColumnDefinition def2 : cfm.allColumns()) {
            boolean defInTargetPrimaryKey;
            boolean includeDef;
            ColumnIdentifier identifier = def2.name;
            boolean bl = includeDef = included.isEmpty() || included.contains(identifier);
            if (includeDef && def2.isStatic()) {
                throw new InvalidRequestException(String.format("Unable to include static column '%s' which would be included by Materialized View SELECT * statement", identifier));
            }
            boolean bl2 = defInTargetPrimaryKey = targetClusteringColumns.contains(identifier) || targetPartitionKeys.contains(identifier);
            if (includeDef && !defInTargetPrimaryKey) {
                includedColumns.add(identifier);
            }
            if (!def2.isPrimaryKeyColumn() || defInTargetPrimaryKey) continue;
            if (missingClusteringColumns) {
                columnNames.append(',');
            } else {
                missingClusteringColumns = true;
            }
            columnNames.append(identifier);
        }
        if (missingClusteringColumns) {
            throw new InvalidRequestException(String.format("Cannot create Materialized View %s without primary key columns from base %s (%s)", this.columnFamily(), this.baseName.getColumnFamily(), columnNames.toString()));
        }
        if (targetPartitionKeys.isEmpty()) {
            throw new InvalidRequestException("Must select at least a column for a Materialized View");
        }
        if (targetClusteringColumns.isEmpty()) {
            throw new InvalidRequestException("No columns are defined for Materialized View other than primary key");
        }
        CFMetaData.Builder cfmBuilder = CFMetaData.Builder.createView(this.keyspace(), this.columnFamily());
        this.add(cfm, targetPartitionKeys, cfmBuilder::addPartitionKey);
        this.add(cfm, targetClusteringColumns, cfmBuilder::addClusteringColumn);
        this.add(cfm, includedColumns, cfmBuilder::addRegularColumn);
        cfmBuilder.withId(this.properties.properties.getId());
        TableParams params = this.properties.properties.asNewTableParams();
        CFMetaData viewCfm = cfmBuilder.build().params(params);
        ViewDefinition definition = new ViewDefinition(this.keyspace(), this.columnFamily(), Schema.instance.getId(this.keyspace(), this.baseName.getColumnFamily()), this.baseName.getColumnFamily(), included.isEmpty(), rawSelect, whereClauseText, viewCfm);
        try {
            MigrationManager.announceNewView(definition, isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return null;
            }
            throw e;
        }
    }

    private static boolean getColumnIdentifier(CFMetaData cfm, Set<ColumnIdentifier> basePK, boolean hasNonPKColumn, ColumnDefinition.Raw raw, List<ColumnIdentifier> columns, StatementRestrictions restrictions) {
        boolean isSinglePartitionKey;
        ColumnDefinition def = raw.prepare(cfm);
        boolean isPk = basePK.contains(def.name);
        if (!isPk && hasNonPKColumn) {
            throw new InvalidRequestException(String.format("Cannot include more than one non-primary key column '%s' in materialized view primary key", def.name));
        }
        boolean bl = isSinglePartitionKey = def.isPartitionKey() && cfm.partitionKeyColumns().size() == 1;
        if (!isSinglePartitionKey && !restrictions.isRestricted(def)) {
            throw new InvalidRequestException(String.format("Primary key column '%s' is required to be filtered by 'IS NOT NULL'", def.name));
        }
        columns.add(def.name);
        return !isPk;
    }

    private static interface AddColumn {
        public void add(ColumnIdentifier var1, AbstractType<?> var2);
    }
}

