/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;

final class RestrictionSet
implements Restrictions,
Iterable<SingleRestriction> {
    private static final Comparator<ColumnDefinition> COLUMN_DEFINITION_COMPARATOR = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition column, ColumnDefinition otherColumn) {
            int value = Integer.compare(column.position(), otherColumn.position());
            return value != 0 ? value : column.name.bytes.compareTo(otherColumn.name.bytes);
        }
    };
    protected final TreeMap<ColumnDefinition, SingleRestriction> restrictions;

    public RestrictionSet() {
        this(new TreeMap<ColumnDefinition, SingleRestriction>(COLUMN_DEFINITION_COMPARATOR));
    }

    private RestrictionSet(TreeMap<ColumnDefinition, SingleRestriction> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        for (Restriction restriction : this.restrictions.values()) {
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    @Override
    public final List<ColumnDefinition> getColumnDefs() {
        return new ArrayList<ColumnDefinition>(this.restrictions.keySet());
    }

    public Stream<SingleRestriction> stream() {
        return new LinkedHashSet<SingleRestriction>(this.restrictions.values()).stream();
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        Restriction previous = null;
        for (Restriction restriction : this.restrictions.values()) {
            if (restriction.equals(previous)) continue;
            previous = restriction;
            restriction.addFunctionsTo(functions);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    @Override
    public final int size() {
        return this.restrictions.size();
    }

    public RestrictionSet addRestriction(SingleRestriction restriction) {
        TreeMap<ColumnDefinition, SingleRestriction> newRestrictions = new TreeMap<ColumnDefinition, SingleRestriction>((SortedMap<ColumnDefinition, SingleRestriction>)this.restrictions);
        return new RestrictionSet(this.mergeRestrictions(newRestrictions, restriction));
    }

    private TreeMap<ColumnDefinition, SingleRestriction> mergeRestrictions(TreeMap<ColumnDefinition, SingleRestriction> restrictions, SingleRestriction restriction) {
        List<ColumnDefinition> columnDefs = restriction.getColumnDefs();
        Set<SingleRestriction> existingRestrictions = this.getRestrictions(columnDefs);
        if (existingRestrictions.isEmpty()) {
            for (ColumnDefinition columnDef : columnDefs) {
                restrictions.put(columnDef, restriction);
            }
        } else {
            for (SingleRestriction existing : existingRestrictions) {
                SingleRestriction newRestriction = RestrictionSet.mergeRestrictions(existing, restriction);
                for (ColumnDefinition columnDef : columnDefs) {
                    restrictions.put(columnDef, newRestriction);
                }
            }
        }
        return restrictions;
    }

    private Set<SingleRestriction> getRestrictions(Collection<ColumnDefinition> columnDefs) {
        HashSet<SingleRestriction> set = new HashSet<SingleRestriction>();
        for (ColumnDefinition columnDef : columnDefs) {
            SingleRestriction existing = this.restrictions.get(columnDef);
            if (existing == null) continue;
            set.add(existing);
        }
        return set;
    }

    @Override
    public final boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (Restriction restriction : this.restrictions.values()) {
            if (!restriction.hasSupportingIndex(indexManager)) continue;
            return true;
        }
        return false;
    }

    ColumnDefinition nextColumn(ColumnDefinition columnDef) {
        return (ColumnDefinition)this.restrictions.tailMap(columnDef, false).firstKey();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.isEmpty() ? null : this.restrictions.firstKey();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.isEmpty() ? null : this.restrictions.lastKey();
    }

    SingleRestriction lastRestriction() {
        return this.isEmpty() ? null : this.restrictions.lastEntry().getValue();
    }

    private static SingleRestriction mergeRestrictions(SingleRestriction restriction, SingleRestriction otherRestriction) {
        return restriction == null ? otherRestriction : restriction.mergeWith(otherRestriction);
    }

    public final boolean hasMultipleContains() {
        int numberOfContains = 0;
        for (SingleRestriction restriction : this.restrictions.values()) {
            if (!restriction.isContains()) continue;
            SingleColumnRestriction.ContainsRestriction contains = (SingleColumnRestriction.ContainsRestriction)restriction;
            numberOfContains += contains.numberOfValues() + contains.numberOfKeys() + contains.numberOfEntries();
        }
        return numberOfContains > 1;
    }

    @Override
    public Iterator<SingleRestriction> iterator() {
        return new LinkedHashSet<SingleRestriction>(this.restrictions.values()).iterator();
    }

    @Override
    public final boolean hasIN() {
        return this.stream().anyMatch(SingleRestriction::isIN);
    }

    @Override
    public final boolean hasOnlyEqualityRestrictions() {
        return this.stream().allMatch(p -> p.isEQ() || p.isIN());
    }
}

