/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableList;

public final class WhereClause {
    private static final WhereClause EMPTY = new WhereClause(new Builder());
    public final List<Relation> relations;
    public final List<CustomIndexExpression> expressions;

    private WhereClause(Builder builder) {
        this.relations = builder.relations.build();
        this.expressions = builder.expressions.build();
    }

    public static WhereClause empty() {
        return EMPTY;
    }

    public boolean containsCustomExpressions() {
        return !this.expressions.isEmpty();
    }

    public static final class Builder {
        ImmutableList.Builder<Relation> relations = new ImmutableList.Builder();
        ImmutableList.Builder<CustomIndexExpression> expressions = new ImmutableList.Builder();

        public Builder add(Relation relation) {
            this.relations.add((Object)relation);
            return this;
        }

        public Builder add(CustomIndexExpression expression) {
            this.expressions.add((Object)expression);
            return this;
        }

        public WhereClause build() {
            return new WhereClause(this);
        }
    }
}

