/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.StatementType;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;

public final class Operations
implements Iterable<Operation> {
    private final StatementType type;
    private final List<Operation> regularOperations = new ArrayList<Operation>();
    private final List<Operation> staticOperations = new ArrayList<Operation>();

    public Operations(StatementType type) {
        this.type = type;
    }

    public boolean appliesToStaticColumns() {
        return !this.staticOperations.isEmpty();
    }

    public boolean appliesToRegularColumns() {
        return !this.regularOperations.isEmpty() || this.type.isDelete() && this.staticOperations.isEmpty();
    }

    public List<Operation> regularOperations() {
        return this.regularOperations;
    }

    public List<Operation> staticOperations() {
        return this.staticOperations;
    }

    public void add(Operation operation) {
        if (operation.column.isStatic()) {
            this.staticOperations.add(operation);
        } else {
            this.regularOperations.add(operation);
        }
    }

    public boolean requiresRead() {
        for (Operation operation : this) {
            if (!operation.requiresRead()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.staticOperations.isEmpty() && this.regularOperations.isEmpty();
    }

    @Override
    public Iterator<Operation> iterator() {
        return Iterators.concat(this.staticOperations.iterator(), this.regularOperations.iterator());
    }

    public void addFunctionsTo(List<Function> functions) {
        this.regularOperations.forEach(p -> p.addFunctionsTo(functions));
        this.staticOperations.forEach(p -> p.addFunctionsTo(functions));
    }
}

