/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xolstice.maven.plugin.protobuf.AbstractProtocTestCompileMojo;
import org.xolstice.maven.plugin.protobuf.Protoc;

@Mojo(name="test-compile-descriptor-set", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class ProtocTestCompileDescriptorSetMojo
extends AbstractProtocTestCompileMojo {
    @Parameter(required=true, property="descriptorSetTestOutputDirectory", defaultValue="${project.build.directory}/generated-test-resources/protobuf/descriptor-sets")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.finalName}.pb")
    protected String descriptorSetFileName;
    @Parameter(required=true, defaultValue="false")
    protected boolean attach;
    @Parameter(required=false, defaultValue="test")
    protected String classifier;
    @Parameter(required=false, defaultValue="false")
    protected boolean includeImports;
    @Parameter(required=false, defaultValue="false")
    protected boolean includeSourceInfo;

    @Override
    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) {
        super.addProtocBuilderParameters(protocBuilder);
        File descriptorSetFile = new File(this.getOutputDirectory(), this.descriptorSetFileName);
        this.getLog().info((CharSequence)"Will generate descriptor set:");
        this.getLog().info((CharSequence)(" " + descriptorSetFile.getAbsolutePath()));
        protocBuilder.withDescriptorSetFile(descriptorSetFile, this.includeImports, this.includeSourceInfo);
        File buildOutputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (buildOutputDirectory.exists()) {
            protocBuilder.addProtoPathElement(buildOutputDirectory);
        }
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void doAttachGeneratedFiles() {
        File outputDirectory = this.getOutputDirectory();
        if (this.attach) {
            File descriptorSetFile = new File(this.getOutputDirectory(), this.descriptorSetFileName);
            this.projectHelper.attachArtifact(this.project, "test-pb", this.classifier, descriptorSetFile);
        }
        this.buildContext.refresh(outputDirectory);
    }
}

