/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.xolstice.maven.plugin.protobuf.MojoConfigurationException;
import org.xolstice.maven.plugin.protobuf.ProtocPlugin;

final class Protoc {
    public static final String LOG_PREFIX = "[PROTOC] ";
    private final String executable;
    private final List<File> protoPathElements;
    private final List<File> protoFiles;
    private final File javaOutputDirectory;
    private final List<ProtocPlugin> plugins;
    private final File pluginDirectory;
    private final String nativePluginId;
    private final String nativePluginExecutable;
    private final String nativePluginParameter;
    private final File cppOutputDirectory;
    private final File pythonOutputDirectory;
    private final File csharpOutputDirectory;
    private final File javaScriptOutputDirectory;
    private final File customOutputDirectory;
    private final File descriptorSetFile;
    private final boolean includeImportsInDescriptorSet;
    private final boolean includeSourceInfoInDescriptorSet;
    private final CommandLineUtils.StringStreamConsumer output;
    private final CommandLineUtils.StringStreamConsumer error;
    private final File tempDirectory;
    private final boolean useArgumentFile;
    private boolean useExperimentalOptional;

    private Protoc(String executable, List<File> protoPath, List<File> protoFiles, File javaOutputDirectory, File cppOutputDirectory, File pythonOutputDirectory, File csharpOutputDirectory, File javaScriptOutputDirectory, File customOutputDirectory, File descriptorSetFile, boolean includeImportsInDescriptorSet, boolean includeSourceInfoInDescriptorSet, List<ProtocPlugin> plugins, File pluginDirectory, String nativePluginId, String nativePluginExecutable, String nativePluginParameter, File tempDirectory, boolean useArgumentFile, boolean useExperimentalOptional) {
        if (executable == null) {
            throw new MojoConfigurationException("'executable' is null");
        }
        if (protoPath == null) {
            throw new MojoConfigurationException("'protoPath' is null");
        }
        if (protoFiles == null) {
            throw new MojoConfigurationException("'protoFiles' is null");
        }
        this.executable = executable;
        this.protoPathElements = protoPath;
        this.protoFiles = protoFiles;
        this.javaOutputDirectory = javaOutputDirectory;
        this.cppOutputDirectory = cppOutputDirectory;
        this.pythonOutputDirectory = pythonOutputDirectory;
        this.csharpOutputDirectory = csharpOutputDirectory;
        this.javaScriptOutputDirectory = javaScriptOutputDirectory;
        this.customOutputDirectory = customOutputDirectory;
        this.descriptorSetFile = descriptorSetFile;
        this.includeImportsInDescriptorSet = includeImportsInDescriptorSet;
        this.includeSourceInfoInDescriptorSet = includeSourceInfoInDescriptorSet;
        this.plugins = plugins;
        this.pluginDirectory = pluginDirectory;
        this.nativePluginId = nativePluginId;
        this.nativePluginExecutable = nativePluginExecutable;
        this.nativePluginParameter = nativePluginParameter;
        this.tempDirectory = tempDirectory;
        this.useArgumentFile = useArgumentFile;
        this.useExperimentalOptional = useExperimentalOptional;
        this.error = new CommandLineUtils.StringStreamConsumer();
        this.output = new CommandLineUtils.StringStreamConsumer();
    }

    public int execute(Log log) throws CommandLineException, InterruptedException {
        Commandline cl = new Commandline();
        ArrayList<String> args = new ArrayList<String>();
        if (this.useArgumentFile) {
            try {
                File argumentsFile = this.createFileWithArguments(this.buildProtocCommand().toArray(new String[0]));
                log.debug((CharSequence)("[PROTOC] Using arguments file " + argumentsFile.getPath()));
                args.add("@" + argumentsFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new CommandLineException("Error creating file with protoc arguments", (Throwable)e);
            }
        } else {
            args.addAll(this.buildProtocCommand());
        }
        if (Os.isFamily((String)"windows")) {
            cl.setExecutable(this.executable);
            cl.addArguments(args.toArray(new String[0]));
        } else {
            args.add(0, this.executable);
            cl.setExecutable("/bin/sh");
            cl.addArguments(new String[]{"-c", args.stream().map(arg -> "'" + arg + "'").collect(Collectors.joining(" "))});
        }
        return CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
    }

    public List<String> buildProtocCommand() {
        String outputOption;
        ArrayList<String> command = new ArrayList<String>();
        for (File file : this.protoPathElements) {
            command.add("--proto_path=" + file);
        }
        if (this.useExperimentalOptional) {
            command.add("--experimental_allow_proto3_optional");
        }
        if (this.javaOutputDirectory != null) {
            outputOption = "--java_out=";
            if (this.nativePluginParameter != null) {
                outputOption = outputOption + this.nativePluginParameter + ':';
            }
            outputOption = outputOption + this.javaOutputDirectory;
            command.add(outputOption);
            for (ProtocPlugin plugin : this.plugins) {
                File pluginExecutable = plugin.getPluginExecutableFile(this.pluginDirectory);
                command.add("--plugin=protoc-gen-" + plugin.getId() + '=' + pluginExecutable);
                command.add("--" + plugin.getId() + "_out=" + this.javaOutputDirectory);
            }
        }
        if (this.cppOutputDirectory != null) {
            command.add("--cpp_out=" + this.cppOutputDirectory);
        }
        if (this.pythonOutputDirectory != null) {
            command.add("--python_out=" + this.pythonOutputDirectory);
        }
        if (this.csharpOutputDirectory != null) {
            command.add("--csharp_out=" + this.csharpOutputDirectory);
        }
        if (this.javaScriptOutputDirectory != null) {
            outputOption = "--js_out=";
            if (this.nativePluginParameter != null) {
                outputOption = outputOption + this.nativePluginParameter + ':';
            }
            outputOption = outputOption + this.javaScriptOutputDirectory;
            command.add(outputOption);
        }
        if (this.customOutputDirectory != null) {
            if (this.nativePluginExecutable != null) {
                command.add("--plugin=protoc-gen-" + this.nativePluginId + '=' + this.nativePluginExecutable);
            }
            outputOption = "--" + this.nativePluginId + "_out=";
            if (this.nativePluginParameter != null) {
                outputOption = outputOption + this.nativePluginParameter + ':';
            }
            outputOption = outputOption + this.customOutputDirectory;
            command.add(outputOption);
        }
        for (File file : this.protoFiles) {
            command.add(file.toString());
        }
        if (this.descriptorSetFile != null) {
            command.add("--descriptor_set_out=" + this.descriptorSetFile);
            if (this.includeImportsInDescriptorSet) {
                command.add("--include_imports");
            }
            if (this.includeSourceInfoInDescriptorSet) {
                command.add("--include_source_info");
            }
        }
        return command;
    }

    public void logExecutionParameters(Log log) {
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"[PROTOC] Executable: ");
            log.debug((CharSequence)("[PROTOC]  " + this.executable));
            if (this.protoPathElements != null && !this.protoPathElements.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Protobuf import paths:");
                for (File protoPathElement : this.protoPathElements) {
                    log.debug((CharSequence)("[PROTOC]  " + protoPathElement));
                }
            }
            if (this.javaOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Java output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.javaOutputDirectory));
                if (this.plugins.size() > 0) {
                    log.debug((CharSequence)"[PROTOC] Plugins for Java output:");
                    for (ProtocPlugin plugin : this.plugins) {
                        log.debug((CharSequence)("[PROTOC]  " + plugin.getId()));
                    }
                }
            }
            if (this.pluginDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Plugin directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pluginDirectory));
            }
            if (this.cppOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] C++ output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.cppOutputDirectory));
            }
            if (this.pythonOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Python output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pythonOutputDirectory));
            }
            if (this.csharpOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] C# output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.csharpOutputDirectory));
            }
            if (this.javaScriptOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] JavaScript output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.javaScriptOutputDirectory));
            }
            if (this.descriptorSetFile != null) {
                log.debug((CharSequence)"[PROTOC] Descriptor set output file:");
                log.debug((CharSequence)("[PROTOC]  " + this.descriptorSetFile));
                log.debug((CharSequence)"[PROTOC] Include imports:");
                log.debug((CharSequence)("[PROTOC]  " + this.includeImportsInDescriptorSet));
            }
            log.debug((CharSequence)"[PROTOC] Protobuf descriptors:");
            for (File protoFile : this.protoFiles) {
                log.debug((CharSequence)("[PROTOC]  " + protoFile));
            }
            List<String> cl = this.buildProtocCommand();
            if (cl != null && !cl.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Command line options:");
                log.debug((CharSequence)(LOG_PREFIX + StringUtils.join(cl.iterator(), (String)" ")));
            }
        }
    }

    public String getOutput() {
        return Protoc.fixUnicodeOutput(this.output.getOutput());
    }

    public String getError() {
        return Protoc.fixUnicodeOutput(this.error.getOutput());
    }

    private static String fixUnicodeOutput(String message) {
        return new String(message.getBytes(), Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String ... args) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile = File.createTempFile("protoc", null, this.tempDirectory);
            tempFile.deleteOnExit();
            writer = new PrintWriter(tempFile, "UTF-8");
            for (String arg : args) {
                writer.println(arg);
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    static final class Builder {
        private final String executable;
        private final LinkedHashSet<File> protopathElements;
        private final List<File> protoFiles;
        private final List<ProtocPlugin> plugins;
        private File tempDirectory;
        private File pluginDirectory;
        private String nativePluginId;
        private String nativePluginExecutable;
        private String nativePluginParameter;
        private File javaOutputDirectory;
        private File cppOutputDirectory;
        private File pythonOutputDirectory;
        private File csharpOutputDirectory;
        private File javaScriptOutputDirectory;
        private File customOutputDirectory;
        private File descriptorSetFile;
        private boolean includeImportsInDescriptorSet;
        private boolean includeSourceInfoInDescriptorSet;
        private boolean useArgumentFile;
        private boolean useExperimentalOptional;

        Builder(String executable) {
            if (executable == null) {
                throw new MojoConfigurationException("'executable' is null");
            }
            this.executable = executable;
            this.protoFiles = new ArrayList<File>();
            this.protopathElements = new LinkedHashSet();
            this.plugins = new ArrayList<ProtocPlugin>();
        }

        public Builder setTempDirectory(File tempDirectory) {
            if (tempDirectory == null) {
                throw new MojoConfigurationException("'tempDirectory' is null");
            }
            if (!tempDirectory.isDirectory()) {
                throw new MojoConfigurationException("'tempDirectory' is not a directory: " + tempDirectory.getAbsolutePath());
            }
            this.tempDirectory = tempDirectory;
            return this;
        }

        public Builder setJavaOutputDirectory(File javaOutputDirectory) {
            if (javaOutputDirectory == null) {
                throw new MojoConfigurationException("'javaOutputDirectory' is null");
            }
            if (!javaOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'javaOutputDirectory' is not a directory: " + javaOutputDirectory.getAbsolutePath());
            }
            this.javaOutputDirectory = javaOutputDirectory;
            return this;
        }

        public Builder setCppOutputDirectory(File cppOutputDirectory) {
            if (cppOutputDirectory == null) {
                throw new MojoConfigurationException("'cppOutputDirectory' is null");
            }
            if (!cppOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'cppOutputDirectory' is not a directory: " + cppOutputDirectory.getAbsolutePath());
            }
            this.cppOutputDirectory = cppOutputDirectory;
            return this;
        }

        public Builder setPythonOutputDirectory(File pythonOutputDirectory) {
            if (pythonOutputDirectory == null) {
                throw new MojoConfigurationException("'pythonOutputDirectory' is null");
            }
            if (!pythonOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'pythonOutputDirectory' is not a directory: " + pythonOutputDirectory.getAbsolutePath());
            }
            this.pythonOutputDirectory = pythonOutputDirectory;
            return this;
        }

        public Builder setCsharpOutputDirectory(File csharpOutputDirectory) {
            if (csharpOutputDirectory == null) {
                throw new MojoConfigurationException("'csharpOutputDirectory' is null");
            }
            if (!csharpOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'csharpOutputDirectory' is not a directory: " + csharpOutputDirectory.getAbsolutePath());
            }
            this.csharpOutputDirectory = csharpOutputDirectory;
            return this;
        }

        public Builder setJavaScriptOutputDirectory(File javaScriptOutputDirectory) {
            if (javaScriptOutputDirectory == null) {
                throw new MojoConfigurationException("'javaScriptOutputDirectory' is null");
            }
            if (!javaScriptOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'javaScriptOutputDirectory' is not a directory: " + javaScriptOutputDirectory.getAbsolutePath());
            }
            this.javaScriptOutputDirectory = javaScriptOutputDirectory;
            return this;
        }

        public Builder setCustomOutputDirectory(File customOutputDirectory) {
            if (customOutputDirectory == null) {
                throw new MojoConfigurationException("'customOutputDirectory' is null");
            }
            if (!customOutputDirectory.isDirectory()) {
                throw new MojoConfigurationException("'customOutputDirectory' is not a directory: " + customOutputDirectory.getAbsolutePath());
            }
            this.customOutputDirectory = customOutputDirectory;
            return this;
        }

        public Builder addProtoFile(File protoFile) {
            if (protoFile == null) {
                throw new MojoConfigurationException("'protoFile' is null");
            }
            if (!protoFile.isFile()) {
                throw new MojoConfigurationException("Proto file is not a file: " + protoFile.getAbsolutePath());
            }
            this.checkProtoFileIsInProtopath(protoFile);
            this.protoFiles.add(protoFile);
            return this;
        }

        public Builder addPlugin(ProtocPlugin plugin) {
            if (plugin == null) {
                throw new MojoConfigurationException("'plugin' is null");
            }
            this.plugins.add(plugin);
            return this;
        }

        public Builder setPluginDirectory(File pluginDirectory) {
            if (pluginDirectory == null) {
                throw new MojoConfigurationException("'pluginDirectory' is null");
            }
            if (!pluginDirectory.isDirectory()) {
                throw new MojoConfigurationException("'pluginDirectory' is not a directory: " + pluginDirectory.getAbsolutePath());
            }
            this.pluginDirectory = pluginDirectory;
            return this;
        }

        public Builder setNativePluginId(String nativePluginId) {
            if (nativePluginId == null || nativePluginId.isEmpty()) {
                throw new MojoConfigurationException("'nativePluginId' is null or empty");
            }
            if (nativePluginId.equals("java") || nativePluginId.equals("js") || nativePluginId.equals("python") || nativePluginId.equals("csharp") || nativePluginId.equals("cpp") || nativePluginId.equals("descriptor_set")) {
                throw new MojoConfigurationException("'nativePluginId' matches one of the built-in protoc plugins: " + nativePluginId);
            }
            this.nativePluginId = nativePluginId;
            return this;
        }

        public Builder setNativePluginExecutable(String nativePluginExecutable) {
            if (nativePluginExecutable == null || nativePluginExecutable.isEmpty()) {
                throw new MojoConfigurationException("'nativePluginExecutable' is null or empty");
            }
            this.nativePluginExecutable = nativePluginExecutable;
            return this;
        }

        public Builder setNativePluginParameter(String nativePluginParameter) {
            if (nativePluginParameter == null) {
                throw new MojoConfigurationException("'nativePluginParameter' is null");
            }
            if (nativePluginParameter.contains(":")) {
                throw new MojoConfigurationException("'nativePluginParameter' contains illegal characters");
            }
            this.nativePluginParameter = nativePluginParameter;
            return this;
        }

        public Builder withDescriptorSetFile(File descriptorSetFile, boolean includeImports, boolean includeSourceInfoInDescriptorSet) {
            if (descriptorSetFile == null) {
                throw new MojoConfigurationException("'descriptorSetFile' is null");
            }
            File descriptorSetFileParent = descriptorSetFile.getParentFile();
            if (!descriptorSetFileParent.exists()) {
                throw new MojoConfigurationException("Parent directory for 'descriptorSetFile' does not exist");
            }
            if (!descriptorSetFileParent.isDirectory()) {
                throw new MojoConfigurationException("Parent for 'descriptorSetFile' is not a directory");
            }
            this.descriptorSetFile = descriptorSetFile;
            this.includeImportsInDescriptorSet = includeImports;
            this.includeSourceInfoInDescriptorSet = includeSourceInfoInDescriptorSet;
            return this;
        }

        public Builder useArgumentFile(boolean useArgumentFile) {
            this.useArgumentFile = useArgumentFile;
            return this;
        }

        public Builder useExperimentalOptional(boolean useExperimentalOptional) {
            this.useExperimentalOptional = useExperimentalOptional;
            return this;
        }

        private void checkProtoFileIsInProtopath(File protoFile) {
            if (!protoFile.isFile()) {
                throw new MojoConfigurationException("Not a regular file: " + protoFile.getAbsolutePath());
            }
            if (!this.checkProtoFileIsInProtopathHelper(protoFile.getParentFile())) {
                throw new MojoConfigurationException("File is not in proto path: " + protoFile.getAbsolutePath());
            }
        }

        private boolean checkProtoFileIsInProtopathHelper(File directory) {
            if (!directory.isDirectory()) {
                throw new MojoConfigurationException("Not a directory: " + directory.getAbsolutePath());
            }
            if (this.protopathElements.contains(directory)) {
                return true;
            }
            File parentDirectory = directory.getParentFile();
            return parentDirectory != null && this.checkProtoFileIsInProtopathHelper(parentDirectory);
        }

        public Builder addProtoFiles(Iterable<File> protoFiles) {
            for (File protoFile : protoFiles) {
                this.addProtoFile(protoFile);
            }
            return this;
        }

        public Builder addProtoPathElement(File protopathElement) {
            if (protopathElement == null) {
                throw new MojoConfigurationException("'protopathElement' is null");
            }
            if (!protopathElement.isDirectory()) {
                throw new MojoConfigurationException("Proto path element is not a directory: " + protopathElement.getAbsolutePath());
            }
            this.protopathElements.add(protopathElement);
            return this;
        }

        public Builder addProtoPathElements(Iterable<File> protopathElements) {
            for (File protopathElement : protopathElements) {
                this.addProtoPathElement(protopathElement);
            }
            return this;
        }

        private void validateState() {
            if (this.protoFiles.isEmpty()) {
                throw new MojoConfigurationException("No proto files specified");
            }
            if (this.javaOutputDirectory == null && this.cppOutputDirectory == null && this.pythonOutputDirectory == null && this.csharpOutputDirectory == null && this.javaScriptOutputDirectory == null && this.customOutputDirectory == null && this.descriptorSetFile == null) {
                throw new MojoConfigurationException("At least one of these properties must be set: 'javaOutputDirectory', 'cppOutputDirectory', 'pythonOutputDirectory', 'csharpOutputDirectory', 'javaScriptOutputDirectory', 'customOutputDirectory', or 'descriptorSetFile'");
            }
        }

        public Protoc build() {
            this.validateState();
            return new Protoc(this.executable, new ArrayList<File>(this.protopathElements), this.protoFiles, this.javaOutputDirectory, this.cppOutputDirectory, this.pythonOutputDirectory, this.csharpOutputDirectory, this.javaScriptOutputDirectory, this.customOutputDirectory, this.descriptorSetFile, this.includeImportsInDescriptorSet, this.includeSourceInfoInDescriptorSet, this.plugins, this.pluginDirectory, this.nativePluginId, this.nativePluginExecutable, this.nativePluginParameter, this.tempDirectory, this.useArgumentFile, this.useExperimentalOptional);
        }
    }
}

