/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xolstice.maven.plugin.protobuf.MojoConfigurationException;
import org.xolstice.maven.plugin.protobuf.MojoInitializationException;
import org.xolstice.maven.plugin.protobuf.Protoc;
import org.xolstice.maven.plugin.protobuf.ProtocPlugin;
import org.xolstice.maven.plugin.protobuf.ProtocPluginAssembler;

abstract class AbstractProtocMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.proto*";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected BuildContext buildContext;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Parameter(required=true, readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.directory}")
    private File tempDirectory;
    @Parameter(required=false, defaultValue="${project.build.directory}/protoc-plugins")
    private File protocPluginDirectory;
    @Parameter(required=false, property="protocExecutable")
    private String protocExecutable;
    @Parameter(required=false, property="protocArtifact")
    private String protocArtifact;
    @Parameter(required=false, property="useProtocBinaryRepository", defaultValue="true")
    private boolean useProtocBinaryRepository;
    @Parameter(required=false)
    private File[] additionalProtoPathElements = new File[0];
    @Parameter(required=true, defaultValue="${project.build.directory}/protoc-dependencies")
    private File temporaryProtoFileDirectory;
    @Parameter(required=true, defaultValue="true")
    private boolean hashDependentPaths;
    @Parameter(required=false)
    private String[] includes = new String[]{"**/*.proto*"};
    @Parameter(required=false)
    private String[] excludes = new String[0];
    @Parameter(required=true, defaultValue="true")
    protected boolean attachProtoSources;
    @Parameter(required=false, defaultValue="false")
    protected boolean useArgumentFile;
    @Parameter(required=false, defaultValue="false")
    protected boolean useExperimentalOptional;
    @Parameter(required=false)
    private List<ProtocPlugin> protocPlugins;
    @Parameter(required=false, defaultValue="0")
    private long staleMillis;
    @Parameter(required=false, defaultValue="false")
    private boolean checkStaleness;
    @Parameter(required=false, property="protoc.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=false, property="protoc.force", defaultValue="false")
    private boolean forceMojoExecution;
    @Parameter(required=false, property="protoc.clearOutputDirectory", defaultValue="false")
    private boolean clearOutputDirectory;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    AbstractProtocMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        try {
            this.checkParameters();
        }
        catch (MojoConfigurationException e) {
            throw new MojoExecutionException("Configuration error: " + e.getMessage(), (Exception)e);
        }
        catch (MojoInitializationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        File protoSourceRoot = this.getProtoSourceRoot();
        if (protoSourceRoot.exists()) {
            try {
                List<File> protoFiles = this.findProtoFilesInDirectory(protoSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                List<File> outputFiles = AbstractProtocMojo.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (protoFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No proto files to compile.");
                }
                if (!this.hasDelta(protoFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because build context has no changes.");
                    this.doAttachFiles();
                }
                if (this.checkStaleness && this.checkFilesUpToDate(protoFiles, outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.doAttachFiles();
                }
                List<File> derivedProtoPathElements = this.makeProtoPathFromJars(this.temporaryProtoFileDirectory, this.getDependencyArtifactFiles());
                FileUtils.mkdir((String)outputDirectory.getAbsolutePath());
                if (this.clearOutputDirectory) {
                    try {
                        FileUtils.cleanDirectory((File)outputDirectory);
                    }
                    catch (IOException e) {
                        throw new MojoInitializationException("Unable to clean output directory", e);
                    }
                }
                this.createProtocPlugins();
                Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("protobuf", this.session);
                if (tc != null) {
                    this.getLog().info((CharSequence)("Toolchain in protobuf-maven-plugin: " + tc));
                    if (this.protocExecutable != null) {
                        this.getLog().warn((CharSequence)("Toolchains are ignored, 'protocExecutable' parameter is set to " + this.protocExecutable));
                    } else {
                        this.protocExecutable = tc.findTool("protoc");
                    }
                }
                if (this.protocExecutable == null && this.protocArtifact != null) {
                    Artifact artifact = this.createDependencyArtifact(this.protocArtifact);
                    File file = this.resolveBinaryArtifact(artifact);
                    this.protocExecutable = file.getAbsolutePath();
                }
                if (this.protocExecutable == null) {
                    this.getLog().warn((CharSequence)"No 'protocExecutable' parameter is configured, using the default: 'protoc'");
                    this.protocExecutable = "protoc";
                }
                Protoc.Builder protocBuilder = new Protoc.Builder(this.protocExecutable).addProtoPathElement(protoSourceRoot).addProtoPathElements(derivedProtoPathElements).addProtoPathElements(Arrays.asList(this.additionalProtoPathElements)).addProtoFiles(protoFiles);
                this.addProtocBuilderParameters(protocBuilder);
                Protoc protoc = protocBuilder.build();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Proto source root:");
                    this.getLog().debug((CharSequence)(" " + protoSourceRoot));
                    if (derivedProtoPathElements != null && !derivedProtoPathElements.isEmpty()) {
                        this.getLog().debug((CharSequence)"Derived proto paths:");
                        for (File path : derivedProtoPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                    if (this.additionalProtoPathElements != null && this.additionalProtoPathElements.length > 0) {
                        this.getLog().debug((CharSequence)"Additional proto paths:");
                        for (File path : this.additionalProtoPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                }
                protoc.logExecutionParameters(this.getLog());
                this.getLog().info((CharSequence)String.format("Compiling %d proto file(s) to %s", protoFiles.size(), outputDirectory));
                int exitStatus = protoc.execute(this.getLog());
                if (StringUtils.isNotBlank((String)protoc.getOutput())) {
                    this.getLog().info((CharSequence)("PROTOC: " + protoc.getOutput()));
                }
                if (exitStatus != 0) {
                    this.getLog().error((CharSequence)("PROTOC FAILED: " + protoc.getError()));
                    for (File pf : protoFiles) {
                        this.buildContext.removeMessages(pf);
                        this.buildContext.addMessage(pf, 0, 0, protoc.getError(), 2, null);
                    }
                    throw new MojoFailureException("protoc did not exit cleanly. Review output for more information.");
                }
                if (StringUtils.isNotBlank((String)protoc.getError())) {
                    this.getLog().warn((CharSequence)("PROTOC: " + protoc.getError()));
                }
                this.doAttachFiles();
            }
            catch (MojoConfigurationException e) {
                throw new MojoExecutionException("Configuration error: " + e.getMessage(), (Exception)e);
            }
            catch (MojoInitializationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("An error occurred while invoking protoc: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (InterruptedException e) {
                this.getLog().info((CharSequence)"Process interrupted");
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", protoSourceRoot));
        }
    }

    protected void createProtocPlugins() {
        if (this.protocPlugins == null) {
            return;
        }
        String javaHome = this.detectJavaHome();
        for (ProtocPlugin plugin : this.protocPlugins) {
            if (plugin.getJavaHome() != null) {
                this.getLog().debug((CharSequence)("Using javaHome defined in plugin definition: " + plugin.getJavaHome()));
            } else {
                this.getLog().debug((CharSequence)("Setting javaHome for plugin: " + javaHome));
                plugin.setJavaHome(javaHome);
            }
            this.getLog().info((CharSequence)("Building protoc plugin: " + plugin.getId()));
            ProtocPluginAssembler assembler = new ProtocPluginAssembler(plugin, this.session, this.project.getArtifact(), this.artifactFactory, this.repositorySystem, this.resolutionErrorHandler, this.localRepository, this.remoteRepositories, this.protocPluginDirectory, this.getLog());
            assembler.execute();
        }
    }

    protected String detectJavaHome() {
        String javaHome = null;
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (tc != null) {
            if (tc instanceof DefaultJavaToolChain) {
                javaHome = ((DefaultJavaToolChain)tc).getJavaHome();
                if (javaHome != null) {
                    this.getLog().debug((CharSequence)("Using javaHome from toolchain: " + javaHome));
                }
            } else {
                File parent;
                String javaExecutable = tc.findTool("java");
                if (javaExecutable != null && (parent = new File(javaExecutable).getParentFile()) != null && (parent = parent.getParentFile()) != null && parent.isDirectory()) {
                    javaHome = parent.getAbsolutePath();
                    this.getLog().debug((CharSequence)("Using javaHome based on 'java' location returned by toolchain: " + javaHome));
                }
            }
        }
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
            this.getLog().debug((CharSequence)("Using javaHome from java.home system property: " + javaHome));
        }
        return javaHome;
    }

    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) {
        if (this.protocPlugins != null) {
            for (ProtocPlugin plugin : this.protocPlugins) {
                protocBuilder.addPlugin(plugin);
            }
            this.protocPluginDirectory.mkdirs();
            protocBuilder.setPluginDirectory(this.protocPluginDirectory);
        }
        protocBuilder.setTempDirectory(this.tempDirectory);
        protocBuilder.useArgumentFile(this.useArgumentFile);
        protocBuilder.useExperimentalOptional(this.useExperimentalOptional);
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping mojo execution");
            return true;
        }
        if (!this.forceMojoExecution && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping mojo execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected static List<File> findGeneratedFilesInDirectory(File directory) {
        List generatedFilesInDirectory;
        if (directory == null || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        try {
            generatedFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*", (String)FileUtils.getDefaultExcludesAsString());
        }
        catch (IOException e) {
            throw new MojoInitializationException("Unable to scan output directory", e);
        }
        return generatedFilesInDirectory;
    }

    protected static long lastModified(Iterable<File> files) {
        long result = 0L;
        for (File file : files) {
            result = Math.max(result, file.lastModified());
        }
        return result;
    }

    protected boolean checkFilesUpToDate(Iterable<File> sourceFiles, Iterable<File> targetFiles) {
        return AbstractProtocMojo.lastModified(sourceFiles) + this.staleMillis < AbstractProtocMojo.lastModified(targetFiles);
    }

    protected boolean hasDelta(Iterable<File> files) {
        for (File file : files) {
            if (!this.buildContext.hasDelta(file)) continue;
            return true;
        }
        return false;
    }

    protected void checkParameters() {
        if (this.project == null) {
            throw new MojoConfigurationException("'project' is null");
        }
        if (this.projectHelper == null) {
            throw new MojoConfigurationException("'projectHelper' is null");
        }
        File protoSourceRoot = this.getProtoSourceRoot();
        if (protoSourceRoot == null) {
            throw new MojoConfigurationException("'protoSourceRoot' is null");
        }
        if (protoSourceRoot.isFile()) {
            throw new MojoConfigurationException("'protoSourceRoot' is a file, not a directory");
        }
        if (this.temporaryProtoFileDirectory == null) {
            throw new MojoConfigurationException("'temporaryProtoFileDirectory' is null");
        }
        if (this.temporaryProtoFileDirectory.isFile()) {
            throw new MojoConfigurationException("'temporaryProtoFileDirectory' is a file, not a directory");
        }
        File outputDirectory = this.getOutputDirectory();
        if (outputDirectory == null) {
            throw new MojoConfigurationException("'outputDirectory' is null");
        }
        if (outputDirectory.isFile()) {
            throw new MojoConfigurationException("'outputDirectory' is a file, not a directory");
        }
    }

    protected abstract File getProtoSourceRoot();

    protected String[] getIncludes() {
        return this.includes;
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected void doAttachFiles() {
        if (this.attachProtoSources) {
            this.doAttachProtoSources();
        }
        this.doAttachGeneratedFiles();
    }

    protected abstract void doAttachProtoSources();

    protected abstract void doAttachGeneratedFiles();

    protected List<File> getDependencyArtifactFiles() {
        List<Artifact> dependencyArtifacts = this.getDependencyArtifacts();
        if (dependencyArtifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> dependencyArtifactFiles = new ArrayList<File>(dependencyArtifacts.size());
        for (Artifact artifact : dependencyArtifacts) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return dependencyArtifactFiles;
    }

    protected List<File> makeProtoPathFromJars(File temporaryProtoFileDirectory, Iterable<File> classpathElementFiles) {
        if (classpathElementFiles == null) {
            throw new MojoConfigurationException("'classpathElementFiles' is null");
        }
        if (!classpathElementFiles.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (temporaryProtoFileDirectory.exists()) {
            try {
                FileUtils.cleanDirectory((File)temporaryProtoFileDirectory);
            }
            catch (IOException e) {
                throw new MojoInitializationException("Unable to clean up temporary proto file directory", e);
            }
        }
        ArrayList<File> protoDirectories = new ArrayList<File>();
        for (File classpathElementFile : classpathElementFiles) {
            List protoFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                try {
                    JarFile classpathJar = new JarFile(classpathElementFile);
                    try {
                        Enumeration<JarEntry> jarEntries = classpathJar.entries();
                        while (jarEntries.hasMoreElements()) {
                            File jarDirectory;
                            JarEntry jarEntry = jarEntries.nextElement();
                            String jarEntryName = jarEntry.getName();
                            if (jarEntry.isDirectory() || !SelectorUtils.matchPath((String)DEFAULT_INCLUDES, (String)jarEntryName, (String)"/", (boolean)true)) continue;
                            try {
                                jarDirectory = new File(temporaryProtoFileDirectory, this.truncatePath(classpathJar.getName()));
                                String canonicalJarDirectoryPath = jarDirectory.getCanonicalPath();
                                File uncompressedCopy = new File(jarDirectory, jarEntryName);
                                String canonicalUncompressedCopyPath = uncompressedCopy.getCanonicalPath();
                                if (!canonicalUncompressedCopyPath.startsWith(canonicalJarDirectoryPath + File.separator)) {
                                    throw new MojoInitializationException("ZIP SLIP: Entry " + jarEntry.getName() + " in " + classpathJar.getName() + " is outside of the target dir");
                                }
                                FileUtils.mkdir((String)uncompressedCopy.getParentFile().getAbsolutePath());
                                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                            }
                            catch (IOException e) {
                                throw new MojoInitializationException("Unable to unpack proto files", e);
                            }
                            protoDirectories.add(jarDirectory);
                        }
                        continue;
                    }
                    finally {
                        classpathJar.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new MojoInitializationException("Not a readable JAR artifact: " + classpathElementFile.getAbsolutePath(), e);
                }
            }
            if (!classpathElementFile.isDirectory()) continue;
            try {
                protoFiles = FileUtils.getFileNames((File)classpathElementFile, (String)DEFAULT_INCLUDES, null, (boolean)true);
            }
            catch (IOException e) {
                throw new MojoInitializationException("Unable to scan for proto files in: " + classpathElementFile.getAbsolutePath(), e);
            }
            if (protoFiles.isEmpty()) continue;
            protoDirectories.add(classpathElementFile);
        }
        return protoDirectories;
    }

    protected List<File> findProtoFilesInDirectory(File directory) {
        List protoFilesInDirectory;
        if (directory == null) {
            throw new MojoConfigurationException("'directory' is null");
        }
        if (!directory.isDirectory()) {
            throw new MojoConfigurationException(String.format("%s is not a directory", directory));
        }
        try {
            String includes = StringUtils.join((Object[])this.getIncludes(), (String)",");
            String excludes = StringUtils.join((Object[])this.getExcludes(), (String)",");
            protoFilesInDirectory = FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
        }
        catch (IOException e) {
            throw new MojoInitializationException("Unable to retrieve the list of files: " + e.getMessage(), e);
        }
        return protoFilesInDirectory;
    }

    protected List<File> findProtoFilesInDirectories(Iterable<File> directories) {
        if (directories == null) {
            throw new MojoConfigurationException("'directories' is null");
        }
        ArrayList<File> protoFiles = new ArrayList<File>();
        for (File directory : directories) {
            protoFiles.addAll(this.findProtoFilesInDirectory(directory));
        }
        return protoFiles;
    }

    protected String truncatePath(String jarPath) {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            return AbstractProtocMojo.md5Hash(jarPath);
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    private static String md5Hash(String string) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoInitializationException("Unable to create MD5 digest", e);
        }
        byte[] input = string.getBytes(Charset.forName("UTF-8"));
        return AbstractProtocMojo.toHexString(digest.digest(input));
    }

    protected static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }

    protected File resolveBinaryArtifact(Artifact artifact) {
        File copyTempFile;
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setResolveTransitively(false).setArtifactDependencies(Collections.singleton(artifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoInitializationException("Unable to resolve artifact: " + e.getMessage(), e);
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new MojoInitializationException("Unable to resolve artifact");
        }
        Artifact resolvedBinaryArtifact = (Artifact)artifacts.iterator().next();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved artifact: " + resolvedBinaryArtifact));
        }
        File sourceFile = resolvedBinaryArtifact.getFile();
        String sourceFileName = sourceFile.getName();
        String targetFileName = Os.isFamily((String)"windows") && !sourceFileName.endsWith(".exe") ? sourceFileName + ".exe" : sourceFileName;
        File repositoryDirectory = this.protocPluginDirectory;
        if (this.useProtocBinaryRepository) {
            File repoBaseDir;
            MavenProject p = this.project;
            while (true) {
                repoBaseDir = p.getBasedir();
                if (!p.hasParent()) break;
                p = p.getParent();
            }
            repositoryDirectory = new File(repoBaseDir, ".mvn/protobuf-binaries");
            this.getLog().info((CharSequence)("Using shared repository for protobuf binaries: " + repositoryDirectory));
        } else {
            this.getLog().warn((CharSequence)"Consider setting 'useProtocBinaryRepository' to 'true' to avoid sporadic build failures on Linux.");
        }
        File targetFile = new File(repositoryDirectory, targetFileName);
        if (targetFile.exists()) {
            this.getLog().debug((CharSequence)("Executable file already exists: " + targetFile.getAbsolutePath()));
            return targetFile;
        }
        try {
            FileUtils.forceMkdir((File)repositoryDirectory);
        }
        catch (IOException e) {
            throw new MojoInitializationException("Unable to create directory " + repositoryDirectory, e);
        }
        try {
            copyTempFile = File.createTempFile("protoc", ".tmp", repositoryDirectory);
        }
        catch (IOException e) {
            throw new MojoInitializationException("Unable to copy the protoc binary to " + repositoryDirectory, e);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)copyTempFile);
        }
        catch (IOException e) {
            throw new MojoInitializationException("Unable to copy the protoc binary to " + repositoryDirectory, e);
        }
        if (!Os.isFamily((String)"windows")) {
            copyTempFile.setExecutable(true);
        }
        if (!targetFile.exists()) {
            copyTempFile.renameTo(targetFile);
        }
        copyTempFile.delete();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executable file: " + targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    protected Artifact createDependencyArtifact(String artifactSpec) {
        String[] parts = artifactSpec.split(":");
        if (parts.length < 3 || parts.length > 5) {
            throw new MojoConfigurationException("Invalid artifact specification format, expected: groupId:artifactId:version[:type[:classifier]], actual: " + artifactSpec);
        }
        String type = parts.length >= 4 ? parts[3] : "exe";
        String classifier = parts.length == 5 ? parts[4] : null;
        return this.createDependencyArtifact(parts[0], parts[1], parts[2], type, classifier);
    }

    protected Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        VersionRange versionSpec;
        try {
            versionSpec = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoConfigurationException("Invalid version specification", e);
        }
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionSpec, type, classifier, "runtime");
    }
}

