// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_dnn.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

public class opencv_dnn extends org.bytedeco.opencv.presets.opencv_dnn {
    static { Loader.load(); }

// Targeting ../opencv_dnn/MatShapeVector.java


// Targeting ../opencv_dnn/MatShapeVectorVector.java


// Targeting ../opencv_dnn/RangeVectorVector.java


// Targeting ../opencv_dnn/MatPointerVector.java


// Targeting ../opencv_dnn/IntFloatPair.java


// Parsed from <opencv2/dnn.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_DNN_HPP
// #define OPENCV_DNN_HPP

// This is an umbrella header to include into you project.
// We are free to change headers layout in dnn subfolder, so please include
// this header for future compatibility


/** \defgroup dnn Deep Neural Network module
  \{
    This module contains:
        - API for new layers creation, layers are building bricks of neural networks;
        - set of built-in most-useful Layers;
        - API to construct and modify comprehensive neural networks from layers;
        - functionality for loading serialized networks models from different frameworks.
    <p>
    Functionality of this module is designed only for forward pass computations (i.e. network testing).
    A network training is in principle not supported.
  \}
*/
/** \example samples/dnn/classification.cpp
Check \ref tutorial_dnn_googlenet "the corresponding tutorial" for more details
*/
/** \example samples/dnn/colorization.cpp
*/
/** \example samples/dnn/object_detection.cpp
Check \ref tutorial_dnn_yolo "the corresponding tutorial" for more details
*/
/** \example samples/dnn/openpose.cpp
*/
/** \example samples/dnn/segmentation.cpp
*/
/** \example samples/dnn/text_detection.cpp
*/
// #include <opencv2/dnn/dnn.hpp>

// #endif /* OPENCV_DNN_HPP */


// Parsed from <opencv2/dnn/version.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef OPENCV_DNN_VERSION_HPP
// #define OPENCV_DNN_VERSION_HPP

/** Use with major OpenCV version only. */
public static final int OPENCV_DNN_API_VERSION = 20210608;

// #if !defined CV_DOXYGEN && !defined CV_STATIC_ANALYSIS && !defined CV_DNN_DONT_ADD_INLINE_NS
// #define CV__DNN_INLINE_NS __CV_CAT(dnn4_v, OPENCV_DNN_API_VERSION)
// #define CV__DNN_INLINE_NS_BEGIN namespace CV__DNN_INLINE_NS {
// #define CV__DNN_INLINE_NS_END }
 
// #else
// #define CV__DNN_INLINE_NS_BEGIN
// #define CV__DNN_INLINE_NS_END
// #endif

// #endif  // OPENCV_DNN_VERSION_HPP


// Parsed from <opencv2/dnn/dict.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #include <opencv2/core.hpp>
// #include <map>
// #include <ostream>

// #include <opencv2/dnn/dnn.hpp>

// #ifndef OPENCV_DNN_DNN_DICT_HPP
// #define OPENCV_DNN_DNN_DICT_HPP
// Targeting ../opencv_dnn/DictValue.java


// Targeting ../opencv_dnn/Dict.java



/** \} */



// #endif


// Parsed from <opencv2/dnn/all_layers.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_DNN_DNN_ALL_LAYERS_HPP
// #define OPENCV_DNN_DNN_ALL_LAYERS_HPP
// #include <opencv2/dnn.hpp>
// Targeting ../opencv_dnn/BlankLayer.java


// Targeting ../opencv_dnn/ConstLayer.java


// Targeting ../opencv_dnn/LSTMLayer.java


// Targeting ../opencv_dnn/RNNLayer.java


// Targeting ../opencv_dnn/BaseConvolutionLayer.java


// Targeting ../opencv_dnn/ConvolutionLayer.java


// Targeting ../opencv_dnn/DeconvolutionLayer.java


// Targeting ../opencv_dnn/LRNLayer.java


// Targeting ../opencv_dnn/PoolingLayer.java


// Targeting ../opencv_dnn/SoftmaxLayer.java


// Targeting ../opencv_dnn/InnerProductLayer.java


// Targeting ../opencv_dnn/MVNLayer.java


// Targeting ../opencv_dnn/ReshapeLayer.java


// Targeting ../opencv_dnn/FlattenLayer.java


// Targeting ../opencv_dnn/ConcatLayer.java


// Targeting ../opencv_dnn/SplitLayer.java


// Targeting ../opencv_dnn/SliceLayer.java


// Targeting ../opencv_dnn/PermuteLayer.java


// Targeting ../opencv_dnn/ShuffleChannelLayer.java


// Targeting ../opencv_dnn/PaddingLayer.java


// Targeting ../opencv_dnn/ActivationLayer.java


// Targeting ../opencv_dnn/ReLULayer.java


// Targeting ../opencv_dnn/ReLU6Layer.java


// Targeting ../opencv_dnn/ChannelsPReLULayer.java


// Targeting ../opencv_dnn/ELULayer.java


// Targeting ../opencv_dnn/TanHLayer.java


// Targeting ../opencv_dnn/SwishLayer.java


// Targeting ../opencv_dnn/MishLayer.java


// Targeting ../opencv_dnn/SigmoidLayer.java


// Targeting ../opencv_dnn/BNLLLayer.java


// Targeting ../opencv_dnn/AbsLayer.java


// Targeting ../opencv_dnn/PowerLayer.java


// Targeting ../opencv_dnn/ExpLayer.java


// Targeting ../opencv_dnn/CropLayer.java


// Targeting ../opencv_dnn/EltwiseLayer.java


// Targeting ../opencv_dnn/BatchNormLayer.java


// Targeting ../opencv_dnn/MaxUnpoolLayer.java


// Targeting ../opencv_dnn/ScaleLayer.java


// Targeting ../opencv_dnn/ShiftLayer.java


// Targeting ../opencv_dnn/DataAugmentationLayer.java


// Targeting ../opencv_dnn/CorrelationLayer.java


// Targeting ../opencv_dnn/AccumLayer.java


// Targeting ../opencv_dnn/FlowWarpLayer.java


// Targeting ../opencv_dnn/PriorBoxLayer.java


// Targeting ../opencv_dnn/ReorgLayer.java


// Targeting ../opencv_dnn/RegionLayer.java


// Targeting ../opencv_dnn/DetectionOutputLayer.java


// Targeting ../opencv_dnn/NormalizeBBoxLayer.java


// Targeting ../opencv_dnn/ResizeLayer.java


// Targeting ../opencv_dnn/InterpLayer.java


// Targeting ../opencv_dnn/ProposalLayer.java


// Targeting ../opencv_dnn/CropAndResizeLayer.java



/** \}
 *  \} */


// #endif


// Parsed from <opencv2/dnn/dnn.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_DNN_DNN_HPP
// #define OPENCV_DNN_DNN_HPP

// #include <vector>
// #include <opencv2/core.hpp>
// #include "opencv2/core/async.hpp"

// #include "../dnn/version.hpp"

// #include <opencv2/dnn/dict.hpp>
/** \addtogroup dnn
 *  \{ */

    /**
     * \brief Enum of computation backends supported by layers.
     * @see Net::setPreferableBackend
     */
    /** enum cv::dnn::Backend */
    public static final int
        /** DNN_BACKEND_DEFAULT equals to DNN_BACKEND_INFERENCE_ENGINE if
         *  OpenCV is built with Intel's Inference Engine library or
         *  DNN_BACKEND_OPENCV otherwise. */
        DNN_BACKEND_DEFAULT = 0,
        DNN_BACKEND_HALIDE = 1,
        /** Intel's Inference Engine computational backend
 *  @see setInferenceEngineBackendType */
        DNN_BACKEND_INFERENCE_ENGINE = 2,
        DNN_BACKEND_OPENCV = 3,
        DNN_BACKEND_VKCOM = 4,
        DNN_BACKEND_CUDA = 5;
// #ifdef __OPENCV_BUILD
// #endif

    /**
     * \brief Enum of target devices for computations.
     * @see Net::setPreferableTarget
     */
    /** enum cv::dnn::Target */
    public static final int
        DNN_TARGET_CPU = 0,
        DNN_TARGET_OPENCL = 1,
        DNN_TARGET_OPENCL_FP16 = 2,
        DNN_TARGET_MYRIAD = 3,
        DNN_TARGET_VULKAN = 4,
        /** FPGA device with CPU fallbacks using Inference Engine's Heterogeneous plugin. */
        DNN_TARGET_FPGA = 5,
        DNN_TARGET_CUDA = 6,
        DNN_TARGET_CUDA_FP16 = 7,
        DNN_TARGET_HDDL = 8;

    @Namespace("cv::dnn") public static native @ByVal @Cast("std::vector<std::pair<cv::dnn::Backend,cv::dnn::Target> >*") IntIntPairVector getAvailableBackends();
    @Namespace("cv::dnn") public static native @Cast("cv::dnn::Target*") @StdVector IntPointer getAvailableTargets(@Cast("cv::dnn::Backend") int be);

    /**
     * \brief Enables detailed logging of the DNN model loading with CV DNN API.
     * @param isDiagnosticsMode [in] Indicates whether diagnostic mode should be set.
     *
     * Diagnostic mode provides detailed logging of the model loading stage to explore
     * potential problems (ex.: not implemented layer type).
     *
     * \note In diagnostic mode series of assertions will be skipped, it can lead to the
     * expected application crash.
     */
    @Namespace("cv::dnn") public static native void enableModelDiagnostics(@Cast("bool") boolean isDiagnosticsMode);
// Targeting ../opencv_dnn/LayerParams.java


// Targeting ../opencv_dnn/BackendNode.java


// Targeting ../opencv_dnn/BackendWrapper.java


// Targeting ../opencv_dnn/Layer.java


// Targeting ../opencv_dnn/Net.java



    /** \brief Reads a network model stored in <a href="https://pjreddie.com/darknet/">Darknet</a> model files.
    *  @param cfgFile      path to the .cfg file with text description of the network architecture.
    *  @param darknetModel path to the .weights file with learned network.
    *  @return Network object that ready to do forward, throw an exception in failure cases.
    *  @return Net object.
    */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Str BytePointer cfgFile, @Str BytePointer darknetModel/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Str BytePointer cfgFile);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Str String cfgFile, @Str String darknetModel/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Str String cfgFile);

    /** \brief Reads a network model stored in <a href="https://pjreddie.com/darknet/">Darknet</a> model files.
     *  @param bufferCfg   A buffer contains a content of .cfg file with text description of the network architecture.
     *  @param bufferModel A buffer contains a content of .weights file with learned network.
     *  @return Net object.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("uchar*") @StdVector ByteBuffer bufferCfg,
                                            @Cast("uchar*") @StdVector ByteBuffer bufferModel/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("uchar*") @StdVector ByteBuffer bufferCfg);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("uchar*") @StdVector byte[] bufferCfg,
                                            @Cast("uchar*") @StdVector byte[] bufferModel/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("uchar*") @StdVector byte[] bufferCfg);

    /** \brief Reads a network model stored in <a href="https://pjreddie.com/darknet/">Darknet</a> model files.
     *  @param bufferCfg   A buffer contains a content of .cfg file with text description of the network architecture.
     *  @param lenCfg      Number of bytes to read from bufferCfg
     *  @param bufferModel A buffer contains a content of .weights file with learned network.
     *  @param lenModel    Number of bytes to read from bufferModel
     *  @return Net object.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("const char*") BytePointer bufferCfg, @Cast("size_t") long lenCfg,
                                          @Cast("const char*") BytePointer bufferModel/*=NULL*/, @Cast("size_t") long lenModel/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(@Cast("const char*") BytePointer bufferCfg, @Cast("size_t") long lenCfg);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(String bufferCfg, @Cast("size_t") long lenCfg,
                                          String bufferModel/*=NULL*/, @Cast("size_t") long lenModel/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromDarknet(String bufferCfg, @Cast("size_t") long lenCfg);

    /** \brief Reads a network model stored in <a href="http://caffe.berkeleyvision.org">Caffe</a> framework's format.
      * @param prototxt   path to the .prototxt file with text description of the network architecture.
      * @param caffeModel path to the .caffemodel file with learned network.
      * @return Net object.
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Str BytePointer prototxt, @Str BytePointer caffeModel/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Str BytePointer prototxt);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Str String prototxt, @Str String caffeModel/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Str String prototxt);

    /** \brief Reads a network model stored in Caffe model in memory.
      * @param bufferProto buffer containing the content of the .prototxt file
      * @param bufferModel buffer containing the content of the .caffemodel file
      * @return Net object.
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("uchar*") @StdVector ByteBuffer bufferProto,
                                          @Cast("uchar*") @StdVector ByteBuffer bufferModel/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("uchar*") @StdVector ByteBuffer bufferProto);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("uchar*") @StdVector byte[] bufferProto,
                                          @Cast("uchar*") @StdVector byte[] bufferModel/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("uchar*") @StdVector byte[] bufferProto);

    /** \brief Reads a network model stored in Caffe model in memory.
      * \details This is an overloaded member function, provided for convenience.
      * It differs from the above function only in what argument(s) it accepts.
      * @param bufferProto buffer containing the content of the .prototxt file
      * @param lenProto length of bufferProto
      * @param bufferModel buffer containing the content of the .caffemodel file
      * @param lenModel length of bufferModel
      * @return Net object.
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("const char*") BytePointer bufferProto, @Cast("size_t") long lenProto,
                                        @Cast("const char*") BytePointer bufferModel/*=NULL*/, @Cast("size_t") long lenModel/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(@Cast("const char*") BytePointer bufferProto, @Cast("size_t") long lenProto);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(String bufferProto, @Cast("size_t") long lenProto,
                                        String bufferModel/*=NULL*/, @Cast("size_t") long lenModel/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromCaffe(String bufferProto, @Cast("size_t") long lenProto);

    /** \brief Reads a network model stored in <a href="https://www.tensorflow.org/">TensorFlow</a> framework's format.
      * @param model  path to the .pb file with binary protobuf description of the network architecture
      * @param config path to the .pbtxt file that contains text graph definition in protobuf format.
      *               Resulting Net object is built by text graph using weights from a binary one that
      *               let us make it more flexible.
      * @return Net object.
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Str BytePointer model, @Str BytePointer config/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Str BytePointer model);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Str String model, @Str String config/*=cv::String()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Str String model);

    /** \brief Reads a network model stored in <a href="https://www.tensorflow.org/">TensorFlow</a> framework's format.
      * @param bufferModel buffer containing the content of the pb file
      * @param bufferConfig buffer containing the content of the pbtxt file
      * @return Net object.
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("uchar*") @StdVector ByteBuffer bufferModel,
                                               @Cast("uchar*") @StdVector ByteBuffer bufferConfig/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("uchar*") @StdVector ByteBuffer bufferModel);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("uchar*") @StdVector byte[] bufferModel,
                                               @Cast("uchar*") @StdVector byte[] bufferConfig/*=std::vector<uchar>()*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("uchar*") @StdVector byte[] bufferModel);

    /** \brief Reads a network model stored in <a href="https://www.tensorflow.org/">TensorFlow</a> framework's format.
      * \details This is an overloaded member function, provided for convenience.
      * It differs from the above function only in what argument(s) it accepts.
      * @param bufferModel buffer containing the content of the pb file
      * @param lenModel length of bufferModel
      * @param bufferConfig buffer containing the content of the pbtxt file
      * @param lenConfig length of bufferConfig
      */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("const char*") BytePointer bufferModel, @Cast("size_t") long lenModel,
                                             @Cast("const char*") BytePointer bufferConfig/*=NULL*/, @Cast("size_t") long lenConfig/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(@Cast("const char*") BytePointer bufferModel, @Cast("size_t") long lenModel);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(String bufferModel, @Cast("size_t") long lenModel,
                                             String bufferConfig/*=NULL*/, @Cast("size_t") long lenConfig/*=0*/);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromTensorflow(String bufferModel, @Cast("size_t") long lenModel);

    /**
     *  \brief Reads a network model stored in <a href="http://torch.ch">Torch7</a> framework's format.
     *  @param model    path to the file, dumped from Torch by using torch.save() function.
     *  @param isBinary specifies whether the network was serialized in ascii mode or binary.
     *  @param evaluate specifies testing phase of network. If true, it's similar to evaluate() method in Torch.
     *  @return Net object.
     *
     *  \note Ascii mode of Torch serializer is more preferable, because binary mode extensively use {@code long} type of C language,
     *  which has various bit-length on different systems.
     *
     * The loading file must contain serialized <a href="https://github.com/torch/nn/blob/master/doc/module.md">nn.Module</a> object
     * with importing network. Try to eliminate a custom objects from serialazing data to avoid importing errors.
     *
     * List of supported layers (i.e. object instances derived from Torch nn.Module class):
     * - nn.Sequential
     * - nn.Parallel
     * - nn.Concat
     * - nn.Linear
     * - nn.SpatialConvolution
     * - nn.SpatialMaxPooling, nn.SpatialAveragePooling
     * - nn.ReLU, nn.TanH, nn.Sigmoid
     * - nn.Reshape
     * - nn.SoftMax, nn.LogSoftMax
     *
     * Also some equivalents of these classes from cunn, cudnn, and fbcunn may be successfully imported.
     */
     @Namespace("cv::dnn") public static native @ByVal Net readNetFromTorch(@Str BytePointer model, @Cast("bool") boolean isBinary/*=true*/, @Cast("bool") boolean evaluate/*=true*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNetFromTorch(@Str BytePointer model);
     @Namespace("cv::dnn") public static native @ByVal Net readNetFromTorch(@Str String model, @Cast("bool") boolean isBinary/*=true*/, @Cast("bool") boolean evaluate/*=true*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNetFromTorch(@Str String model);

     /**
      * \brief Read deep learning network represented in one of the supported formats.
      * @param model [in] Binary file contains trained weights. The following file
      *                  extensions are expected for models from different frameworks:
      *                  * {@code *.caffemodel} (Caffe, http://caffe.berkeleyvision.org/)
      *                  * {@code *.pb} (TensorFlow, https://www.tensorflow.org/)
      *                  * {@code *.t7} | {@code *.net} (Torch, http://torch.ch/)
      *                  * {@code *.weights} (Darknet, https://pjreddie.com/darknet/)
      *                  * {@code *.bin} (DLDT, https://software.intel.com/openvino-toolkit)
      *                  * {@code *.onnx} (ONNX, https://onnx.ai/)
      * @param config [in] Text file contains network configuration. It could be a
      *                   file with the following extensions:
      *                  * {@code *.prototxt} (Caffe, http://caffe.berkeleyvision.org/)
      *                  * {@code *.pbtxt} (TensorFlow, https://www.tensorflow.org/)
      *                  * {@code *.cfg} (Darknet, https://pjreddie.com/darknet/)
      *                  * {@code *.xml} (DLDT, https://software.intel.com/openvino-toolkit)
      * @param framework [in] Explicit framework name tag to determine a format.
      * @return Net object.
      *
      * This function automatically detects an origin framework of trained model
      * and calls an appropriate function such \ref readNetFromCaffe, \ref readNetFromTensorflow,
      * \ref readNetFromTorch or \ref readNetFromDarknet. An order of \p model and \p config
      * arguments does not matter.
      */
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer model, @Str BytePointer config/*=""*/, @Str BytePointer framework/*=""*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer model);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String model, @Str String config/*=""*/, @Str String framework/*=""*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String model);

     /**
      * \brief Read deep learning network represented in one of the supported formats.
      * \details This is an overloaded member function, provided for convenience.
      *          It differs from the above function only in what argument(s) it accepts.
      * @param framework [in]    Name of origin framework.
      * @param bufferModel [in]  A buffer with a content of binary file with weights
      * @param bufferConfig [in] A buffer with a content of text file contains network configuration.
      * @return Net object.
      */
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer framework, @Cast("uchar*") @StdVector BytePointer bufferModel);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector ByteBuffer bufferModel,
                                   @Cast("uchar*") @StdVector ByteBuffer bufferConfig/*=std::vector<uchar>()*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector ByteBuffer bufferModel);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer framework, @Cast("uchar*") @StdVector byte[] bufferModel,
                                   @Cast("uchar*") @StdVector byte[] bufferConfig/*=std::vector<uchar>()*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer framework, @Cast("uchar*") @StdVector byte[] bufferModel);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector BytePointer bufferModel,
                                   @Cast("uchar*") @StdVector BytePointer bufferConfig/*=std::vector<uchar>()*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector BytePointer bufferModel);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer framework, @Cast("uchar*") @StdVector ByteBuffer bufferModel,
                                   @Cast("uchar*") @StdVector ByteBuffer bufferConfig/*=std::vector<uchar>()*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str BytePointer framework, @Cast("uchar*") @StdVector ByteBuffer bufferModel);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector byte[] bufferModel,
                                   @Cast("uchar*") @StdVector byte[] bufferConfig/*=std::vector<uchar>()*/);
     @Namespace("cv::dnn") public static native @ByVal Net readNet(@Str String framework, @Cast("uchar*") @StdVector byte[] bufferModel);

    /** \brief Loads blob which was serialized as torch.Tensor object of Torch7 framework.
     *  \warning This function has the same limitations as readNetFromTorch().
     */
    @Namespace("cv::dnn") public static native @ByVal Mat readTorchBlob(@Str BytePointer filename, @Cast("bool") boolean isBinary/*=true*/);
    @Namespace("cv::dnn") public static native @ByVal Mat readTorchBlob(@Str BytePointer filename);
    @Namespace("cv::dnn") public static native @ByVal Mat readTorchBlob(@Str String filename, @Cast("bool") boolean isBinary/*=true*/);
    @Namespace("cv::dnn") public static native @ByVal Mat readTorchBlob(@Str String filename);

    /** \brief Load a network from Intel's Model Optimizer intermediate representation.
     *  @param xml [in] XML configuration file with network's topology.
     *  @param bin [in] Binary file with trained weights.
     *  @return Net object.
     *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine
     *  backend.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Str BytePointer xml, @Str BytePointer bin);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Str String xml, @Str String bin);

    /** \brief Load a network from Intel's Model Optimizer intermediate representation.
     *  @param bufferModelConfig [in] Buffer contains XML configuration with network's topology.
     *  @param bufferWeights [in] Buffer contains binary data with trained weights.
     *  @return Net object.
     *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine
     *  backend.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Cast("uchar*") @StdVector ByteBuffer bufferModelConfig, @Cast("uchar*") @StdVector ByteBuffer bufferWeights);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Cast("uchar*") @StdVector byte[] bufferModelConfig, @Cast("uchar*") @StdVector byte[] bufferWeights);

    /** \brief Load a network from Intel's Model Optimizer intermediate representation.
     *  @param bufferModelConfigPtr [in] Pointer to buffer which contains XML configuration with network's topology.
     *  @param bufferModelConfigSize [in] Binary size of XML configuration data.
     *  @param bufferWeightsPtr [in] Pointer to buffer which contains binary data with trained weights.
     *  @param bufferWeightsSize [in] Binary size of trained weights data.
     *  @return Net object.
     *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine
     *  backend.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Cast("const uchar*") BytePointer bufferModelConfigPtr, @Cast("size_t") long bufferModelConfigSize,
                                               @Cast("const uchar*") BytePointer bufferWeightsPtr, @Cast("size_t") long bufferWeightsSize);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Cast("const uchar*") ByteBuffer bufferModelConfigPtr, @Cast("size_t") long bufferModelConfigSize,
                                               @Cast("const uchar*") ByteBuffer bufferWeightsPtr, @Cast("size_t") long bufferWeightsSize);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromModelOptimizer(@Cast("const uchar*") byte[] bufferModelConfigPtr, @Cast("size_t") long bufferModelConfigSize,
                                               @Cast("const uchar*") byte[] bufferWeightsPtr, @Cast("size_t") long bufferWeightsSize);

    /** \brief Reads a network model <a href="https://onnx.ai/">ONNX</a>.
     *  @param onnxFile path to the .onnx file with text description of the network architecture.
     *  @return Network object that ready to do forward, throw an exception in failure cases.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(@Str BytePointer onnxFile);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(@Str String onnxFile);

    /** \brief Reads a network model from <a href="https://onnx.ai/">ONNX</a>
     *         in-memory buffer.
     *  @param buffer memory address of the first byte of the buffer.
     *  @param sizeBuffer size of the buffer.
     *  @return Network object that ready to do forward, throw an exception
     *        in failure cases.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(@Cast("const char*") BytePointer buffer, @Cast("size_t") long sizeBuffer);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(String buffer, @Cast("size_t") long sizeBuffer);

    /** \brief Reads a network model from <a href="https://onnx.ai/">ONNX</a>
     *         in-memory buffer.
     *  @param buffer in-memory buffer that stores the ONNX model bytes.
     *  @return Network object that ready to do forward, throw an exception
     *        in failure cases.
     */
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(@Cast("uchar*") @StdVector ByteBuffer buffer);
    @Namespace("cv::dnn") public static native @ByVal Net readNetFromONNX(@Cast("uchar*") @StdVector byte[] buffer);

    /** \brief Creates blob from .pb file.
     *  @param path to the .pb file with input tensor.
     *  @return Mat.
     */
    @Namespace("cv::dnn") public static native @ByVal Mat readTensorFromONNX(@Str BytePointer path);
    @Namespace("cv::dnn") public static native @ByVal Mat readTensorFromONNX(@Str String path);

    /** \brief Creates 4-dimensional blob from image. Optionally resizes and crops \p image from center,
     *  subtract \p mean values, scales values by \p scalefactor, swap Blue and Red channels.
     *  @param image input image (with 1-, 3- or 4-channels).
     *  @param size spatial size for output image
     *  @param mean scalar with mean values which are subtracted from channels. Values are intended
     *  to be in (mean-R, mean-G, mean-B) order if \p image has BGR ordering and \p swapRB is true.
     *  @param scalefactor multiplier for \p image values.
     *  @param swapRB flag which indicates that swap first and last channels
     *  in 3-channel image is necessary.
     *  @param crop flag which indicates whether image will be cropped after resize or not
     *  @param ddepth Depth of output blob. Choose CV_32F or CV_8U.
     *  \details if \p crop is true, input image is resized so one side after resize is equal to corresponding
     *  dimension in \p size and another one is equal or larger. Then, crop from the center is performed.
     *  If \p crop is false, direct resize without cropping and preserving aspect ratio is performed.
     *  @return 4-dimensional Mat with NCHW dimensions order.
     */
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal Mat image, double scalefactor/*=1.0*/, @Const @ByRef(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal Mat image);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal UMat image, double scalefactor/*=1.0*/, @Const @ByRef(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal UMat image);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal GpuMat image, double scalefactor/*=1.0*/, @Const @ByRef(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImage(@ByVal GpuMat image);

    /** \brief Creates 4-dimensional blob from image.
     *  \details This is an overloaded member function, provided for convenience.
     *           It differs from the above function only in what argument(s) it accepts.
     */
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal Mat image, @ByVal Mat blob, double scalefactor/*=1.0*/,
                                      @Const @ByRef(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean,
                                      @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/, int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal Mat image, @ByVal Mat blob);
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal UMat image, @ByVal UMat blob, double scalefactor/*=1.0*/,
                                      @Const @ByRef(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean,
                                      @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/, int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal UMat image, @ByVal UMat blob);
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal GpuMat image, @ByVal GpuMat blob, double scalefactor/*=1.0*/,
                                      @Const @ByRef(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean,
                                      @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/, int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImage(@ByVal GpuMat image, @ByVal GpuMat blob);


    /** \brief Creates 4-dimensional blob from series of images. Optionally resizes and
     *  crops \p images from center, subtract \p mean values, scales values by \p scalefactor,
     *  swap Blue and Red channels.
     *  @param images input images (all with 1-, 3- or 4-channels).
     *  @param size spatial size for output image
     *  @param mean scalar with mean values which are subtracted from channels. Values are intended
     *  to be in (mean-R, mean-G, mean-B) order if \p image has BGR ordering and \p swapRB is true.
     *  @param scalefactor multiplier for \p images values.
     *  @param swapRB flag which indicates that swap first and last channels
     *  in 3-channel image is necessary.
     *  @param crop flag which indicates whether image will be cropped after resize or not
     *  @param ddepth Depth of output blob. Choose CV_32F or CV_8U.
     *  \details if \p crop is true, input image is resized so one side after resize is equal to corresponding
     *  dimension in \p size and another one is equal or larger. Then, crop from the center is performed.
     *  If \p crop is false, direct resize without cropping and preserving aspect ratio is performed.
     *  @return 4-dimensional Mat with NCHW dimensions order.
     */
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal MatVector images, double scalefactor/*=1.0*/,
                                        @ByVal(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                        int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal MatVector images);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal UMatVector images, double scalefactor/*=1.0*/,
                                        @ByVal(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                        int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal UMatVector images);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal GpuMatVector images, double scalefactor/*=1.0*/,
                                        @ByVal(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                        int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native @ByVal Mat blobFromImages(@ByVal GpuMatVector images);

    /** \brief Creates 4-dimensional blob from series of images.
     *  \details This is an overloaded member function, provided for convenience.
     *           It differs from the above function only in what argument(s) it accepts.
     */
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal Mat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal Mat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal Mat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal Mat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal Mat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal Mat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal UMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal UMat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal UMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal UMat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal UMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal UMat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal GpuMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal MatVector images, @ByVal GpuMat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal GpuMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal UMatVector images, @ByVal GpuMat blob);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal GpuMat blob,
                                       double scalefactor/*=1.0*/, @ByVal(nullValue = "cv::Size()") Size size,
                                       @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean, @Cast("bool") boolean swapRB/*=false*/, @Cast("bool") boolean crop/*=false*/,
                                       int ddepth/*=CV_32F*/);
    @Namespace("cv::dnn") public static native void blobFromImages(@ByVal GpuMatVector images, @ByVal GpuMat blob);

    /** \brief Parse a 4D blob and output the images it contains as 2D arrays through a simpler data structure
     *  (std::vector<cv::Mat>).
     *  @param blob_ [in] 4 dimensional array (images, channels, height, width) in floating point precision (CV_32F) from
     *  which you would like to extract the images.
     *  @param images_ [out] array of 2D Mat containing the images extracted from the blob in floating point precision
     *  (CV_32F). They are non normalized neither mean added. The number of returned images equals the first dimension
     *  of the blob (batch size). Every image has a number of channels equals to the second dimension of the blob (depth).
     */
    @Namespace("cv::dnn") public static native void imagesFromBlob(@Const @ByRef Mat blob_, @ByVal MatVector images_);
    @Namespace("cv::dnn") public static native void imagesFromBlob(@Const @ByRef Mat blob_, @ByVal UMatVector images_);
    @Namespace("cv::dnn") public static native void imagesFromBlob(@Const @ByRef Mat blob_, @ByVal GpuMatVector images_);

    /** \brief Convert all weights of Caffe network to half precision floating point.
     * @param src Path to origin model from Caffe framework contains single
     *            precision floating point weights (usually has {@code .caffemodel} extension).
     * @param dst Path to destination model with updated weights.
     * @param layersTypes Set of layers types which parameters will be converted.
     *                    By default, converts only Convolutional and Fully-Connected layers'
     *                    weights.
     *
     * \note Shrinked model has no origin float32 weights so it can't be used
     *       in origin Caffe framework anymore. However the structure of data
     *       is taken from NVidia's Caffe fork: https://github.com/NVIDIA/caffe.
     *       So the resulting model may be used there.
     */
    @Namespace("cv::dnn") public static native void shrinkCaffeModel(@Str BytePointer src, @Str BytePointer dst,
                                           @Const @ByRef(nullValue = "std::vector<cv::String>()") StringVector layersTypes);
    @Namespace("cv::dnn") public static native void shrinkCaffeModel(@Str BytePointer src, @Str BytePointer dst);
    @Namespace("cv::dnn") public static native void shrinkCaffeModel(@Str String src, @Str String dst,
                                           @Const @ByRef(nullValue = "std::vector<cv::String>()") StringVector layersTypes);
    @Namespace("cv::dnn") public static native void shrinkCaffeModel(@Str String src, @Str String dst);

    /** \brief Create a text representation for a binary network stored in protocol buffer format.
     *  @param model [in]  A path to binary network.
     *  @param output [in] A path to output text file to be created.
     *
     *  \note To reduce output file size, trained weights are not included.
     */
    @Namespace("cv::dnn") public static native void writeTextGraph(@Str BytePointer model, @Str BytePointer output);
    @Namespace("cv::dnn") public static native void writeTextGraph(@Str String model, @Str String output);

    /** \brief Performs non maximum suppression given boxes and corresponding scores.
     <p>
     * @param bboxes a set of bounding boxes to apply NMS.
     * @param scores a set of corresponding confidences.
     * @param score_threshold a threshold used to filter boxes by score.
     * @param nms_threshold a threshold used in non maximum suppression.
     * @param indices the kept indices of bboxes after NMS.
     * @param eta a coefficient in adaptive threshold formula: {@code nms\_threshold_{i+1}=eta\cdot nms\_threshold_i}.
     * @param top_k if {@code >0}, keep at most \p top_k picked indices.
     */
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector FloatPointer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntPointer indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector FloatPointer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntPointer indices);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector FloatBuffer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntBuffer indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector FloatBuffer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntBuffer indices);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector float[] scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector int[] indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef RectVector bboxes, @StdVector float[] scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector int[] indices);

    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector FloatPointer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntPointer indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector FloatPointer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntPointer indices);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector FloatBuffer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntBuffer indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector FloatBuffer scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector IntBuffer indices);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector float[] scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector int[] indices,
                                   float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native void NMSBoxes(@Const @ByRef Rect2dVector bboxes, @StdVector float[] scores,
                                   float score_threshold, float nms_threshold,
                                   @StdVector int[] indices);

    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector FloatPointer scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector IntPointer indices,
                                 float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector FloatPointer scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector IntPointer indices);
    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector FloatBuffer scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector IntBuffer indices,
                                 float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector FloatBuffer scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector IntBuffer indices);
    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector float[] scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector int[] indices,
                                 float eta/*=1.f*/, int top_k/*=0*/);
    @Namespace("cv::dnn") public static native @Name("NMSBoxes") void NMSBoxesRotated(@StdVector RotatedRect bboxes, @StdVector float[] scores,
                                 float score_threshold, float nms_threshold,
                                 @StdVector int[] indices);
// Targeting ../opencv_dnn/Model.java


// Targeting ../opencv_dnn/ClassificationModel.java


// Targeting ../opencv_dnn/KeypointsModel.java


// Targeting ../opencv_dnn/SegmentationModel.java


// Targeting ../opencv_dnn/DetectionModel.java


// Targeting ../opencv_dnn/TextRecognitionModel.java


// Targeting ../opencv_dnn/TextDetectionModel.java


// Targeting ../opencv_dnn/TextDetectionModel_EAST.java


// Targeting ../opencv_dnn/TextDetectionModel_DB.java



/** \} */



// #include <opencv2/dnn/layer.hpp>
// #include <opencv2/dnn/dnn.inl.hpp>

/** @deprecated Include this header directly from application. Automatic inclusion will be removed */
// #include <opencv2/dnn/utils/inference_engine.hpp>

// #endif  /* OPENCV_DNN_DNN_HPP */


// Parsed from <opencv2/dnn/layer.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_DNN_LAYER_HPP
// #define OPENCV_DNN_LAYER_HPP
// #include <opencv2/dnn.hpp>
// Targeting ../opencv_dnn/LayerFactory.java



/** \}
 *  \} */


// #endif


// Parsed from <opencv2/dnn/shape_utils.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_DNN_DNN_SHAPE_UTILS_HPP
// #define OPENCV_DNN_DNN_SHAPE_UTILS_HPP

// #include <opencv2/dnn/dnn.hpp>
// #include <opencv2/core/types_c.h>  // CV_MAX_DIM
// #include <iostream>
// #include <ostream>
// #include <sstream>
// Targeting ../opencv_dnn/_Range.java



@Namespace("cv::dnn") public static native @ByVal Mat slice(@Const @ByRef Mat m, @Const @ByRef _Range r0);

@Namespace("cv::dnn") public static native @ByVal Mat slice(@Const @ByRef Mat m, @Const @ByRef _Range r0, @Const @ByRef _Range r1);

@Namespace("cv::dnn") public static native @ByVal Mat slice(@Const @ByRef Mat m, @Const @ByRef _Range r0, @Const @ByRef _Range r1, @Const @ByRef _Range r2);

@Namespace("cv::dnn") public static native @ByVal Mat slice(@Const @ByRef Mat m, @Const @ByRef _Range r0, @Const @ByRef _Range r1, @Const @ByRef _Range r2, @Const @ByRef _Range r3);

@Namespace("cv::dnn") public static native @ByVal Mat getPlane(@Const @ByRef Mat m, int n, int cn);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const IntPointer dims, int n);
@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const IntBuffer dims, int n);
@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const int[] dims, int n);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const @ByRef Mat mat);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const @ByRef MatSize sz);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(@Const @ByRef UMat mat);

// #if 0  // issues with MatExpr wrapped into InputArray
// #endif

@Namespace("cv::dnn") public static native @Cast("bool") boolean is_neg(int i);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(int a0, int a1/*=-1*/, int a2/*=-1*/, int a3/*=-1*/);
@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer shape(int a0);

@Namespace("cv::dnn") public static native int total(@Const @StdVector @ByRef IntPointer shape, int start/*=-1*/, int end/*=-1*/);
@Namespace("cv::dnn") public static native int total(@Const @StdVector @ByRef IntPointer shape);

@Namespace("cv::dnn") public static native @StdVector @ByVal IntPointer concat(@Const @StdVector @ByRef IntPointer a, @Const @StdVector @ByRef IntPointer b);

@Namespace("cv::dnn") public static native @StdString BytePointer toString(@Const @StdVector @ByRef IntPointer shape, @Str BytePointer name/*=""*/);
@Namespace("cv::dnn") public static native @StdString BytePointer toString(@Const @StdVector @ByRef IntPointer shape);
@Namespace("cv::dnn") public static native @StdString String toString(@Const @StdVector @ByRef IntPointer shape, @Str String name/*=""*/);
@Namespace("cv::dnn") public static native void print(@Const @StdVector @ByRef IntPointer shape, @Str BytePointer name/*=""*/);
@Namespace("cv::dnn") public static native void print(@Const @StdVector @ByRef IntPointer shape);
@Namespace("cv::dnn") public static native void print(@Const @StdVector @ByRef IntPointer shape, @Str String name/*=""*/);
@Namespace("cv::dnn") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @StdVector @ByRef IntPointer shape);

/** \brief Converts axis from {@code [-dims; dims)} (similar to Python's slice notation) to {@code [0; dims)} range. */
@Namespace("cv::dnn") public static native int normalize_axis(int axis, int dims);

@Namespace("cv::dnn") public static native int normalize_axis(int axis, @Const @StdVector @ByRef IntPointer shape);

@Namespace("cv::dnn") public static native @ByVal Range normalize_axis_range(@Const @ByRef Range r, int axisSize);

@Namespace("cv::dnn") public static native @Cast("bool") boolean isAllOnes(@Const @StdVector @ByRef IntPointer inputShape, int startPos, int endPos);



// #endif


}
