/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.CharIndexer;

public class CharArrayIndexer
extends CharIndexer {
    protected char[] array;

    public CharArrayIndexer(char[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public CharArrayIndexer(char[] array, long ... sizes) {
        this(array, sizes, CharArrayIndexer.strides(sizes));
    }

    public CharArrayIndexer(char[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public char[] array() {
        return this.array;
    }

    @Override
    public char get(long i) {
        return this.array[(int)i];
    }

    @Override
    public CharIndexer get(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public char get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public CharIndexer get(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public char get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public char get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public CharIndexer get(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, char c) {
        this.array[(int)i] = c;
        return this;
    }

    @Override
    public CharIndexer put(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char c) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = c;
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, long k, char c) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = c;
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char c) {
        this.array[(int)this.index((long[])indices)] = c;
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

