/*
 * This file is part of Burningwave Core.
 *
 * Author: Roberto Gentili
 *
 * Hosted at: https://github.com/burningwave/core
 *
 * --
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2022 Roberto Gentili
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 * LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
 * EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package org.burningwave.core.function;


import java.util.Objects;


@FunctionalInterface
public interface QuadPredicate<P0, P1, P2, P3> {

    boolean test(P0 p0, P1 p1, P2 p2, P3 p3);

    default QuadPredicate<P0, P1, P2, P3> and(QuadPredicate<? super P0, ? super P1, ? super P2, ? super P3> other) {
        Objects.requireNonNull(other);
        return (P0 p0, P1 p1, P2 p2, P3 p3) -> test(p0, p1, p2, p3) && other.test(p0, p1, p2, p3);
    }

    default QuadPredicate<P0, P1, P2, P3> negate() {
        return (P0 p0, P1 p1, P2 p2, P3 p3) -> !test(p0, p1, p2, p3);
    }

    default QuadPredicate<P0, P1, P2, P3> or(QuadPredicate<? super P0, ? super P1, ? super P2, ? super P3> other) {
        Objects.requireNonNull(other);
        return (P0 p0, P1 p1, P2 p2, P3 p3) -> test(p0, p1, p2, p3) || other.test(p0, p1, p2, p3);
    }

}
