/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.agent;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.agent.Agent;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.spring.ai.agent.CallModelAction;
import org.bsc.langgraph4j.spring.ai.agent.ExecuteToolsAction;
import org.bsc.langgraph4j.spring.ai.agent.ReactAgentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public interface ReactAgent {
    public static final Logger log = LoggerFactory.getLogger(ReactAgent.class);

    public static <State extends MessagesState<Message>> Builder<State> builder() {
        return new Builder();
    }

    public static class Builder<State extends MessagesState<Message>>
    extends ReactAgentBuilder<Builder<State>, State> {
        @Override
        public StateGraph<State> build(Function<ReactAgentBuilder<?, ?>, ChatService> chatServiceFactory) throws GraphStateException {
            ChatService chatService = Objects.requireNonNull(chatServiceFactory, "chatServiceFactory cannot be null!").apply(this);
            CallModelAction callModelAction = new CallModelAction(chatService, this.streaming);
            ExecuteToolsAction executeToolsAction = new ExecuteToolsAction(this.tools());
            return Agent.builder().stateSerializer(Objects.requireNonNull(this.stateSerializer, "stateSerializer cannot be null")).schema(Optional.ofNullable(this.schema).orElse(MessagesState.SCHEMA)).callModelAction(callModelAction).executeToolsAction(executeToolsAction).build();
        }
    }

    public static interface ChatService {
        public ChatClient chatClient();

        default public ChatResponse execute(List<Message> messages) {
            return this.chatClient().prompt().messages(messages).call().chatResponse();
        }

        default public Flux<ChatResponse> streamingExecute(List<Message> messages) {
            return this.chatClient().prompt().messages(messages).stream().chatResponse();
        }
    }
}

