/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.agent;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.action.AsyncCommandAction;
import org.bsc.langgraph4j.action.Command;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.spring.ai.agent.ReactAgent;
import org.bsc.langgraph4j.spring.ai.tool.SpringAIToolService;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.tool.ToolCallback;

class ExecuteToolsAction<State extends MessagesState<Message>>
implements AsyncCommandAction<State> {
    final SpringAIToolService toolService;

    public ExecuteToolsAction(List<ToolCallback> tools) {
        this.toolService = new SpringAIToolService(Objects.requireNonNull(tools, "tools cannot be null"));
    }

    public CompletableFuture<Command> apply(State state, RunnableConfig runnableConfig) {
        ReactAgent.log.trace("executeTools");
        Optional message = state.lastMessage();
        if (message.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("no input provided!"));
        }
        Object t = message.get();
        if (t instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)t;
            if (assistantMessage.hasToolCalls()) {
                return this.toolService.executeFunctions(assistantMessage.getToolCalls(), state.data()).thenApply(command -> {
                    if (command.gotoNodeSafe().isPresent()) {
                        return command;
                    }
                    return new Command("agent", command.update());
                });
            }
            return CompletableFuture.completedFuture(new Command("end"));
        }
        return CompletableFuture.failedFuture(new IllegalArgumentException("no AssistantMessage provided!"));
    }
}

