/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.SerializationHelper;
import org.springframework.ai.chat.messages.ToolResponseMessage;

public interface ToolResponseMessageHandler {

    public static class Deserializer
    extends StdDeserializer<ToolResponseMessage> {
        public Deserializer() {
            super(ToolResponseMessage.class);
        }

        public ToolResponseMessage deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode node = (ObjectNode)mapper.readTree(jsonParser);
            JsonNode responsesNode = node.findValue(Field.RESPONSES.name);
            Map<String, Object> metadata = SerializationHelper.deserializeMetadata(mapper, (JsonNode)node);
            if (responsesNode.isNull() || responsesNode.isEmpty()) {
                return ToolResponseMessage.builder().responses(List.of()).metadata(metadata).build();
            }
            ArrayList<ToolResponseMessage.ToolResponse> responses = new ArrayList<ToolResponseMessage.ToolResponse>(responsesNode.size());
            for (JsonNode responseNode : responsesNode) {
                responses.add((ToolResponseMessage.ToolResponse)mapper.treeToValue((TreeNode)responseNode, ToolResponseMessage.ToolResponse.class));
            }
            return ToolResponseMessage.builder().responses(responses).metadata(metadata).build();
        }
    }

    public static class Serializer
    extends StdSerializer<ToolResponseMessage> {
        public Serializer() {
            super(ToolResponseMessage.class);
        }

        public void serialize(ToolResponseMessage msg, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("@type", msg.getMessageType().name());
            gen.writeObjectField(Field.RESPONSES.name, (Object)msg.getResponses());
            SerializationHelper.serializeMetadata(gen, msg.getMetadata());
            gen.writeEndObject();
        }
    }

    public static enum Field {
        RESPONSES("responses");

        final String name;

        private Field(String name) {
            this.name = name;
        }
    }
}

