/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.SerializationHelper;
import org.springframework.ai.chat.messages.SystemMessage;

public interface SystemMessageHandler {

    public static class Deserializer
    extends StdDeserializer<SystemMessage> {
        protected Deserializer() {
            super(SystemMessage.class);
        }

        public SystemMessage deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode node = (ObjectNode)mapper.readTree(jsonParser);
            String text = node.get(Field.TEXT.name).asText();
            Map<String, Object> metadata = SerializationHelper.deserializeMetadata(mapper, (JsonNode)node);
            return SystemMessage.builder().text(text).metadata(metadata).build();
        }
    }

    public static class Serializer
    extends StdSerializer<SystemMessage> {
        public Serializer() {
            super(SystemMessage.class);
        }

        public void serialize(SystemMessage msg, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("@type", msg.getMessageType().name());
            gen.writeStringField(Field.TEXT.name, msg.getText());
            SerializationHelper.serializeMetadata(gen, msg.getMetadata());
            gen.writeEndObject();
        }
    }

    public static enum Field {
        TEXT("text");

        final String name;

        private Field(String name) {
            this.name = name;
        }
    }
}

