/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.SerializationHelper;
import org.springframework.ai.chat.messages.AssistantMessage;

public interface AssistantMessageHandler {

    public static class Deserializer
    extends StdDeserializer<AssistantMessage> {
        protected Deserializer() {
            super(AssistantMessage.class);
        }

        public AssistantMessage deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode node = (ObjectNode)mapper.readTree(jsonParser);
            String text = node.findValue(Field.TEXT.name).asText();
            Map<String, Object> metadata = SerializationHelper.deserializeMetadata(mapper, (JsonNode)node);
            JsonNode requestsNode = node.findValue(Field.TOOL_CALLS.name);
            if (requestsNode.isNull() || requestsNode.isEmpty()) {
                return AssistantMessage.builder().content(text).properties(metadata).build();
            }
            LinkedList<AssistantMessage.ToolCall> requests = new LinkedList<AssistantMessage.ToolCall>();
            for (JsonNode requestNode : requestsNode) {
                AssistantMessage.ToolCall request = (AssistantMessage.ToolCall)mapper.treeToValue((TreeNode)requestNode, (TypeReference)new TypeReference<AssistantMessage.ToolCall>(){});
                requests.add(request);
            }
            return AssistantMessage.builder().properties(metadata).content(text).toolCalls(requests).build();
        }
    }

    public static class Serializer
    extends StdSerializer<AssistantMessage> {
        public Serializer() {
            super(AssistantMessage.class);
        }

        public void serialize(AssistantMessage msg, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("@type", msg.getMessageType().name());
            gen.writeStringField(Field.TEXT.name, msg.getText());
            gen.writeObjectField(Field.TOOL_CALLS.name, (Object)msg.getToolCalls());
            SerializationHelper.serializeMetadata(gen, msg.getMetadata());
            gen.writeEndObject();
        }
    }

    public static enum Field {
        TEXT("text"),
        TOOL_CALLS("toolCalls"),
        MEDIA("media");

        final String name;

        private Field(String name) {
            this.name = name;
        }
    }
}

