/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Comparator;
import lombok.Generated;
import org.bremersee.comparator.DefaultValueExtractor;
import org.bremersee.comparator.ValueExtractor;

public class DelegatingComparator
implements Comparator<Object> {
    private final ValueExtractor valueExtractor;
    private final String field;
    private final Comparator comparator;

    public DelegatingComparator(String field, Comparator<?> comparator) {
        this(field, null, comparator);
    }

    public DelegatingComparator(String field, ValueExtractor valueExtractor, Comparator<?> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator must not be null.");
        }
        this.field = field;
        this.comparator = comparator;
        this.valueExtractor = valueExtractor != null ? valueExtractor : new DefaultValueExtractor();
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object v1 = this.valueExtractor.findValue(o1, this.field);
        Object v2 = this.valueExtractor.findValue(o2, this.field);
        return this.comparator.compare(v1, v2);
    }

    @Generated
    public String toString() {
        return "DelegatingComparator(valueExtractor=" + this.valueExtractor + ", field=" + this.field + ", comparator=" + this.comparator + ")";
    }
}

