/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.bremersee.comparator.ComparatorException;

public class ComparatorChain
implements Comparator<Object> {
    private final List<Comparator> comparators;

    public ComparatorChain(List<Comparator> comparators) {
        this.comparators = comparators != null ? comparators : new LinkedList();
    }

    @Override
    public int compare(Object o1, Object o2) {
        boolean wasCompared = false;
        for (Comparator comparator : this.comparators) {
            wasCompared = true;
            int result = comparator.compare(o1, o2);
            if (result == 0) continue;
            return result;
        }
        if (wasCompared) {
            return 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        throw new ComparatorException("Comparison of objects is not possible.");
    }

    @Generated
    public String toString() {
        return "ComparatorChain(comparators=" + this.comparators + ")";
    }
}

