package org.bremersee.comparator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SortOrdersTextProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSortOrdersTextProperties.builder()}.
 */
@Generated(from = "SortOrdersTextProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSortOrdersTextProperties
    implements SortOrdersTextProperties {
  private final String sortOrderSeparator;
  private final String sortOrderArgsSeparator;
  private final String ascValue;
  private final String descValue;
  private final String caseInsensitiveValue;
  private final String caseSensitiveValue;
  private final String nullIsLastValue;
  private final String nullIsFirstValue;

  private ImmutableSortOrdersTextProperties(ImmutableSortOrdersTextProperties.Builder builder) {
    if (builder.sortOrderSeparator != null) {
      initShim.sortOrderSeparator(builder.sortOrderSeparator);
    }
    if (builder.sortOrderArgsSeparator != null) {
      initShim.sortOrderArgsSeparator(builder.sortOrderArgsSeparator);
    }
    if (builder.ascValue != null) {
      initShim.ascValue(builder.ascValue);
    }
    if (builder.descValue != null) {
      initShim.descValue(builder.descValue);
    }
    if (builder.caseInsensitiveValue != null) {
      initShim.caseInsensitiveValue(builder.caseInsensitiveValue);
    }
    if (builder.caseSensitiveValue != null) {
      initShim.caseSensitiveValue(builder.caseSensitiveValue);
    }
    if (builder.nullIsLastValue != null) {
      initShim.nullIsLastValue(builder.nullIsLastValue);
    }
    if (builder.nullIsFirstValue != null) {
      initShim.nullIsFirstValue(builder.nullIsFirstValue);
    }
    this.sortOrderSeparator = initShim.getSortOrderSeparator();
    this.sortOrderArgsSeparator = initShim.getSortOrderArgsSeparator();
    this.ascValue = initShim.getAscValue();
    this.descValue = initShim.getDescValue();
    this.caseInsensitiveValue = initShim.getCaseInsensitiveValue();
    this.caseSensitiveValue = initShim.getCaseSensitiveValue();
    this.nullIsLastValue = initShim.getNullIsLastValue();
    this.nullIsFirstValue = initShim.getNullIsFirstValue();
    this.initShim = null;
  }

  private ImmutableSortOrdersTextProperties(
      String sortOrderSeparator,
      String sortOrderArgsSeparator,
      String ascValue,
      String descValue,
      String caseInsensitiveValue,
      String caseSensitiveValue,
      String nullIsLastValue,
      String nullIsFirstValue) {
    this.sortOrderSeparator = sortOrderSeparator;
    this.sortOrderArgsSeparator = sortOrderArgsSeparator;
    this.ascValue = ascValue;
    this.descValue = descValue;
    this.caseInsensitiveValue = caseInsensitiveValue;
    this.caseSensitiveValue = caseSensitiveValue;
    this.nullIsLastValue = nullIsLastValue;
    this.nullIsFirstValue = nullIsFirstValue;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SortOrdersTextProperties", generator = "Immutables")
  private final class InitShim {
    private byte sortOrderSeparatorBuildStage = STAGE_UNINITIALIZED;
    private String sortOrderSeparator;

    String getSortOrderSeparator() {
      if (sortOrderSeparatorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sortOrderSeparatorBuildStage == STAGE_UNINITIALIZED) {
        sortOrderSeparatorBuildStage = STAGE_INITIALIZING;
        this.sortOrderSeparator = Objects.requireNonNull(getSortOrderSeparatorInitialize(), "sortOrderSeparator");
        sortOrderSeparatorBuildStage = STAGE_INITIALIZED;
      }
      return this.sortOrderSeparator;
    }

    void sortOrderSeparator(String sortOrderSeparator) {
      this.sortOrderSeparator = sortOrderSeparator;
      sortOrderSeparatorBuildStage = STAGE_INITIALIZED;
    }

    private byte sortOrderArgsSeparatorBuildStage = STAGE_UNINITIALIZED;
    private String sortOrderArgsSeparator;

    String getSortOrderArgsSeparator() {
      if (sortOrderArgsSeparatorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sortOrderArgsSeparatorBuildStage == STAGE_UNINITIALIZED) {
        sortOrderArgsSeparatorBuildStage = STAGE_INITIALIZING;
        this.sortOrderArgsSeparator = Objects.requireNonNull(getSortOrderArgsSeparatorInitialize(), "sortOrderArgsSeparator");
        sortOrderArgsSeparatorBuildStage = STAGE_INITIALIZED;
      }
      return this.sortOrderArgsSeparator;
    }

    void sortOrderArgsSeparator(String sortOrderArgsSeparator) {
      this.sortOrderArgsSeparator = sortOrderArgsSeparator;
      sortOrderArgsSeparatorBuildStage = STAGE_INITIALIZED;
    }

    private byte ascValueBuildStage = STAGE_UNINITIALIZED;
    private String ascValue;

    String getAscValue() {
      if (ascValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ascValueBuildStage == STAGE_UNINITIALIZED) {
        ascValueBuildStage = STAGE_INITIALIZING;
        this.ascValue = Objects.requireNonNull(getAscValueInitialize(), "ascValue");
        ascValueBuildStage = STAGE_INITIALIZED;
      }
      return this.ascValue;
    }

    void ascValue(String ascValue) {
      this.ascValue = ascValue;
      ascValueBuildStage = STAGE_INITIALIZED;
    }

    private byte descValueBuildStage = STAGE_UNINITIALIZED;
    private String descValue;

    String getDescValue() {
      if (descValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (descValueBuildStage == STAGE_UNINITIALIZED) {
        descValueBuildStage = STAGE_INITIALIZING;
        this.descValue = Objects.requireNonNull(getDescValueInitialize(), "descValue");
        descValueBuildStage = STAGE_INITIALIZED;
      }
      return this.descValue;
    }

    void descValue(String descValue) {
      this.descValue = descValue;
      descValueBuildStage = STAGE_INITIALIZED;
    }

    private byte caseInsensitiveValueBuildStage = STAGE_UNINITIALIZED;
    private String caseInsensitiveValue;

    String getCaseInsensitiveValue() {
      if (caseInsensitiveValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (caseInsensitiveValueBuildStage == STAGE_UNINITIALIZED) {
        caseInsensitiveValueBuildStage = STAGE_INITIALIZING;
        this.caseInsensitiveValue = Objects.requireNonNull(getCaseInsensitiveValueInitialize(), "caseInsensitiveValue");
        caseInsensitiveValueBuildStage = STAGE_INITIALIZED;
      }
      return this.caseInsensitiveValue;
    }

    void caseInsensitiveValue(String caseInsensitiveValue) {
      this.caseInsensitiveValue = caseInsensitiveValue;
      caseInsensitiveValueBuildStage = STAGE_INITIALIZED;
    }

    private byte caseSensitiveValueBuildStage = STAGE_UNINITIALIZED;
    private String caseSensitiveValue;

    String getCaseSensitiveValue() {
      if (caseSensitiveValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (caseSensitiveValueBuildStage == STAGE_UNINITIALIZED) {
        caseSensitiveValueBuildStage = STAGE_INITIALIZING;
        this.caseSensitiveValue = Objects.requireNonNull(getCaseSensitiveValueInitialize(), "caseSensitiveValue");
        caseSensitiveValueBuildStage = STAGE_INITIALIZED;
      }
      return this.caseSensitiveValue;
    }

    void caseSensitiveValue(String caseSensitiveValue) {
      this.caseSensitiveValue = caseSensitiveValue;
      caseSensitiveValueBuildStage = STAGE_INITIALIZED;
    }

    private byte nullIsLastValueBuildStage = STAGE_UNINITIALIZED;
    private String nullIsLastValue;

    String getNullIsLastValue() {
      if (nullIsLastValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nullIsLastValueBuildStage == STAGE_UNINITIALIZED) {
        nullIsLastValueBuildStage = STAGE_INITIALIZING;
        this.nullIsLastValue = Objects.requireNonNull(getNullIsLastValueInitialize(), "nullIsLastValue");
        nullIsLastValueBuildStage = STAGE_INITIALIZED;
      }
      return this.nullIsLastValue;
    }

    void nullIsLastValue(String nullIsLastValue) {
      this.nullIsLastValue = nullIsLastValue;
      nullIsLastValueBuildStage = STAGE_INITIALIZED;
    }

    private byte nullIsFirstValueBuildStage = STAGE_UNINITIALIZED;
    private String nullIsFirstValue;

    String getNullIsFirstValue() {
      if (nullIsFirstValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nullIsFirstValueBuildStage == STAGE_UNINITIALIZED) {
        nullIsFirstValueBuildStage = STAGE_INITIALIZING;
        this.nullIsFirstValue = Objects.requireNonNull(getNullIsFirstValueInitialize(), "nullIsFirstValue");
        nullIsFirstValueBuildStage = STAGE_INITIALIZED;
      }
      return this.nullIsFirstValue;
    }

    void nullIsFirstValue(String nullIsFirstValue) {
      this.nullIsFirstValue = nullIsFirstValue;
      nullIsFirstValueBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (sortOrderSeparatorBuildStage == STAGE_INITIALIZING) attributes.add("sortOrderSeparator");
      if (sortOrderArgsSeparatorBuildStage == STAGE_INITIALIZING) attributes.add("sortOrderArgsSeparator");
      if (ascValueBuildStage == STAGE_INITIALIZING) attributes.add("ascValue");
      if (descValueBuildStage == STAGE_INITIALIZING) attributes.add("descValue");
      if (caseInsensitiveValueBuildStage == STAGE_INITIALIZING) attributes.add("caseInsensitiveValue");
      if (caseSensitiveValueBuildStage == STAGE_INITIALIZING) attributes.add("caseSensitiveValue");
      if (nullIsLastValueBuildStage == STAGE_INITIALIZING) attributes.add("nullIsLastValue");
      if (nullIsFirstValueBuildStage == STAGE_INITIALIZING) attributes.add("nullIsFirstValue");
      return "Cannot build SortOrdersTextProperties, attribute initializers form cycle " + attributes;
    }
  }

  private String getSortOrderSeparatorInitialize() {
    return SortOrdersTextProperties.super.getSortOrderSeparator();
  }

  private String getSortOrderArgsSeparatorInitialize() {
    return SortOrdersTextProperties.super.getSortOrderArgsSeparator();
  }

  private String getAscValueInitialize() {
    return SortOrdersTextProperties.super.getAscValue();
  }

  private String getDescValueInitialize() {
    return SortOrdersTextProperties.super.getDescValue();
  }

  private String getCaseInsensitiveValueInitialize() {
    return SortOrdersTextProperties.super.getCaseInsensitiveValue();
  }

  private String getCaseSensitiveValueInitialize() {
    return SortOrdersTextProperties.super.getCaseSensitiveValue();
  }

  private String getNullIsLastValueInitialize() {
    return SortOrdersTextProperties.super.getNullIsLastValue();
  }

  private String getNullIsFirstValueInitialize() {
    return SortOrdersTextProperties.super.getNullIsFirstValue();
  }

  /**
   * Gets sort order separator.
   * @return the sort order separator
   */
  @Override
  public String getSortOrderSeparator() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSortOrderSeparator()
        : this.sortOrderSeparator;
  }

  /**
   * Gets sort order args separator.
   * @return the sort order args separator
   */
  @Override
  public String getSortOrderArgsSeparator() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSortOrderArgsSeparator()
        : this.sortOrderArgsSeparator;
  }

  /**
   * Gets asc value.
   * @return the asc value
   */
  @Override
  public String getAscValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAscValue()
        : this.ascValue;
  }

  /**
   * Gets desc value.
   * @return the desc value
   */
  @Override
  public String getDescValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDescValue()
        : this.descValue;
  }

  /**
   * Gets case insensitive value.
   * @return the case insensitive value
   */
  @Override
  public String getCaseInsensitiveValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCaseInsensitiveValue()
        : this.caseInsensitiveValue;
  }

  /**
   * Gets case sensitive value.
   * @return the case sensitive value
   */
  @Override
  public String getCaseSensitiveValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCaseSensitiveValue()
        : this.caseSensitiveValue;
  }

  /**
   * Gets null is last value.
   * @return the null is last value
   */
  @Override
  public String getNullIsLastValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getNullIsLastValue()
        : this.nullIsLastValue;
  }

  /**
   * Gets null is first value.
   * @return the null is first value
   */
  @Override
  public String getNullIsFirstValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getNullIsFirstValue()
        : this.nullIsFirstValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getSortOrderSeparator() sortOrderSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortOrderSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withSortOrderSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "sortOrderSeparator");
    if (this.sortOrderSeparator.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        newValue,
        this.sortOrderArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getSortOrderArgsSeparator() sortOrderArgsSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortOrderArgsSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withSortOrderArgsSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "sortOrderArgsSeparator");
    if (this.sortOrderArgsSeparator.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        newValue,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getAscValue() ascValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ascValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withAscValue(String value) {
    String newValue = Objects.requireNonNull(value, "ascValue");
    if (this.ascValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        newValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getDescValue() descValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for descValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withDescValue(String value) {
    String newValue = Objects.requireNonNull(value, "descValue");
    if (this.descValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        this.ascValue,
        newValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getCaseInsensitiveValue() caseInsensitiveValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caseInsensitiveValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withCaseInsensitiveValue(String value) {
    String newValue = Objects.requireNonNull(value, "caseInsensitiveValue");
    if (this.caseInsensitiveValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        this.ascValue,
        this.descValue,
        newValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getCaseSensitiveValue() caseSensitiveValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caseSensitiveValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withCaseSensitiveValue(String value) {
    String newValue = Objects.requireNonNull(value, "caseSensitiveValue");
    if (this.caseSensitiveValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        newValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getNullIsLastValue() nullIsLastValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullIsLastValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withNullIsLastValue(String value) {
    String newValue = Objects.requireNonNull(value, "nullIsLastValue");
    if (this.nullIsLastValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        newValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortOrdersTextProperties#getNullIsFirstValue() nullIsFirstValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullIsFirstValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortOrdersTextProperties withNullIsFirstValue(String value) {
    String newValue = Objects.requireNonNull(value, "nullIsFirstValue");
    if (this.nullIsFirstValue.equals(newValue)) return this;
    return new ImmutableSortOrdersTextProperties(
        this.sortOrderSeparator,
        this.sortOrderArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSortOrdersTextProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSortOrdersTextProperties
        && equalTo((ImmutableSortOrdersTextProperties) another);
  }

  private boolean equalTo(ImmutableSortOrdersTextProperties another) {
    return sortOrderSeparator.equals(another.sortOrderSeparator)
        && sortOrderArgsSeparator.equals(another.sortOrderArgsSeparator)
        && ascValue.equals(another.ascValue)
        && descValue.equals(another.descValue)
        && caseInsensitiveValue.equals(another.caseInsensitiveValue)
        && caseSensitiveValue.equals(another.caseSensitiveValue)
        && nullIsLastValue.equals(another.nullIsLastValue)
        && nullIsFirstValue.equals(another.nullIsFirstValue);
  }

  /**
   * Computes a hash code from attributes: {@code sortOrderSeparator}, {@code sortOrderArgsSeparator}, {@code ascValue}, {@code descValue}, {@code caseInsensitiveValue}, {@code caseSensitiveValue}, {@code nullIsLastValue}, {@code nullIsFirstValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sortOrderSeparator.hashCode();
    h += (h << 5) + sortOrderArgsSeparator.hashCode();
    h += (h << 5) + ascValue.hashCode();
    h += (h << 5) + descValue.hashCode();
    h += (h << 5) + caseInsensitiveValue.hashCode();
    h += (h << 5) + caseSensitiveValue.hashCode();
    h += (h << 5) + nullIsLastValue.hashCode();
    h += (h << 5) + nullIsFirstValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SortOrdersTextProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SortOrdersTextProperties{"
        + "sortOrderSeparator=" + sortOrderSeparator
        + ", sortOrderArgsSeparator=" + sortOrderArgsSeparator
        + ", ascValue=" + ascValue
        + ", descValue=" + descValue
        + ", caseInsensitiveValue=" + caseInsensitiveValue
        + ", caseSensitiveValue=" + caseSensitiveValue
        + ", nullIsLastValue=" + nullIsLastValue
        + ", nullIsFirstValue=" + nullIsFirstValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SortOrdersTextProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SortOrdersTextProperties instance
   */
  public static ImmutableSortOrdersTextProperties copyOf(SortOrdersTextProperties instance) {
    if (instance instanceof ImmutableSortOrdersTextProperties) {
      return (ImmutableSortOrdersTextProperties) instance;
    }
    return ImmutableSortOrdersTextProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSortOrdersTextProperties ImmutableSortOrdersTextProperties}.
   * <pre>
   * ImmutableSortOrdersTextProperties.builder()
   *    .sortOrderSeparator(String) // optional {@link SortOrdersTextProperties#getSortOrderSeparator() sortOrderSeparator}
   *    .sortOrderArgsSeparator(String) // optional {@link SortOrdersTextProperties#getSortOrderArgsSeparator() sortOrderArgsSeparator}
   *    .ascValue(String) // optional {@link SortOrdersTextProperties#getAscValue() ascValue}
   *    .descValue(String) // optional {@link SortOrdersTextProperties#getDescValue() descValue}
   *    .caseInsensitiveValue(String) // optional {@link SortOrdersTextProperties#getCaseInsensitiveValue() caseInsensitiveValue}
   *    .caseSensitiveValue(String) // optional {@link SortOrdersTextProperties#getCaseSensitiveValue() caseSensitiveValue}
   *    .nullIsLastValue(String) // optional {@link SortOrdersTextProperties#getNullIsLastValue() nullIsLastValue}
   *    .nullIsFirstValue(String) // optional {@link SortOrdersTextProperties#getNullIsFirstValue() nullIsFirstValue}
   *    .build();
   * </pre>
   * @return A new ImmutableSortOrdersTextProperties builder
   */
  public static ImmutableSortOrdersTextProperties.Builder builder() {
    return new ImmutableSortOrdersTextProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSortOrdersTextProperties ImmutableSortOrdersTextProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SortOrdersTextProperties", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sortOrderSeparator;
    private @Nullable String sortOrderArgsSeparator;
    private @Nullable String ascValue;
    private @Nullable String descValue;
    private @Nullable String caseInsensitiveValue;
    private @Nullable String caseSensitiveValue;
    private @Nullable String nullIsLastValue;
    private @Nullable String nullIsFirstValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SortOrdersTextProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SortOrdersTextProperties instance) {
      Objects.requireNonNull(instance, "instance");
      sortOrderSeparator(instance.getSortOrderSeparator());
      sortOrderArgsSeparator(instance.getSortOrderArgsSeparator());
      ascValue(instance.getAscValue());
      descValue(instance.getDescValue());
      caseInsensitiveValue(instance.getCaseInsensitiveValue());
      caseSensitiveValue(instance.getCaseSensitiveValue());
      nullIsLastValue(instance.getNullIsLastValue());
      nullIsFirstValue(instance.getNullIsFirstValue());
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getSortOrderSeparator() sortOrderSeparator} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getSortOrderSeparator() sortOrderSeparator}.</em>
     * @param sortOrderSeparator The value for sortOrderSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sortOrderSeparator(String sortOrderSeparator) {
      this.sortOrderSeparator = Objects.requireNonNull(sortOrderSeparator, "sortOrderSeparator");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getSortOrderArgsSeparator() sortOrderArgsSeparator} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getSortOrderArgsSeparator() sortOrderArgsSeparator}.</em>
     * @param sortOrderArgsSeparator The value for sortOrderArgsSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sortOrderArgsSeparator(String sortOrderArgsSeparator) {
      this.sortOrderArgsSeparator = Objects.requireNonNull(sortOrderArgsSeparator, "sortOrderArgsSeparator");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getAscValue() ascValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getAscValue() ascValue}.</em>
     * @param ascValue The value for ascValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ascValue(String ascValue) {
      this.ascValue = Objects.requireNonNull(ascValue, "ascValue");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getDescValue() descValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getDescValue() descValue}.</em>
     * @param descValue The value for descValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descValue(String descValue) {
      this.descValue = Objects.requireNonNull(descValue, "descValue");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getCaseInsensitiveValue() caseInsensitiveValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getCaseInsensitiveValue() caseInsensitiveValue}.</em>
     * @param caseInsensitiveValue The value for caseInsensitiveValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caseInsensitiveValue(String caseInsensitiveValue) {
      this.caseInsensitiveValue = Objects.requireNonNull(caseInsensitiveValue, "caseInsensitiveValue");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getCaseSensitiveValue() caseSensitiveValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getCaseSensitiveValue() caseSensitiveValue}.</em>
     * @param caseSensitiveValue The value for caseSensitiveValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caseSensitiveValue(String caseSensitiveValue) {
      this.caseSensitiveValue = Objects.requireNonNull(caseSensitiveValue, "caseSensitiveValue");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getNullIsLastValue() nullIsLastValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getNullIsLastValue() nullIsLastValue}.</em>
     * @param nullIsLastValue The value for nullIsLastValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nullIsLastValue(String nullIsLastValue) {
      this.nullIsLastValue = Objects.requireNonNull(nullIsLastValue, "nullIsLastValue");
      return this;
    }

    /**
     * Initializes the value for the {@link SortOrdersTextProperties#getNullIsFirstValue() nullIsFirstValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SortOrdersTextProperties#getNullIsFirstValue() nullIsFirstValue}.</em>
     * @param nullIsFirstValue The value for nullIsFirstValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nullIsFirstValue(String nullIsFirstValue) {
      this.nullIsFirstValue = Objects.requireNonNull(nullIsFirstValue, "nullIsFirstValue");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSortOrdersTextProperties ImmutableSortOrdersTextProperties}.
     * @return An immutable instance of SortOrdersTextProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSortOrdersTextProperties build() {
      return new ImmutableSortOrdersTextProperties(this);
    }
  }
}
