/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.crypto.TlsHMAC;

final class BcTlsHMAC
implements TlsHMAC {
    private final HMac hmac;

    BcTlsHMAC(HMac hMac) {
        this.hmac = hMac;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.hmac.init((CipherParameters)new KeyParameter(byArray, n, n2));
    }

    public void update(byte[] byArray, int n, int n2) {
        this.hmac.update(byArray, n, n2);
    }

    public byte[] calculateMAC() {
        byte[] byArray = new byte[this.hmac.getMacSize()];
        this.hmac.doFinal(byArray, 0);
        return byArray;
    }

    public void calculateMAC(byte[] byArray, int n) {
        this.hmac.doFinal(byArray, n);
    }

    public int getInternalBlockSize() {
        return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
    }

    public int getMacLength() {
        return this.hmac.getMacSize();
    }

    public void reset() {
        this.hmac.reset();
    }
}

