/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.MACAlgorithm;
import org.bouncycastle.tls.PRFAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;

public abstract class TlsCryptoUtils {
    private static final byte[] TLS13_PREFIX = new byte[]{116, 108, 115, 49, 51, 32};

    public static int getHash(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified HashAlgorithm invalid: " + HashAlgorithm.getText(s));
    }

    public static int getHashForHMAC(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(n));
    }

    public static int getHashForPRF(int n) {
        switch (n) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 3: 
            case 5: {
                return 5;
            }
            case 7: {
                return 7;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(n));
    }

    public static int getHashOutputSize(int n) {
        switch (n) {
            case 1: {
                return 16;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 28;
            }
            case 4: 
            case 7: {
                return 32;
            }
            case 5: {
                return 48;
            }
            case 6: {
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getSignature(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 64: {
                return 64;
            }
            case 65: {
                return 65;
            }
        }
        throw new IllegalArgumentException("specified SignatureAlgorithm invalid: " + SignatureAlgorithm.getText(s));
    }

    public static TlsSecret hkdfExpandLabel(TlsSecret tlsSecret, short s, String string, byte[] byArray, int n) throws IOException {
        int n2 = TlsCryptoUtils.getHash(s);
        return TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n2, string, byArray, n);
    }

    public static TlsSecret hkdfExpandLabel(TlsSecret tlsSecret, int n, String string, byte[] byArray, int n2) throws IOException {
        int n3 = string.length();
        if (n3 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n4 = byArray.length;
        int n5 = TLS13_PREFIX.length + n3;
        byte[] byArray2 = new byte[2 + (1 + n5) + (1 + n4)];
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, byArray2, 0);
        TlsUtils.checkUint8(n5);
        TlsUtils.writeUint8(n5, byArray2, 2);
        System.arraycopy(TLS13_PREFIX, 0, byArray2, 3, TLS13_PREFIX.length);
        int n6 = 2 + (1 + TLS13_PREFIX.length);
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            byArray2[n6 + i] = (byte)c;
        }
        TlsUtils.writeOpaque8(byArray, byArray2, 2 + (1 + n5));
        return tlsSecret.hkdfExpand(n, byArray2, n2);
    }
}

