/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.util.Strings;

class PGPUtil
implements HashAlgorithmTags {
    PGPUtil() {
    }

    static byte[] makeKeyFromPassPhrase(PGPDigestCalculator digestCalculator, int algorithm, S2K s2k, char[] passPhrase) throws PGPException {
        int keySize;
        switch (algorithm) {
            case 2: 
            case 8: 
            case 12: {
                keySize = 192;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                keySize = 128;
                break;
            }
            case 6: {
                keySize = 64;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                keySize = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] pBytes = Strings.toUTF8ByteArray((char[])passPhrase);
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        int generatedBytes = 0;
        int loopCount = 0;
        if (s2k != null) {
            if (s2k.getType() == 4) {
                Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withSalt(s2k.getIV()).withIterations(s2k.getPasses()).withParallelism(s2k.getParallelism()).withMemoryPowOfTwo(s2k.getMemorySizeExponent()).withVersion(19);
                Argon2BytesGenerator argon2 = new Argon2BytesGenerator();
                argon2.init(builder.build());
                argon2.generateBytes(passPhrase, keyBytes);
                return keyBytes;
            }
            if (s2k.getHashAlgorithm() != digestCalculator.getAlgorithm()) {
                throw new PGPException("s2k/digestCalculator mismatch");
            }
        } else if (digestCalculator.getAlgorithm() != 1) {
            throw new PGPException("digestCalculator not for MD5");
        }
        OutputStream dOut = digestCalculator.getOutputStream();
        try {
            byte[] iv;
            byte[] byArray = iv = s2k != null ? s2k.getIV() : null;
            while (generatedBytes < keyBytes.length) {
                block24: {
                    block25: {
                        for (int i = 0; i != loopCount; ++i) {
                            dOut.write(0);
                        }
                        if (s2k == null) break block25;
                        switch (s2k.getType()) {
                            case 0: {
                                dOut.write(pBytes);
                                break block24;
                            }
                            case 1: {
                                dOut.write(iv);
                                dOut.write(pBytes);
                                break block24;
                            }
                            case 3: {
                                long count = s2k.getIterationCount();
                                dOut.write(iv);
                                dOut.write(pBytes);
                                count -= (long)(iv.length + pBytes.length);
                                while (count > 0L) {
                                    if (count < (long)iv.length) {
                                        dOut.write(iv, 0, (int)count);
                                        break block24;
                                    }
                                    dOut.write(iv);
                                    if ((count -= (long)iv.length) < (long)pBytes.length) {
                                        dOut.write(pBytes, 0, (int)count);
                                        count = 0L;
                                        continue;
                                    }
                                    dOut.write(pBytes);
                                    count -= (long)pBytes.length;
                                }
                                break block24;
                            }
                            default: {
                                throw new PGPException("unknown S2K type: " + s2k.getType());
                            }
                        }
                    }
                    dOut.write(pBytes);
                }
                dOut.close();
                byte[] dig = digestCalculator.getDigest();
                int toCopy = Math.min(dig.length, keyBytes.length - generatedBytes);
                System.arraycopy(dig, 0, keyBytes, generatedBytes, toCopy);
                generatedBytes += toCopy;
                ++loopCount;
            }
        }
        catch (IOException e) {
            throw new PGPException("exception calculating digest: " + e.getMessage(), e);
        }
        for (int i = 0; i != pBytes.length; ++i) {
            pBytes[i] = 0;
        }
        return keyBytes;
    }

    public static byte[] makeKeyFromPassPhrase(PGPDigestCalculatorProvider digCalcProvider, int algorithm, S2K s2k, char[] passPhrase) throws PGPException {
        PGPDigestCalculator digestCalculator = s2k != null && s2k.getType() != 4 ? digCalcProvider.get(s2k.getHashAlgorithm()) : digCalcProvider.get(1);
        return PGPUtil.makeKeyFromPassPhrase(digestCalculator, algorithm, s2k, passPhrase);
    }
}

