/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.Collections;
import java.util.List;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class ExtendedPGPSecretKey
extends PGPSecretKey {
    private final List<PGPExtendedKeyHeader> headers;
    private final List<PGPExtendedKeyAttribute> attributes;

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, SecretKeyPacket secret, PGPPublicKey pub) {
        super(secret, pub);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(privKey, pubKey, checksumCalculator, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, boolean isMasterKey, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(privKey, pubKey, checksumCalculator, isMasterKey, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, PGPKeyPair masterKeyPair, PGPKeyPair keyPair, PGPDigestCalculator checksumCalculator, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(masterKeyPair, keyPair, checksumCalculator, certificationSignerBuilder, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, PGPKeyPair masterKeyPair, PGPKeyPair keyPair, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(masterKeyPair, keyPair, checksumCalculator, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public ExtendedPGPSecretKey(List<PGPExtendedKeyHeader> headerList, List<PGPExtendedKeyAttribute> attributes, int certificationLevel, PGPKeyPair keyPair, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        super(certificationLevel, keyPair, id, checksumCalculator, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
        this.headers = Collections.unmodifiableList(headerList);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public List<PGPExtendedKeyHeader> getHeaders() {
        return this.headers;
    }

    public List<PGPExtendedKeyAttribute> getAttributes() {
        return this.attributes;
    }
}

