/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.Strings;

public class PGPSecretKeyRingCollection {
    private Map secretRings = new HashMap();
    private List order = new ArrayList();

    private PGPSecretKeyRingCollection(Map map, List list) {
        this.secretRings = map;
        this.order = list;
    }

    public PGPSecretKeyRingCollection(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPSecretKeyRingCollection(InputStream inputStream) throws IOException, PGPException {
        Object object;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (!(object instanceof PGPSecretKeyRing)) {
                throw new PGPException(object.getClass().getName() + " found where PGPSecretKeyRing expected");
            }
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object;
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public PGPSecretKeyRingCollection(Collection collection) throws IOException, PGPException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public Iterator getKeyRings(String string) throws PGPException {
        return this.getKeyRings(string, false, false);
    }

    public Iterator getKeyRings(String string, boolean bl) throws PGPException {
        return this.getKeyRings(string, bl, false);
    }

    public Iterator getKeyRings(String string, boolean bl, boolean bl2) throws PGPException {
        Iterator iterator = this.getKeyRings();
        ArrayList<PGPSecretKeyRing> arrayList = new ArrayList<PGPSecretKeyRing>();
        if (bl2) {
            string = Strings.toLowerCase((String)string);
        }
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKey().getUserIDs();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (bl2) {
                    string2 = Strings.toLowerCase((String)string2);
                }
                if (bl) {
                    if (string2.indexOf(string) <= -1) continue;
                    arrayList.add(pGPSecretKeyRing);
                    continue;
                }
                if (!string2.equals(string)) continue;
                arrayList.add(pGPSecretKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public PGPSecretKey getSecretKey(long l) throws PGPException {
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.secretRings.containsKey(l2)) {
            return (PGPSecretKeyRing)this.secretRings.get(l2);
        }
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKeyRing;
        }
        return null;
    }

    public boolean contains(long l) throws PGPException {
        return this.getSecretKey(l) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = this.order.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)this.secretRings.get(iterator.next());
            pGPSecretKeyRing.encode(bCPGOutputStream);
        }
    }

    public static PGPSecretKeyRingCollection addSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
        if (pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> hashMap = new HashMap<Long, PGPSecretKeyRing>(pGPSecretKeyRingCollection.secretRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPSecretKeyRingCollection.order);
        hashMap.put(l, pGPSecretKeyRing);
        arrayList.add(l);
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }

    public static PGPSecretKeyRingCollection removeSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
        if (!pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap hashMap = new HashMap(pGPSecretKeyRingCollection.secretRings);
        ArrayList arrayList = new ArrayList(pGPSecretKeyRingCollection.order);
        hashMap.remove(l);
        for (int i = 0; i < arrayList.size(); ++i) {
            Long l2 = (Long)arrayList.get(i);
            if (l2.longValue() != l.longValue()) continue;
            arrayList.remove(i);
            break;
        }
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }
}

