/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.io.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MacOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Mac mac;

    public MacOutputStream(Mac mac) {
        this.algorithmName = mac.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.mac = mac;
    }

    @Override
    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.mac.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.mac.update(byArray, n, n2);
    }

    public byte[] getMac() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        byte[] byArray = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray, 0);
        return byArray;
    }
}

