/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricGOST3410PublicKey
extends AsymmetricGOST3410Key<GOST3410DomainParameters>
implements AsymmetricPublicKey {
    private BigInteger y;

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters, BigInteger bigInteger) {
        super(algorithm, gOST3410Parameters);
        this.y = bigInteger;
    }

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, fpAcceptable, subjectPublicKeyInfo.getAlgorithm());
        this.y = AsymmetricGOST3410PublicKey.parsePublicKey(subjectPublicKeyInfo);
    }

    private static BigInteger parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i != byArray.length; ++i) {
                byArray2[i] = byArray[byArray.length - 1 - i];
            }
            return new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in GOST3410 public key");
        }
    }

    public BigInteger getY() {
        return this.y;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.getY().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray2));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94), new DEROctetString(byArray2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricGOST3410PublicKey)) {
            return false;
        }
        AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)object;
        return this.y.equals(asymmetricGOST3410PublicKey.getY()) && this.getParameters().equals(asymmetricGOST3410PublicKey.getParameters());
    }

    @Override
    public int hashCode() {
        int n = this.y.hashCode();
        n = 31 * n + this.getParameters().hashCode();
        return n;
    }
}

