/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class EcDhBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhBasicAgreement() {
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint;
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        if (!ecDomainParameters.equals(ecPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("ECDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = this.key.getD();
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(ecDomainParameters.getCurve(), ecPublicKeyParameters.getQ());
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        BigInteger bigInteger2 = ecDomainParameters.getH();
        if (!bigInteger2.equals(ECConstants.ONE)) {
            bigInteger = ecDomainParameters.getHInv().multiply(bigInteger).mod(ecDomainParameters.getN());
            eCPoint2 = ECAlgorithms.referenceMultiply(eCPoint2, bigInteger2);
        }
        if ((eCPoint = eCPoint2.multiply(bigInteger).normalize()).isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

