/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.XofUtils;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] ZERO_BYTE = new byte[1];
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    CSHAKEDigest(CSHAKEDigest cSHAKEDigest) {
        super(cSHAKEDigest);
        this.diff = Arrays.clone(cSHAKEDigest.diff);
    }

    CSHAKEDigest(int n, byte[] byArray, byte[] byArray2) {
        super(n);
        if (n == 128) {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE128, this, new KatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba74097d5c526a6d35f97b83351940f2cc8")));
        } else {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE256, this, new KatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739d5a15bef186a5386c75744c0527e1faa9f8726e462a12a4feb06bd8801e751e4")));
        }
        if (!(byArray != null && byArray.length != 0 || byArray2 != null && byArray2.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(XofUtils.leftEncode(this.rate / 8), this.encodeString(byArray), this.encodeString(byArray2));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int n = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length * 8);
        int n2 = this.diff.length % n;
        if (n2 != 0) {
            int n3;
            for (n3 = n - n2; n3 > padding.length; n3 -= padding.length) {
                this.absorb(padding, 0, padding.length * 8);
            }
            this.absorb(padding, 0, n3 * 8);
        }
    }

    private byte[] encodeString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return XofUtils.leftEncode(0L);
        }
        return Arrays.concatenate(XofUtils.leftEncode((long)byArray.length * 8L), byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "CSHAKE" + this.fixedOutputLength;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorb(ZERO_BYTE, 0, 2L);
            }
            this.squeeze(byArray, n, (long)n2 * 8L);
            return n2;
        }
        return super.doOutput(byArray, n, n2);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class KatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        KatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            digest.reset();
            return Arrays.areEqual(byArray, this.kat);
        }
    }
}

