/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.DrbgParameters;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.util.EntropyUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FipsSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final String algorithmName;
    private final DRBG drbg;
    private final boolean predictionResistant;

    FipsSecureRandom(SecureRandom secureRandom, String string, DRBG dRBG, EntropySource entropySource, boolean bl) {
        super(new Random11Spi(secureRandom, dRBG, entropySource, bl), new RandomProvider());
        this.randomSource = secureRandom;
        this.algorithmName = string;
        this.drbg = dRBG;
        this.predictionResistant = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeed(long l) {
        if (this.drbg != null) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                this.randomSource.setSeed(l);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] byArray, byte[] byArray2) {
        DRBG dRBG = this.drbg;
        synchronized (dRBG) {
            if (this.drbg.generate(byArray, byArray2, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(byArray, byArray2, this.predictionResistant);
            }
        }
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    public boolean isPredictionResistant() {
        return this.predictionResistant;
    }

    public byte[] getPersonalizationString() {
        return this.drbg.getPersonalizationString();
    }

    public int getSecurityStrength() {
        return this.drbg.getSecurityStrength();
    }

    @Override
    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] byArray) {
        this.drbg.reseed(byArray);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class RandomProvider
    extends Provider {
        RandomProvider() {
            super("BCFIPS_RNG", 1.0, "BCFIPS Secure Random Provider");
        }
    }

    private static class Random11Spi
    extends SecureRandomSpi {
        private final SecureRandom randomSource;
        private final DRBG drbg;
        private final EntropySource entropySource;
        private final boolean predictionResistant;

        Random11Spi(SecureRandom secureRandom, DRBG dRBG, EntropySource entropySource, boolean bl) {
            this.randomSource = secureRandom;
            this.drbg = dRBG;
            this.entropySource = entropySource;
            this.predictionResistant = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] byArray) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (this.randomSource != null) {
                    this.randomSource.setSeed(byArray);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] byArray, SecureRandomParameters secureRandomParameters) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (secureRandomParameters instanceof DrbgParameters.NextBytes) {
                    DrbgParameters.NextBytes nextBytes = (DrbgParameters.NextBytes)secureRandomParameters;
                    if (nextBytes.getStrength() > this.drbg.getSecurityStrength()) {
                        throw new IllegalArgumentException("maximum strength of DRBG is " + this.drbg.getSecurityStrength() + " bits");
                    }
                    if (nextBytes.getPredictionResistance() && !this.predictionResistant) {
                        throw new IllegalArgumentException("prediction resistance not available");
                    }
                    if (byArray == null) {
                        throw new NullPointerException("bytes cannot be null");
                    }
                    if (byArray.length != 0 && this.drbg.generate(byArray, nextBytes.getAdditionalInput(), this.predictionResistant) < 0) {
                        this.drbg.reseed(null);
                        this.drbg.generate(byArray, nextBytes.getAdditionalInput(), this.predictionResistant);
                    }
                } else {
                    throw new IllegalArgumentException("unrecognized DrbgParameters: " + secureRandomParameters.getClass());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] byArray) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (byArray == null) {
                    throw new NullPointerException("bytes cannot be null");
                }
                if (byArray.length != 0 && this.drbg.generate(byArray, null, this.predictionResistant) < 0) {
                    this.drbg.reseed(null);
                    this.drbg.generate(byArray, null, this.predictionResistant);
                }
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return EntropyUtil.generateSeed(this.entropySource, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineReseed(SecureRandomParameters secureRandomParameters) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (secureRandomParameters instanceof DrbgParameters.Reseed) {
                    DrbgParameters.Reseed reseed = (DrbgParameters.Reseed)secureRandomParameters;
                    if (reseed.getPredictionResistance() && !this.predictionResistant) {
                        throw new IllegalArgumentException("prediction resistance not available");
                    }
                    this.drbg.reseed(reseed.getAdditionalInput());
                } else {
                    if (secureRandomParameters != null) {
                        throw new IllegalArgumentException("unrecognized DrbgParameters: " + secureRandomParameters.getClass());
                    }
                    this.drbg.reseed(null);
                }
            }
        }

        @Override
        protected SecureRandomParameters engineGetParameters() {
            return DrbgParameters.instantiation(this.drbg.getSecurityStrength(), this.predictionResistant ? DrbgParameters.Capability.PR_AND_RESEED : DrbgParameters.Capability.RESEED_ONLY, this.drbg.getPersonalizationString());
        }
    }
}

