/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.script;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptChunk;

public class ScriptPattern {
    private static final byte[] SEGWIT_COMMITMENT_HEADER = Utils.HEX.decode((CharSequence)"aa21a9ed");

    public static boolean isP2PKH(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() != 5) {
            return false;
        }
        if (!chunks.get(0).equalsOpCode(118)) {
            return false;
        }
        if (!chunks.get(1).equalsOpCode(169)) {
            return false;
        }
        byte[] chunk2data = chunks.get((int)2).data;
        if (chunk2data == null) {
            return false;
        }
        if (chunk2data.length != 20) {
            return false;
        }
        if (!chunks.get(3).equalsOpCode(136)) {
            return false;
        }
        return chunks.get(4).equalsOpCode(172);
    }

    public static byte[] extractHashFromP2PKH(Script script) {
        return script.chunks.get((int)2).data;
    }

    public static boolean isP2SH(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() != 3) {
            return false;
        }
        if (!chunks.get(0).equalsOpCode(169)) {
            return false;
        }
        ScriptChunk chunk1 = chunks.get(1);
        if (chunk1.opcode != 20) {
            return false;
        }
        byte[] chunk1data = chunk1.data;
        if (chunk1data == null) {
            return false;
        }
        if (chunk1data.length != 20) {
            return false;
        }
        return chunks.get(2).equalsOpCode(135);
    }

    public static byte[] extractHashFromP2SH(Script script) {
        return script.chunks.get((int)1).data;
    }

    public static boolean isP2PK(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() != 2) {
            return false;
        }
        ScriptChunk chunk0 = chunks.get(0);
        if (chunk0.isOpCode()) {
            return false;
        }
        byte[] chunk0data = chunk0.data;
        if (chunk0data == null) {
            return false;
        }
        if (chunk0data.length <= 1) {
            return false;
        }
        return chunks.get(1).equalsOpCode(172);
    }

    public static byte[] extractKeyFromP2PK(Script script) {
        return script.chunks.get((int)0).data;
    }

    public static boolean isP2WH(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() != 2) {
            return false;
        }
        if (!chunks.get(0).equalsOpCode(0)) {
            return false;
        }
        byte[] chunk1data = chunks.get((int)1).data;
        if (chunk1data == null) {
            return false;
        }
        return chunk1data.length == 20 || chunk1data.length == 32;
    }

    public static boolean isP2WPKH(Script script) {
        if (!ScriptPattern.isP2WH(script)) {
            return false;
        }
        List<ScriptChunk> chunks = script.chunks;
        if (!chunks.get(0).equalsOpCode(0)) {
            return false;
        }
        byte[] chunk1data = chunks.get((int)1).data;
        return chunk1data != null && chunk1data.length == 20;
    }

    public static boolean isP2WSH(Script script) {
        if (!ScriptPattern.isP2WH(script)) {
            return false;
        }
        List<ScriptChunk> chunks = script.chunks;
        if (!chunks.get(0).equalsOpCode(0)) {
            return false;
        }
        byte[] chunk1data = chunks.get((int)1).data;
        return chunk1data != null && chunk1data.length == 32;
    }

    public static byte[] extractHashFromP2WH(Script script) {
        return script.chunks.get((int)1).data;
    }

    public static boolean isSentToMultisig(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() < 4) {
            return false;
        }
        ScriptChunk chunk = chunks.get(chunks.size() - 1);
        if (!chunk.isOpCode()) {
            return false;
        }
        if (!chunk.equalsOpCode(174) && !chunk.equalsOpCode(175)) {
            return false;
        }
        try {
            ScriptChunk m = chunks.get(chunks.size() - 2);
            if (!m.isOpCode()) {
                return false;
            }
            int numKeys = Script.decodeFromOpN(m.opcode);
            if (numKeys < 1 || chunks.size() != 3 + numKeys) {
                return false;
            }
            for (int i = 1; i < chunks.size() - 2; ++i) {
                if (!chunks.get(i).isOpCode()) continue;
                return false;
            }
            if (Script.decodeFromOpN(chunks.get((int)0).opcode) < 1) {
                return false;
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public static boolean isSentToCltvPaymentChannel(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() != 10) {
            return false;
        }
        if (!chunks.get(0).equalsOpCode(99)) {
            return false;
        }
        if (!chunks.get(2).equalsOpCode(173)) {
            return false;
        }
        if (!chunks.get(3).equalsOpCode(103)) {
            return false;
        }
        if (!chunks.get(5).equalsOpCode(177)) {
            return false;
        }
        if (!chunks.get(6).equalsOpCode(117)) {
            return false;
        }
        if (!chunks.get(7).equalsOpCode(104)) {
            return false;
        }
        return chunks.get(9).equalsOpCode(172);
    }

    public static byte[] extractSenderPubKeyFromCltvPaymentChannel(Script script) {
        return script.chunks.get((int)8).data;
    }

    public static byte[] extractRecipientPubKeyFromCltvPaymentChannel(Script script) {
        return script.chunks.get((int)1).data;
    }

    public static BigInteger extractExpiryFromCltvPaymentChannel(Script script) {
        return Script.castToBigInteger(script.chunks.get((int)4).data, 5, false);
    }

    public static boolean isOpReturn(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        return chunks.size() > 0 && chunks.get(0).equalsOpCode(106);
    }

    public static boolean isWitnessCommitment(Script script) {
        List<ScriptChunk> chunks = script.chunks;
        if (chunks.size() < 2) {
            return false;
        }
        if (!chunks.get(0).equalsOpCode(106)) {
            return false;
        }
        byte[] chunkData = chunks.get((int)1).data;
        if (chunkData == null || chunkData.length != 36) {
            return false;
        }
        return Arrays.equals(Arrays.copyOfRange(chunkData, 0, 4), SEGWIT_COMMITMENT_HEADER);
    }

    public static Sha256Hash extractWitnessCommitmentHash(Script script) {
        return Sha256Hash.wrap(Arrays.copyOfRange(script.chunks.get((int)1).data, 4, 36));
    }
}

