/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.protocols.channels.ServerState;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPaymentChannelServerStates
implements WalletExtension {
    private static final Logger log = LoggerFactory.getLogger(StoredPaymentChannelServerStates.class);
    static final String EXTENSION_ID = StoredPaymentChannelServerStates.class.getName();
    static final int MAX_SECONDS_TO_WAIT_FOR_BROADCASTER_TO_BE_SET = 10;
    @GuardedBy(value="lock")
    @VisibleForTesting
    final Map<Sha256Hash, StoredServerChannel> mapChannels = new HashMap<Sha256Hash, StoredServerChannel>();
    private Wallet wallet;
    private final SettableFuture<TransactionBroadcaster> broadcasterFuture = SettableFuture.create();
    private final Timer channelTimeoutHandler = new Timer(true);
    private final ReentrantLock lock = Threading.lock("StoredPaymentChannelServerStates");
    public static final long CHANNEL_EXPIRE_OFFSET = -7200L;

    public StoredPaymentChannelServerStates(@Nullable Wallet wallet, TransactionBroadcaster broadcaster) {
        this.setTransactionBroadcaster(broadcaster);
        this.wallet = wallet;
    }

    public StoredPaymentChannelServerStates(@Nullable Wallet wallet) {
        this.wallet = wallet;
    }

    public final void setTransactionBroadcaster(TransactionBroadcaster broadcaster) {
        this.broadcasterFuture.set(Preconditions.checkNotNull((Object)broadcaster));
    }

    @Nullable
    public static StoredPaymentChannelServerStates getFromWallet(Wallet wallet) {
        return (StoredPaymentChannelServerStates)wallet.getExtensions().get(EXTENSION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(StoredServerChannel channel) {
        this.lock.lock();
        try {
            if (this.mapChannels.remove(channel.contract.getTxId()) == null) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        StoredServerChannel storedServerChannel = channel;
        synchronized (storedServerChannel) {
            channel.closeConnectedHandler();
            try {
                TransactionBroadcaster broadcaster = this.getBroadcaster();
                channel.getOrCreateState(this.wallet, broadcaster).close();
            }
            catch (InsufficientMoneyException e) {
                log.error("Exception when closing channel", (Throwable)e);
            }
            catch (VerificationException e) {
                log.error("Exception when closing channel", (Throwable)e);
            }
            channel.state = null;
        }
        this.updatedChannel(channel);
    }

    private TransactionBroadcaster getBroadcaster() {
        try {
            return (TransactionBroadcaster)this.broadcasterFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            String err = "Transaction broadcaster not set";
            log.error(err);
            throw new RuntimeException(err, e);
        }
    }

    public StoredServerChannel getChannel(Sha256Hash id) {
        this.lock.lock();
        try {
            StoredServerChannel storedServerChannel = this.mapChannels.get(id);
            return storedServerChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<Sha256Hash, StoredServerChannel> getChannelMap() {
        this.lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.mapChannels);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updatedChannel(StoredServerChannel channel) {
        log.info("Stored server channel {} was updated", (Object)channel.hashCode());
        this.wallet.addOrUpdateExtension(this);
    }

    public void putChannel(final StoredServerChannel channel) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((this.mapChannels.put(channel.contract.getTxId(), (StoredServerChannel)Preconditions.checkNotNull((Object)channel)) == null ? 1 : 0) != 0);
            Date autocloseTime = new Date((channel.refundTransactionUnlockTimeSecs + -7200L) * 1000L + (System.currentTimeMillis() - Utils.currentTimeMillis()));
            log.info("Scheduling channel for automatic closure at {}: {}", (Object)autocloseTime, (Object)channel);
            this.channelTimeoutHandler.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.info("Auto-closing channel: {}", (Object)channel);
                    try {
                        StoredPaymentChannelServerStates.this.closeChannel(channel);
                    }
                    catch (Exception e) {
                        log.error("Auto-closing channel failed", (Throwable)e);
                    }
                }
            }, autocloseTime);
        }
        finally {
            this.lock.unlock();
        }
        this.updatedChannel(channel);
    }

    @Override
    public String getWalletExtensionID() {
        return EXTENSION_ID;
    }

    @Override
    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeWalletExtension() {
        this.lock.lock();
        try {
            NetworkParameters params = this.getNetworkParameters();
            boolean hasMaxMoney = params != null ? params.hasMaxMoney() : true;
            Coin networkMaxMoney = params != null ? params.getMaxMoney() : NetworkParameters.MAX_MONEY;
            ServerState.StoredServerPaymentChannels.Builder builder = ServerState.StoredServerPaymentChannels.newBuilder();
            for (StoredServerChannel channel : this.mapChannels.values()) {
                Preconditions.checkState((channel.bestValueToMe.signum() >= 0 && (!hasMaxMoney || channel.bestValueToMe.compareTo(networkMaxMoney) <= 0) ? 1 : 0) != 0);
                Preconditions.checkState((channel.refundTransactionUnlockTimeSecs > 0L ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPrivKeyBytes());
                ServerState.StoredServerPaymentChannel.Builder channelBuilder = ServerState.StoredServerPaymentChannel.newBuilder().setMajorVersion(channel.majorVersion).setBestValueToMe(channel.bestValueToMe.value).setRefundTransactionUnlockTimeSecs(channel.refundTransactionUnlockTimeSecs).setContractTransaction(ByteString.copyFrom((byte[])channel.contract.unsafeBitcoinSerialize())).setMyKey(ByteString.copyFrom((byte[])channel.myKey.getPrivKeyBytes()));
                if (channel.majorVersion == 1) {
                    channelBuilder.setClientOutput(ByteString.copyFrom((byte[])channel.clientOutput.unsafeBitcoinSerialize()));
                } else {
                    channelBuilder.setClientKey(ByteString.copyFrom((byte[])channel.clientKey.getPubKey()));
                }
                if (channel.bestValueSignature != null) {
                    channelBuilder.setBestValueSignature(ByteString.copyFrom((byte[])channel.bestValueSignature));
                }
                builder.addChannels(channelBuilder);
            }
            Object object = builder.build().toByteArray();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeWalletExtension(Wallet containingWallet, byte[] data) throws Exception {
        this.lock.lock();
        try {
            this.wallet = containingWallet;
            ServerState.StoredServerPaymentChannels states = ServerState.StoredServerPaymentChannels.parseFrom(data);
            NetworkParameters params = containingWallet.getParams();
            for (ServerState.StoredServerPaymentChannel storedState : states.getChannelsList()) {
                int majorVersion = storedState.getMajorVersion();
                TransactionOutput clientOutput = null;
                ECKey clientKey = null;
                if (majorVersion == 1) {
                    clientOutput = new TransactionOutput(params, null, storedState.getClientOutput().toByteArray(), 0);
                } else {
                    clientKey = ECKey.fromPublicOnly(storedState.getClientKey().toByteArray());
                }
                StoredServerChannel channel = new StoredServerChannel(null, majorVersion, params.getDefaultSerializer().makeTransaction(storedState.getContractTransaction().toByteArray()), clientOutput, storedState.getRefundTransactionUnlockTimeSecs(), ECKey.fromPrivate(storedState.getMyKey().toByteArray()), clientKey, Coin.valueOf(storedState.getBestValueToMe()), storedState.hasBestValueSignature() ? storedState.getBestValueSignature().toByteArray() : null);
                this.putChannel(channel);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder buf = new StringBuilder();
            for (StoredServerChannel stored : this.mapChannels.values()) {
                buf.append(stored);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    private NetworkParameters getNetworkParameters() {
        return this.wallet != null ? this.wallet.getNetworkParameters() : null;
    }
}

