/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.RejectedTransactionException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBroadcast {
    private static final Logger log = LoggerFactory.getLogger(TransactionBroadcast.class);
    private final SettableFuture<Transaction> future = SettableFuture.create();
    private final PeerGroup peerGroup;
    private final Transaction tx;
    private int minConnections;
    private boolean dropPeersAfterBroadcast = false;
    private int numWaitingFor;
    @VisibleForTesting
    public static Random random = new Random();
    private Map<Peer, RejectMessage> rejects = Collections.synchronizedMap(new HashMap());
    private PreMessageReceivedEventListener rejectionListener = new PreMessageReceivedEventListener(){

        @Override
        public Message onPreMessageReceived(Peer peer, Message m) {
            if (m instanceof RejectMessage) {
                RejectMessage rejectMessage = (RejectMessage)m;
                if (TransactionBroadcast.this.tx.getTxId().equals(rejectMessage.getRejectedObjectHash())) {
                    TransactionBroadcast.this.rejects.put(peer, rejectMessage);
                    int size = TransactionBroadcast.this.rejects.size();
                    long threshold = Math.round((double)TransactionBroadcast.this.numWaitingFor / 2.0);
                    if ((long)size > threshold) {
                        log.warn("Threshold for considering broadcast rejected has been reached ({}/{})", (Object)size, (Object)threshold);
                        TransactionBroadcast.this.future.setException((Throwable)new RejectedTransactionException(TransactionBroadcast.this.tx, rejectMessage));
                        TransactionBroadcast.this.peerGroup.removePreMessageReceivedEventListener(this);
                    }
                }
            }
            return m;
        }
    };
    private int numSeemPeers;
    private boolean mined;
    @Nullable
    private ProgressCallback callback;
    @Nullable
    private Executor progressCallbackExecutor;

    TransactionBroadcast(PeerGroup peerGroup, Transaction tx) {
        this.peerGroup = peerGroup;
        this.tx = tx;
        this.minConnections = Math.max(1, peerGroup.getMinBroadcastConnections());
    }

    private TransactionBroadcast(Transaction tx) {
        this.peerGroup = null;
        this.tx = tx;
    }

    @VisibleForTesting
    public static TransactionBroadcast createMockBroadcast(Transaction tx, final SettableFuture<Transaction> future) {
        return new TransactionBroadcast(tx){

            @Override
            public ListenableFuture<Transaction> broadcast() {
                return future;
            }

            @Override
            public ListenableFuture<Transaction> future() {
                return future;
            }
        };
    }

    public ListenableFuture<Transaction> future() {
        return this.future;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setDropPeersAfterBroadcast(boolean dropPeersAfterBroadcast) {
        this.dropPeersAfterBroadcast = dropPeersAfterBroadcast;
    }

    public ListenableFuture<Transaction> broadcast() {
        this.peerGroup.addPreMessageReceivedEventListener(Threading.SAME_THREAD, this.rejectionListener);
        log.info("Waiting for {} peers required for broadcast, we have {} ...", (Object)this.minConnections, (Object)this.peerGroup.getConnectedPeers().size());
        this.peerGroup.waitForPeers(this.minConnections).addListener((Runnable)new EnoughAvailablePeers(), Threading.SAME_THREAD);
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndRecord(int numSeenPeers, boolean mined) {
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            this.numSeemPeers = numSeenPeers;
            this.mined = mined;
        }
        this.invokeProgressCallback(numSeenPeers, mined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeProgressCallback(int numSeenPeers, boolean mined) {
        Executor executor;
        ProgressCallback callback;
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            callback = this.callback;
            executor = this.progressCallbackExecutor;
        }
        if (callback != null) {
            final double progress = Math.min(1.0, mined ? 1.0 : (double)numSeenPeers / (double)this.numWaitingFor);
            Preconditions.checkState((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (Object)progress);
            try {
                if (executor == null) {
                    callback.onBroadcastProgress(progress);
                } else {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onBroadcastProgress(progress);
                        }
                    });
                }
            }
            catch (Throwable e) {
                log.error("Exception during progress callback", e);
            }
        }
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.setProgressCallback(callback, Threading.USER_THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressCallback(ProgressCallback callback, @Nullable Executor executor) {
        boolean shouldInvoke;
        boolean mined;
        int num;
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            this.callback = callback;
            this.progressCallbackExecutor = executor;
            num = this.numSeemPeers;
            mined = this.mined;
            shouldInvoke = this.numWaitingFor > 0;
        }
        if (shouldInvoke) {
            this.invokeProgressCallback(num, mined);
        }
    }

    public static interface ProgressCallback {
        public void onBroadcastProgress(double var1);
    }

    private class ConfidenceChange
    implements TransactionConfidence.Listener {
        private ConfidenceChange() {
        }

        @Override
        public void onConfidenceChanged(TransactionConfidence conf, TransactionConfidence.Listener.ChangeReason reason) {
            int numSeenPeers = conf.numBroadcastPeers() + TransactionBroadcast.this.rejects.size();
            boolean mined = TransactionBroadcast.this.tx.getAppearsInHashes() != null;
            log.info("broadcastTransaction: {}:  TX {} seen by {} peers{}", new Object[]{reason, TransactionBroadcast.this.tx.getTxId(), numSeenPeers, mined ? " and mined" : ""});
            TransactionBroadcast.this.invokeAndRecord(numSeenPeers, mined);
            if (numSeenPeers >= TransactionBroadcast.this.numWaitingFor || mined) {
                log.info("broadcastTransaction: {} complete", (Object)TransactionBroadcast.this.tx.getTxId());
                TransactionBroadcast.this.peerGroup.removePreMessageReceivedEventListener(TransactionBroadcast.this.rejectionListener);
                conf.removeEventListener(this);
                TransactionBroadcast.this.future.set((Object)TransactionBroadcast.this.tx);
            }
        }
    }

    private class EnoughAvailablePeers
    implements Runnable {
        private Context context = Context.get();

        @Override
        public void run() {
            Context.propagate(this.context);
            List<Peer> peers = TransactionBroadcast.this.peerGroup.getConnectedPeers();
            TransactionBroadcast.this.tx.getConfidence().addEventListener(new ConfidenceChange());
            int numConnected = peers.size();
            int numToBroadcastTo = (int)Math.max(1L, Math.round(Math.ceil((double)peers.size() / 2.0)));
            TransactionBroadcast.this.numWaitingFor = (int)Math.ceil((double)(peers.size() - numToBroadcastTo) / 2.0);
            Collections.shuffle(peers, random);
            peers = peers.subList(0, numToBroadcastTo);
            log.info("broadcastTransaction: We have {} peers, adding {} to the memory pool", (Object)numConnected, (Object)TransactionBroadcast.this.tx.getTxId());
            log.info("Sending to {} peers, will wait for {}, sending to: {}", new Object[]{numToBroadcastTo, TransactionBroadcast.this.numWaitingFor, Joiner.on((String)",").join(peers)});
            for (final Peer peer : peers) {
                try {
                    ListenableFuture future = peer.sendMessage(TransactionBroadcast.this.tx);
                    if (!TransactionBroadcast.this.dropPeersAfterBroadcast) continue;
                    future.addListener(new Runnable(){

                        @Override
                        public void run() {
                            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                            peer.close();
                        }
                    }, (Executor)Threading.THREAD_POOL);
                }
                catch (Exception e) {
                    log.error("Caught exception sending to {}", (Object)peer, (Object)e);
                }
            }
        }
    }
}

